package jp.gopay.sdk.resources;

import jp.gopay.sdk.models.common.TransferId;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.transfer.Transfer;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

import javax.annotation.Nullable;

/**
 * Resource for managing transfers.
 */
public interface TransfersResource{
    @GET("/transfers")
    Call<PaginatedList<Transfer>> list(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable TransferId cursor
            );

    @GET("/transfers/{transferId}")
    Call<Transfer> get(
            @Path("transferId") TransferId transferId
    );

}