package jp.gopay.sdk.resources;

import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.common.WebhookId;
import jp.gopay.sdk.models.request.store.WebhookReq;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.webhook.Webhook;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

import static jp.gopay.sdk.constants.GopayConstants.idempotencyKeyHeaderName;

/**
 * Resources for managing webhooks associated with the merchant's stores.
 */
public interface WebhooksResource {
    @GET("/webhooks")
    Call<PaginatedList<Webhook>> list(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable WebhookId cursor
    );

    @GET("/webhooks/{webhookId}")
    Call<Webhook> get(
            @Path("webhookId") WebhookId webhookId
    );

    @POST("/webhooks")
    Call<Webhook> create(
            @Body WebhookReq dataToPost,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @PATCH("/webhooks/{webhookId}")
    Call<Webhook> update(
            @Path("webhookId") WebhookId webhookId,
            @Body WebhookReq dataToPost,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @DELETE("/webhooks/{webhookId}")
    Call<Void> delete(
            @Path("webhookId") WebhookId webhookId
    );

    @GET("/stores/{storeId}/webhooks")
    Call<PaginatedList<Webhook>> list(
            @Path("storeId") StoreId storeId,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable WebhookId cursor
    );

    @POST("/stores/{storeId}/webhooks")
    Call<Webhook> create(
            @Path("storeId") StoreId storeId,
            @Body WebhookReq dataToPost,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @GET("/stores/{storeId}/webhooks/{webhookId}")
    Call<Webhook> get(
            @Path("storeId") StoreId storeId,
            @Path("webhookId") WebhookId webhookId
    );

    @PATCH("/stores/{storeId}/webhooks/{webhookId}")
    Call<Webhook> update(
            @Path("storeId") StoreId storeId,
            @Path("webhookId") WebhookId webhookId,
            @Body WebhookReq dataToPost,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @DELETE("/stores/{storeId}/webhooks/{webhookId}")
    Call<Void> delete(
            @Path("storeId") StoreId storeId,
            @Path("webhookId") WebhookId webhookId
    );
}
