package jp.gopay.sdk.settings;

import jp.gopay.sdk.models.common.auth.AuthStrategy;
import jp.gopay.sdk.utils.GoPayClient;
import okhttp3.OkHttpClient;

public class GoPaySettings extends AbstractSDKSettings<GoPaySettings> {

    @Override
    public GoPaySettings copy() {
        return new GoPaySettings()
                .withEndpoint(this.endpoint)
                .withTimeoutSeconds(this.timeout)
                .attachOrigin(this.origin);
    }

    @Override
    public OkHttpClient getClient(AuthStrategy authStrategy){
        return GoPayClient
                .getDefaultClientBuilder(authStrategy, this)
                .build();
    }
}
