package jp.gopay.sdk.types;

public enum Country {
    AFGHANISTAN                      ("Afghanistan", 4, "AF", "AFG"),
    ALAND_ISLANDS                    ("Åland Islands", 248, "AX", "ALA"),
    ALBANIA                          ("Albania", 8, "AL", "ALB"),
    ALGERIA                          ("Algeria", 12, "DZ", "DZA"),
    AMERICAN_SAMOA                   ("American Samoa", 16, "AS", "ASM"),
    ANDORRA                          ("Andorra", 20, "AD", "AND"),
    ANGOLA                           ("Angola", 24, "AO", "AGO"),
    ANGUILLA                         ("Anguilla", 660, "AI", "AIA"),
    ANTIGUA_AND_BARBUDA              ("Antigua and Barbuda", 28, "AG", "ATG"),
    ARGENTINA                        ("Argentina", 32, "AR", "ARG"),
    ARMENIA                          ("Armenia", 51, "AM", "ARM"),
    ARUBA                            ("Aruba", 533, "AW", "ABW"),
    AUSTRALIA                        ("Australia", 36, "AU", "AUS"),
    AUSTRIA                          ("Austria", 40, "AT", "AUT"),
    AZERBAIJAN                       ("Azerbaijan", 31, "AZ", "AZE"),
    BAHAMAS                          ("Bahamas", 44, "BS", "BHS"),
    BAHRAIN                          ("Bahrain", 48, "BH", "BHR"),
    BANGLADESH                       ("Bangladesh", 50, "BD", "BGD"),
    BARBADOS                         ("Barbados", 52, "BB", "BRB"),
    BELARUS                          ("Belarus", 112, "BY", "BLR"),
    BELGIUM                          ("Belgium", 56, "BE", "BEL"),
    BELIZE                           ("Belize", 84, "BZ", "BLZ"),
    BENIN                            ("Benin", 204, "BJ", "BEN"),
    BERMUDA                          ("Bermuda", 60, "BM", "BMU"),
    BHUTAN                           ("Bhutan", 64, "BT", "BTN"),
    BOLIVIA                          ("Bolivia", 68, "BO", "BOL"),
    BONAIRE_SINT_EUSTATIUS_AND_SABA  ("Bonaire, Sint Eustatius and Saba", 535, "BQ", "BES"),
    BOSNIA_AND_HERZEGOVINA           ("Bosnia and Herzegovina", 70, "BA", "BIH"),
    BOTSWANA                         ("Botswana", 72, "BW", "BWA"),
    BRAZIL                           ("Brazil", 76, "BR", "BRA"),
    BRITISH_INDIAN_OCEAN_TERRITORY   ("British Indian Ocean Territory", 86, "IO", "IOT"),
    BRUNEI_DARUSSALAM                ("Brunei Darussalam", 96, "BN", "BRN"),
    BULGARIA                         ("Bulgaria", 100, "BG", "BGR"),
    BURKINA_FASO                     ("Burkina Faso", 854, "BF", "BFA"),
    BURUNDI                          ("Burundi", 108, "BI", "BDI"),
    CABO_VERDE                       ("Cabo Verde", 132, "CV", "CPV"),
    CAMBODIA                         ("Cambodia", 116, "KH", "KHM"),
    CAMEROON                         ("Cameroon", 120, "CM", "CMR"),
    CANADA                           ("Canada", 124, "CA", "CAN"),
    CAYMAN_ISLANDS                   ("Cayman Islands", 136, "KY", "CYM"),
    CENTRAL_AFRICAN_REPUBLIC         ("Central African Republic", 140, "CF", "CAF"),
    CHAD                             ("Chad", 148, "TD", "TCD"),
    CHILE                            ("Chile", 152, "CL", "CHL"),
    CHINA                            ("China", 156, "CN", "CHN"),
    CHRISTMAS_ISLAND                 ("Christmas Island", 162, "CX", "CXR"),
    COCOS_ISLANDS                    ("Cocos (Keeling) Islands", 166, "CC", "CCK"),
    COLOMBIA                         ("Colombia", 170, "CO", "COL"),
    COMOROS                          ("Comoros", 174, "KM", "COM"),
    DEMOCRATIC_REPUBLIC_CONGO        ("Congo (the Democratic Republic of the)", 180, "CD", "COD"),
    CONGO                            ("Congo", 178, "CG", "COG"),
    COOK_ISLANDS                     ("Cook Islands", 184, "CK", "COK"),
    COSTA_RICA                       ("Costa Rica", 188, "CR", "CRI"),
    IVORY_COAST                      ("Côte d'Ivoire", 384, "CI", "CIV"),
    CROATIA                          ("Croatia", 191, "HR", "HRV"),
    CUBA                             ("Cuba", 192, "CU", "CUB"),
    CURACAO                          ("Curacao", 531, "CW", "CUW"),
    CYPRUS                           ("Cyprus", 196, "CY", "CYP"),
    CZECH_REPUBLIC                   ("Czech Republic", 203, "CZ", "CZE"),
    DENMARK                          ("Denmark", 208, "DK", "DNK"),
    DJIBOUTI                         ("Djibouti", 262, "DJ", "DJI"),
    DOMINICA                         ("Dominica", 212, "DM", "DMA"),
    DOMINICAN_REPUBLIC               ("Dominican Republic", 214, "DO", "DOM"),
    ECUADOR                          ("Ecuador", 218, "EC", "ECU"),
    EGYPT                            ("Egypt", 818, "EG", "EGY"),
    EL_SALVADOR                      ("El Salvador", 222, "SV", "SLV"),
    EQUATORIAL_GUINEA                ("Equatorial Guinea", 226, "GQ", "GNQ"),
    ERITREA                          ("Eritrea", 232, "ER", "ERI"),
    ESTONIA                          ("Estonia", 233, "EE", "EST"),
    ETHIOPIA                         ("Ethiopia", 231, "ET", "ETH"),
    FALKLAND_ISLANDS                 ("Falkland Islands", 238, "FK", "FLK"),
    FAROE_ISLANDS                    ("Faroe Islands", 234, "FO", "FRO"),
    FIJI                             ("Fiji", 242, "FJ", "FJI"),
    FINLAND                          ("Finland", 246, "FI", "FIN"),
    FRANCE                           ("France", 250, "FR", "FRA"),
    FRENCH_GUIANA                    ("French Guiana", 254, "GF", "GUF"),
    FRENCH_POLYNESIA                 ("French Polynesia", 258, "PF", "PYF"),
    GABON                            ("Gabon", 266, "GA", "GAB"),
    GAMBIA                           ("Gambia", 270, "GM", "GMB"),
    GEORGIA                          ("Georgia", 268, "GE", "GEO"),
    GERMANY                          ("Germany", 276, "DE", "DEU"),
    GHANA                            ("Ghana", 288, "GH", "GHA"),
    GIBRALTAR                        ("Gibraltar", 292, "GI", "GIB"),
    GREECE                           ("Greece", 300, "GR", "GRC"),
    GREENLAND                        ("Greenland", 304, "GL", "GRL"),
    GRENADA                          ("Grenada", 308, "GD", "GRD"),
    GUADELOUPE                       ("Guadeloupe", 312, "GP", "GLP"),
    GUAM                             ("Guam", 316, "GU", "GUM"),
    GUATEMALA                        ("Guatemala", 320, "GT", "GTM"),
    GUERNSEY                         ("Guernsey", 831, "GG", "GGY"),
    GUINEA                           ("Guinea", 324, "GN", "GIN"),
    GUINEA_BISSAU                    ("Guinea-Bissau", 624, "GW", "GNB"),
    GUYANA                           ("Guyana", 328, "GY", "GUY"),
    HAITI                            ("Haiti", 332, "HT", "HTI"),
    VATICAN                          ("Holy See (Vatican)", 336, "VA", "VAT"),
    HONDURAS                         ("Honduras", 340, "HN", "HND"),
    HONG_KONG                        ("Hong Kong", 344, "HK", "HKG"),
    HUNGARY                          ("Hungary", 348, "HU", "HUN"),
    ICELAND                          ("Iceland", 352, "IS", "ISL"),
    INDIA                            ("India", 356, "IN", "IND"),
    INDONESIA                        ("Indonesia", 360, "ID", "IDN"),
    IRAN                             ("Iran", 364, "IR", "IRN"),
    IRAQ                             ("Iraq", 368, "IQ", "IRQ"),
    IRELAND                          ("Ireland", 372, "IE", "IRL"),
    ISLE_OF_MAN                      ("Isle of Man", 833, "IM", "IMN"),
    ISRAEL                           ("Israel", 376, "IL", "ISR"),
    ITALY                            ("Italy", 380, "IT", "ITA"),
    JAMAICA                          ("Jamaica", 388, "JM", "JAM"),
    JAPAN                            ("Japan", 392, "JP", "JPN"),
    JERSEY                           ("Jersey", 832, "JE", "JEY"),
    JORDAN                           ("Jordan", 400, "JO", "JOR"),
    KAZAKHSTAN                       ("Kazakhstan", 398, "KZ", "KAZ"),
    KENYA                            ("Kenya", 404, "KE", "KEN"),
    KIRIBATI                         ("Kiribati", 296, "KI", "KIR"),
    NORTH_KOREA                      ("North Korea", 408, "KP", "PRK"),
    SOUTH_KOREA                      ("South Korea", 410, "KR", "KOR"),
    KUWAIT                           ("Kuwait", 414, "KW", "KWT"),
    KYRGYZSTAN                       ("Kyrgyzstan", 417, "KG", "KGZ"),
    LAOS                             ("Lao People's Democratic Republic", 418, "LA", "LAO"),
    LATVIA                           ("Latvia", 428, "LV", "LVA"),
    LEBANON                          ("Lebanon", 422, "LB", "LBN"),
    LESOTHO                          ("Lesotho", 426, "LS", "LSO"),
    LIBERIA                          ("Liberia", 430, "LR", "LBR"),
    LIBYA                            ("Libya", 434, "LY", "LBY"),
    LIECHTENSTEIN                    ("Liechtenstein", 438, "LI", "LIE"),
    LITHUANIA                        ("Lithuania", 440, "LT", "LTU"),
    LUXEMBOURG                       ("Luxembourg", 442, "LU", "LUX"),
    MACAO                            ("Macao", 446, "MO", "MAC"),
    MACEDONIA                        ("Macedonia", 807, "MK", "MKD"),
    MADAGASCAR                       ("Madagascar", 450, "MG", "MDG"),
    MALAWI                           ("Malawi", 454, "MW", "MWI"),
    MALAYSIA                         ("Malaysia", 458, "MY", "MYS"),
    MALDIVES                         ("Maldives", 462, "MV", "MDV"),
    MALI                             ("Mali", 466, "ML", "MLI"),
    MALTA                            ("Malta", 470, "MT", "MLT"),
    MARSHALL_ISLANDS                 ("Marshall Islands", 584, "MH", "MHL"),
    MARTINIQUE                       ("Martinique", 474, "MQ", "MTQ"),
    MAURITANIA                       ("Mauritania", 478, "MR", "MRT"),
    MAURITIUS                        ("Mauritius", 480, "MU", "MUS"),
    MAYOTTE                          ("Mayotte", 175, "YT", "MYT"),
    MEXICO                           ("Mexico", 484, "MX", "MEX"),
    MICRONESIA                       ("Micronesia (Federated States of)", 583, "FM", "FSM"),
    MOLDOVA                          ("Moldova (the Republic of)", 498, "MD", "MDA"),
    MONACO                           ("Monaco", 492, "MC", "MCO"),
    MONGOLIA                         ("Mongolia", 496, "MN", "MNG"),
    MONTENEGRO                       ("Montenegro", 499, "ME", "MNE"),
    MONTSERRAT                       ("Montserrat", 500, "MS", "MSR"),
    MOROCCO                          ("Morocco", 504, "MA", "MAR"),
    MOZAMBIQUE                       ("Mozambique", 508, "MZ", "MOZ"),
    MYANMAR                          ("Myanmar", 104, "MM", "MMR"),
    NAMIBIA                          ("Namibia", 516, "NA", "NAM"),
    NAURU                            ("Nauru", 520, "NR", "NRU"),
    NEPAL                            ("Nepal", 524, "NP", "NPL"),
    NETHERLANDS                      ("Netherlands", 528, "NL", "NLD"),
    NEW_CALEDONIA                    ("New Caledonia", 540, "NC", "NCL"),
    NEW_ZEALAND                      ("New Zealand", 554, "NZ", "NZL"),
    NICARAGUA                        ("Nicaragua", 558, "NI", "NIC"),
    NIGER                            ("Niger", 562, "NE", "NER"),
    NIGERIA                          ("Nigeria", 566, "NG", "NGA"),
    NIUE                             ("Niue", 570, "NU", "NIU"),
    NORFOLK_ISLAND                   ("Norfolk Island", 574, "NF", "NFK"),
    NORTHERN_MARIANA_ISLANDS         ("Northern Mariana Islands", 580, "MP", "MNP"),
    NORWAY                           ("Norway", 578, "NO", "NOR"),
    OMAN                             ("Oman", 512, "OM", "OMN"),
    PAKISTAN                         ("Pakistan", 586, "PK", "PAK"),
    PALAU                            ("Palau", 585, "PW", "PLW"),
    PALESTINE                        ("Palestine, State of", 275, "PS", "PSE"),
    PANAMA                           ("Panama", 591, "PA", "PAN"),
    PAPUA_NEW_GUINEA                 ("Papua New Guinea", 598, "PG", "PNG"),
    PARAGUAY                         ("Paraguay", 600, "PY", "PRY"),
    PERU                             ("Peru", 604, "PE", "PER"),
    PHILIPPINES                      ("Philippines", 608, "PH", "PHL"),
    POLAND                           ("Poland", 616, "PL", "POL"),
    PORTUGAL                         ("Portugal", 620, "PT", "PRT"),
    PUERTO_RICO                      ("Puerto Rico", 630, "PR", "PRI"),
    QATAR                            ("Qatar", 634, "QA", "QAT"),
    REUNION                          ("Réunion", 638, "RE", "REU"),
    ROMANIA                          ("Romania", 642, "RO", "ROU"),
    RUSSIA                           ("Russian Federation", 643, "RU", "RUS"),
    RWANDA                           ("Rwanda", 646, "RW", "RWA"),
    SAINT_BARTHELEMY                 ("Saint Barthélemy", 652, "BL", "BLM"),
    SAINT_HELENA                     ("Saint Helena, Ascension and Tristan da Cunha", 654, "SH", "SHN"),
    SAINT_KITTS_NEVIS                ("Saint Kitts and Nevis", 659, "KN", "KNA"),
    SAINT_LUCIA                      ("Saint Lucia", 662, "LC", "LCA"),
    SAINT_MARTIN                     ("Saint Martin", 663, "MF", "MAF"),
    SAINT_PIERRE_AND_MIQUELON        ("Saint Pierre and Miquelon", 666, "PM", "SPM"),
    SAINT_VINCENT_GRENADINES         ("Saint Vincent and the Grenadines", 670, "VC", "VCT"),
    SAMOA                            ("Samoa", 882, "WS", "WSM"),
    SAN_MARINO                       ("San Marino", 674, "SM", "SMR"),
    SAO_TOME_AND_PRINCIPE            ("Sao Tome and Principe", 678, "ST", "STP"),
    SAUDI_ARABIA                     ("Saudi Arabia", 682, "SA", "SAU"),
    SENEGAL                          ("Senegal", 686, "SN", "SEN"),
    SERBIA                           ("Serbia", 688, "RS", "SRB"),
    SEYCHELLES                       ("Seychelles", 690, "SC", "SYC"),
    SIERRA_LEONE                     ("Sierra Leone", 694, "SL", "SLE"),
    SINGAPORE                        ("Singapore", 702, "SG", "SGP"),
    SINT_MAARTEN                     ("Sint Maarten", 534, "SX", "SXM"),
    SLOVAKIA                         ("Slovakia", 703, "SK", "SVK"),
    SLOVENIA                         ("Slovenia", 705, "SI", "SVN"),
    SOLOMON_ISLANDS                  ("Solomon Islands", 90, "SB", "SLB"),
    SOMALIA                          ("Somalia", 706, "SO", "SOM"),
    SOUTH_AFRICA                     ("South Africa", 710, "ZA", "ZAF"),
    SOUTH_SUDAN                      ("South Sudan", 728, "SS", "SSD"),
    SPAIN                            ("Spain", 724, "ES", "ESP"),
    SRI_LANKA                        ("Sri Lanka", 144, "LK", "LKA"),
    SUDAN                            ("Sudan", 729, "SD", "SDN"),
    SURINAME                         ("Suriname", 740, "SR", "SUR"),
    SVALBARD_AND_JAN_MAYEN           ("Svalbard and Jan Mayen", 744, "SJ", "SJM"),
    SWAZILAND                        ("Swaziland", 748, "SZ", "SWZ"),
    SWEDEN                           ("Sweden", 752, "SE", "SWE"),
    SWITZERLAND                      ("Switzerland", 756, "CH", "CHE"),
    SYRIA                            ("Syrian Arab Republic", 760, "SY", "SYR"),
    TAIWAN                           ("Taiwan", 158, "TW", "TWN"),
    TAJIKISTAN                       ("Tajikistan", 762, "TJ", "TJK"),
    TANZANIA                         ("Tanzania, United Republic of", 834, "TZ", "TZA"),
    THAILAND                         ("Thailand", 764, "TH", "THA"),
    TIMOR_LESTE                      ("Timor-Leste", 626, "TL", "TLS"),
    TOGO                             ("Togo", 768, "TG", "TGO"),
    TOKELAU                          ("Tokelau", 772, "TK", "TKL"),
    TONGA                            ("Tonga", 776, "TO", "TON"),
    TRINIDAD_AND_TOBAGO              ("Trinidad and Tobago", 780, "TT", "TTO"),
    TUNISIA                          ("Tunisia", 788, "TN", "TUN"),
    TURKEY                           ("Turkey", 792, "TR", "TUR"),
    TURKMENISTAN                     ("Turkmenistan", 795, "TM", "TKM"),
    TURKS_AND_CAICOS_ISLANDS         ("Turks and Caicos Islands", 796, "TC", "TCA"),
    TUVALU                           ("Tuvalu", 798, "TV", "TUV"),
    UGANDA                           ("Uganda", 800, "UG", "UGA"),
    UKRAINE                          ("Ukraine", 804, "UA", "UKR"),
    UNITED_ARAB_EMIRATES             ("United Arab Emirates", 784, "AE", "ARE"),
    UK                               ("United Kingdom", 826, "GB", "GBR"),
    US_MINOR_OUTLYING_ISLANDS        ("United States Minor Outlying Islands", 581, "UM", "UMI"),
    US                               ("United States of America", 840, "US", "USA"),
    URUGUAY                          ("Uruguay", 858, "UY", "URY"),
    UZBEKISTAN                       ("Uzbekistan", 860, "UZ", "UZB"),
    VANUATU                          ("Vanuatu", 548, "VU", "VUT"),
    VENEZUELA                        ("Venezuela", 862, "VE", "VEN"),
    VIETNAM                          ("Vietnam", 704, "VN", "VNM"),
    BRITISH_VIRGIN_ISLANDS           ("Virgin Islands (British)", 92, "VG", "VGB"),
    US_VIRGIN_ISLANDS                ("Virgin Islands (U.S.)", 850, "VI", "VIR"),
    WALLIS_AND_FUTUNA                ("Wallis and Futuna", 876, "WF", "WLF"),
    WESTERN_SAHARA                   ("Western Sahara", 732, "EH", "ESH"),
    YEMEN                            ("Yemen", 887, "YE", "YEM"),
    ZAMBIA                           ("Zambia", 894, "ZM", "ZMB"),
    ZIMBABWE                         ("Zimbabwe", 716, "ZW", "ZWE"),
    UNKNOWN                          ("Unknown Country", -10, "", "")
    ;

    private String entryName;
    private int numericCode;
    private String alpha2;
    private String alpha3;

    Country(String entryName, int numericCode, String alpha2, String alpha3) {
        this.entryName = entryName;
        this.numericCode = numericCode;
        this.alpha2 = alpha2;
        this.alpha3 = alpha3;
    }

    public String getEntryName() {
        return entryName;
    }

    public int getNumericCode() {
        return numericCode;
    }

    public String getAlpha2() {
        return alpha2;
    }

    public String getAlpha3() {
        return alpha3;
    }

    public static Country getCountryByEntryName(String entryName) {
        for (Country country : values()) {
            if (country.entryName.equals(entryName)) return country;
        }
        throw new IllegalArgumentException("Could not get any country information. entryName = [" + entryName +"]");
    }

    public static Country getCountryByNumericCode(int numericCode) {
        for (Country country : values()) {
            if (country.numericCode == numericCode) return country;
        }
        throw new IllegalArgumentException("Could not get any country information. numericCode = [" + numericCode +"]");
    }

    public static Country getCountryByAlpha2(String alpha2) {
        for (Country country : values()) {
            if (country.alpha2.equals(alpha2)) return country;
        }
        throw new IllegalArgumentException("Could not get any country information. alpha2 = [" + alpha2 +"]");
    }

    public static Country getCountryByAlpha3(String alpha3) {
        for (Country country : values()) {
            if (country.alpha3.equals(alpha3)) return country;
        }
        throw new IllegalArgumentException("Could not get any country information. alpha3 = [" + alpha3 +"]");
    }
}
