package jp.gopay.sdk.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jp.gopay.sdk.converters.BinaryDataConverterFactory;
import jp.gopay.sdk.converters.DomainConverterFactory;
import jp.gopay.sdk.converters.IdempotencyKeyConverterFactory;
import jp.gopay.sdk.converters.VoidConverterFactory;
import jp.gopay.sdk.models.common.Domain;
import jp.gopay.sdk.models.common.auth.AuthStrategy;
import jp.gopay.sdk.models.common.auth.LoginJWTStrategy;
import jp.gopay.sdk.models.request.subscription.RemoveInstallmentsPlan;
import jp.gopay.sdk.models.response.PaymentsPlan;
import jp.gopay.sdk.models.webhook.WebhookEvent;
import jp.gopay.sdk.models.webhook.WebhookEventDeserializer;
import jp.gopay.sdk.settings.AbstractSDKSettings;
import jp.gopay.sdk.types.CardBrand;
import jp.gopay.sdk.types.Country;
import jp.gopay.sdk.types.MetadataMap;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.threeten.bp.Duration;
import org.threeten.bp.ZoneId;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import java.util.Date;

import static jp.gopay.sdk.adapters.JsonAdapters.*;

public class RequestUtils {
    // Utility gson that doesn't ignore null values. Useful on some patch methods that use nulls to unset properties.
    private static Gson gsonForNulls = new GsonBuilder().serializeNulls().create();

    private static Gson gson = new GsonBuilder()
            .enableComplexMapKeySerialization()
            .registerTypeAdapter(Date.class, new JsonDateAdapter())
            .registerTypeAdapter(Domain.class, new JsonDomainAdapter())
            .registerTypeAdapter(Period.class, new JsonPeriodAdapter())
            .registerTypeAdapter(Duration.class, new JsonDurationAdapter())
            .registerTypeAdapter(LocalDate.class, new JsonLocalDateAdapter())
            .registerTypeAdapter(LoginJWTStrategy.class, new JsonJWTDeserializer())
            .registerTypeAdapter(WebhookEvent.class, new WebhookEventDeserializer())
            .registerTypeAdapter(RemoveInstallmentsPlan.class, new JsonRemoveInstallmentsPlanAdapter(gsonForNulls))
            .registerTypeAdapter(ZoneId.class, new JsonZoneIdAdapter())
            .registerTypeAdapter(Country.class, new JsonCountryAdapter())
            .registerTypeAdapter(MetadataMap.class, new JsonMetadataMapAdapter())
            .registerTypeAdapter(CardBrand.class, new JsonCardBrandAdapter())
            .registerTypeAdapter(PaymentsPlan.class, new JsonPaymentsPlanAdapter())
            .create();


    public static Retrofit createClient(AuthStrategy authStrategy, AbstractSDKSettings settings){
        return new Retrofit.Builder()
                .baseUrl(settings.getEndpoint())
                .addConverterFactory(new BinaryDataConverterFactory())
                .addConverterFactory(new VoidConverterFactory())
                .addConverterFactory(new EnumConverter())
                .addConverterFactory(GsonConverterFactory.create(gson))
                .addConverterFactory(new IdempotencyKeyConverterFactory())
                .addConverterFactory(new DomainConverterFactory())
                .client(settings.getClient(authStrategy))
                .build();
    }

    public static Gson getGson() {
        return gson;
    }

}
