package jp.gopay.sdk.utils.builders;

import jp.gopay.sdk.models.response.store.CardConfiguration;
import jp.gopay.sdk.types.CardBrand;

import java.util.List;

public class CardConfigurationBuilder implements Builder<CardConfiguration> {

    private Boolean enabled;
    private Boolean debitEnabled;
    private Boolean prepaidEnabled;
    private List<CardBrand> forbiddenCardBrands;
    private List<String> allowedCountriesByIp;
    private Boolean foreignCardsAllowed;
    private Boolean failOnNewEmail;
    private Boolean allowEmptyCvv;

    public CardConfigurationBuilder withEnabled(Boolean enabled){
        this.enabled = enabled;
        return this;
    }

    public CardConfigurationBuilder withDebitEnabled(Boolean debitEnabled){
        this.debitEnabled = debitEnabled;
        return this;
    }

    public CardConfigurationBuilder withPrepaidEnabled(Boolean prepaidEnabled){
        this.prepaidEnabled = prepaidEnabled;
        return this;
    }

    public CardConfigurationBuilder withForbiddenCardBrands(List<CardBrand> forbiddenCardBrands){
        this.forbiddenCardBrands = forbiddenCardBrands;
        return this;
    }

    public CardConfigurationBuilder withAllowedCountriesByIp(List<String> allowedCountriesByIp){
        this.allowedCountriesByIp = allowedCountriesByIp;
        return this;
    }

    public CardConfigurationBuilder withForeignCardsAllowed(Boolean foreignCardsAllowed){
        this.foreignCardsAllowed = foreignCardsAllowed;
        return this;
    }

    public CardConfigurationBuilder withFailOnNewEmail(Boolean failOnNewEmail){
        this.failOnNewEmail = failOnNewEmail;
        return this;
    }

    public CardConfigurationBuilder withAllowEmptyCvv(Boolean allowEmptyCvv){
        this.allowEmptyCvv = allowEmptyCvv;
        return this;
    }

    @Override
    public CardConfiguration build(){
        return new CardConfiguration(enabled, debitEnabled, prepaidEnabled, forbiddenCardBrands, allowedCountriesByIp, foreignCardsAllowed, failOnNewEmail, allowEmptyCvv);
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public Boolean getDebitEnabled() {
        return debitEnabled;
    }

    public Boolean getPrepaidEnabled() {
        return prepaidEnabled;
    }

    public List<CardBrand> getForbiddenCardBrands() {
        return forbiddenCardBrands;
    }

    public List<String> getAllowedCountriesByIp() {
        return allowedCountriesByIp;
    }

    public Boolean getForeignCardsAllowed() {
        return foreignCardsAllowed;
    }

    public Boolean getFailOnNewEmail() {
        return failOnNewEmail;
    }
}
