/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.Type;

public final class JavaType {
    private static final ImmutableSet<BasicType> PRIMITIVE_TYPES = ImmutableSet.of(Type.BOOLEAN, Type.BYTE, Type.SHORT, Type.CHAR, Type.INT, Type.LONG, new BasicType[]{Type.FLOAT, Type.DOUBLE});
    private static final JavaClass THROWABLE;
    private final String name;
    private final JavaClass javaClass;

    public static JavaType from(@SlashedClassName String className) {
        try {
            JavaClass javaClass = Repository.lookupClass((String)className);
            return JavaType.from(javaClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JavaType from(JavaClass clazz) {
        if (clazz == null) {
            return null;
        }
        return new JavaType(clazz);
    }

    public static JavaType from(Type type) {
        if (type == null || PRIMITIVE_TYPES.contains(type)) {
            return null;
        }
        return new JavaType(type);
    }

    private JavaType(Type type) {
        this.name = type.toString();
        this.javaClass = null;
    }

    private JavaType(JavaClass clazz) {
        this.name = clazz.getClassName();
        this.javaClass = clazz;
    }

    public String toString() {
        return this.name;
    }

    public JavaClass toJavaClass() throws ClassNotFoundException {
        if (this.javaClass != null) {
            return this.javaClass;
        }
        if (this.name.contains("[")) {
            return null;
        }
        return Repository.lookupClass((String)this.name);
    }

    public boolean isThrowable() {
        try {
            JavaClass javaClass = this.toJavaClass();
            if (javaClass == null) {
                return false;
            }
            return javaClass.instanceOf(THROWABLE);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        try {
            THROWABLE = Repository.lookupClass(Throwable.class);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

