/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.guava.stream;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import jp.skypencil.guava.stream.BiMapCollector;
import jp.skypencil.guava.stream.CharacteristicSets;
import jp.skypencil.guava.stream.MultimapCollector;
import jp.skypencil.guava.stream.MultisetCollector;
import jp.skypencil.guava.stream.TableCollector;

public class GuavaCollectors {
    private static final <T> BinaryOperator<T> throwingMerger() {
        return (value, another) -> {
            throw new IllegalStateException(String.format("Duplicated value %s", value));
        };
    }

    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return new Collector<T, ImmutableList.Builder<T>, ImmutableList<T>>(){

            @Override
            public Supplier<ImmutableList.Builder<T>> supplier() {
                return ImmutableList::builder;
            }

            @Override
            public BiConsumer<ImmutableList.Builder<T>, T> accumulator() {
                return (builder, value) -> builder.add(value);
            }

            @Override
            public BinaryOperator<ImmutableList.Builder<T>> combiner() {
                return (builder, another) -> builder.addAll((Iterable)another.build());
            }

            @Override
            public Function<ImmutableList.Builder<T>, ImmutableList<T>> finisher() {
                return ImmutableList.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return new Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>>(){

            @Override
            public Supplier<ImmutableSet.Builder<T>> supplier() {
                return ImmutableSet::builder;
            }

            @Override
            public BiConsumer<ImmutableSet.Builder<T>, T> accumulator() {
                return (builder, value) -> builder.add(value);
            }

            @Override
            public BinaryOperator<ImmutableSet.Builder<T>> combiner() {
                return (builder, another) -> builder.addAll((Iterable)another.build());
            }

            @Override
            public Function<ImmutableSet.Builder<T>, ImmutableSet<T>> finisher() {
                return ImmutableSet.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }

    public static <T, K, U> Collector<T, ?, ImmutableMap<K, U>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return GuavaCollectors.toImmutableMap(keyMapper, valueMapper, GuavaCollectors.throwingMerger());
    }

    public static <T, K, U> Collector<T, ?, ImmutableMap<K, U>> toImmutableMap(final Function<? super T, ? extends K> keyMapper, final Function<? super T, ? extends U> valueMapper, final BinaryOperator<U> mergeFunction) {
        return new Collector<T, Map<K, U>, ImmutableMap<K, U>>(){

            @Override
            public Supplier<Map<K, U>> supplier() {
                return HashMap::new;
            }

            @Override
            public BiConsumer<Map<K, U>, T> accumulator() {
                return (map, entry) -> {
                    Object key = keyMapper.apply(entry);
                    Object value = valueMapper.apply(entry);
                    map.merge(key, value, mergeFunction);
                };
            }

            @Override
            public BinaryOperator<Map<K, U>> combiner() {
                return (map, another) -> {
                    another.forEach((key, value) -> map.merge(key, value, mergeFunction));
                    return map;
                };
            }

            @Override
            public Function<Map<K, U>, ImmutableMap<K, U>> finisher() {
                return map -> {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    return builder.putAll(map).build();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }

    public static <T, R, C, V> Collector<T, ?, Table<R, C, V>> toTable(Function<? super T, ? extends R> rowMapper, Function<? super T, ? extends C> columnMapper, Function<? super T, ? extends V> valueMapper) {
        return GuavaCollectors.toTable(rowMapper, columnMapper, valueMapper, GuavaCollectors.throwingMerger());
    }

    public static <T, R, C, V> Collector<T, ?, Table<R, C, V>> toTable(Function<? super T, ? extends R> rowMapper, Function<? super T, ? extends C> columnMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return new TableCollector<T, R, C, V, Table<R, C, V>>((Function)rowMapper, (Function)columnMapper, (Function)valueMapper, (BinaryOperator)mergeFunction){

            @Override
            public Function<Table<R, C, V>, Table<R, C, V>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.IDENTITY;
            }
        };
    }

    public static <T, R, C, V> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowMapper, Function<? super T, ? extends C> columnMapper, Function<? super T, ? extends V> valueMapper) {
        return GuavaCollectors.toImmutableTable(rowMapper, columnMapper, valueMapper, GuavaCollectors.throwingMerger());
    }

    public static <T, R, C, V> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowMapper, Function<? super T, ? extends C> columnMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return new TableCollector<T, R, C, V, ImmutableTable<R, C, V>>((Function)rowMapper, (Function)columnMapper, (Function)valueMapper, (BinaryOperator)mergeFunction){

            @Override
            public Function<Table<R, C, V>, ImmutableTable<R, C, V>> finisher() {
                return table -> {
                    ImmutableTable.Builder builder = ImmutableTable.builder();
                    return builder.putAll(table).build();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }

    public static <T, K, U> Collector<T, ?, BiMap<K, U>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return GuavaCollectors.toBiMap(keyMapper, valueMapper, GuavaCollectors.throwingMerger());
    }

    public static <T, K, U> Collector<T, ?, BiMap<K, U>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return new BiMapCollector<T, K, U, BiMap<K, U>>((Function)keyMapper, (Function)valueMapper, (BinaryOperator)mergeFunction){

            @Override
            public Function<BiMap<K, U>, BiMap<K, U>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.IDENTITY;
            }
        };
    }

    public static <T, K, U> Collector<T, ?, ImmutableBiMap<K, U>> toImmutableBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return GuavaCollectors.toImmutableBiMap(keyMapper, valueMapper, GuavaCollectors.throwingMerger());
    }

    public static <T, K, U> Collector<T, ?, ImmutableBiMap<K, U>> toImmutableBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return new BiMapCollector<T, K, U, ImmutableBiMap<K, U>>((Function)keyMapper, (Function)valueMapper, (BinaryOperator)mergeFunction){

            @Override
            public Function<BiMap<K, U>, ImmutableBiMap<K, U>> finisher() {
                return map -> {
                    ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                    return builder.putAll((Map)map).build();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }

    public static <T, K, U> Collector<T, ?, Multimap<K, U>> toMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return new MultimapCollector<T, K, U, Multimap<K, U>>((Function)keyMapper, (Function)valueMapper){

            @Override
            public Function<Multimap<K, U>, Multimap<K, U>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.IDENTITY;
            }
        };
    }

    public static <T, K, U> Collector<T, ?, ImmutableMultimap<K, U>> toImmutableMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return new MultimapCollector<T, K, U, ImmutableMultimap<K, U>>((Function)keyMapper, (Function)valueMapper){

            @Override
            public Function<Multimap<K, U>, ImmutableMultimap<K, U>> finisher() {
                return map -> {
                    ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                    return builder.putAll(map).build();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }

    public static <T> Collector<T, ?, Multiset<T>> toMultiset() {
        return new MultisetCollector<T, Multiset<T>>(){

            @Override
            public Function<Multiset<T>, Multiset<T>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.IDENTITY;
            }
        };
    }

    public static <T> Collector<T, ?, ImmutableMultiset<T>> toImmutableMultiset() {
        return new MultisetCollector<T, ImmutableMultiset<T>>(){

            @Override
            public Function<Multiset<T>, ImmutableMultiset<T>> finisher() {
                return set -> {
                    ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                    return builder.addAll((Iterable)set).build();
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CharacteristicSets.EMPTY;
            }
        };
    }
}

