/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.commands.AlertOverride;
import java.util.Map;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class DialogOverride
extends AlertOverride {
    private static final String replaceAlertMethod;
    private static final String answerOnNextPrompt;
    private static final String getNextPrompt;
    private static final String isPromptPresent;

    public DialogOverride() {
        super(true);
    }

    public void replaceAlertMethod(WebDriver driver) {
        super.replaceAlertMethod(driver);
        ((JavascriptExecutor)driver).executeScript(replaceAlertMethod, new Object[0]);
    }

    public void answerOnNextPrompt(WebDriver driver, String msg) {
        ((JavascriptExecutor)driver).executeScript(answerOnNextPrompt, new Object[]{msg});
    }

    public String getNextPrompt(WebDriver driver) {
        String result = (String)((JavascriptExecutor)driver).executeScript(getNextPrompt, new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no prompts");
        }
        return result;
    }

    public boolean isPromptPresent(WebDriver driver) {
        return Boolean.TRUE.equals(((JavascriptExecutor)driver).executeScript(isPromptPresent, new Object[0]));
    }

    static {
        Map<String, String> jsMap = SeleniumUtils.loadJS(DialogOverride.class.getResourceAsStream("DialogOverride.js"));
        replaceAlertMethod = jsMap.get("replaceAlertMethod");
        answerOnNextPrompt = jsMap.get("answerOnNextPrompt");
        getNextPrompt = jsMap.get("getNextPrompt");
        isPromptPresent = jsMap.get("isPromptPresent");
    }
}

