/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class PathUtils {
    private static final Pattern SEP_REGEX = Pattern.compile("[/\\\\]");
    private static final String SEP_REPL = Matcher.quoteReplacement(File.separator);
    private static final String PARENT_DIR = ".." + File.separator;

    private PathUtils() {
    }

    private static String normalizeInternal(String filename) {
        String nfn;
        if (filename.startsWith(PARENT_DIR)) {
            filename = new File(filename).getAbsolutePath();
        }
        if ((nfn = FilenameUtils.normalize((String)filename)) == null) {
            try {
                nfn = new File(filename).getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Filename normalization failed: " + filename, e);
            }
        }
        return nfn;
    }

    public static String normalizeSeparator(String filename) {
        if (filename == null) {
            return null;
        }
        return SEP_REGEX.matcher(filename).replaceAll(SEP_REPL);
    }

    public static String normalize(String filename) {
        if (filename == null) {
            return null;
        }
        return PathUtils.normalizeInternal(PathUtils.normalizeSeparator(filename));
    }

    public static String concat(String parent, String child) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            return PathUtils.normalize(child);
        }
        StringBuilder s = new StringBuilder(PathUtils.normalizeSeparator(parent));
        if (!parent.endsWith(File.separator)) {
            s.append(File.separatorChar);
        }
        s.append(PathUtils.normalizeSeparator(child));
        return PathUtils.normalizeInternal(s.toString());
    }

    public static String relativize(String from, String to) {
        from = new File(PathUtils.normalize(from)).toURI().toASCIIString();
        to = new File(PathUtils.normalize(to)).toURI().toASCIIString();
        int prefixLen = StringUtils.getCommonPrefix((String[])new String[]{from, to}).length();
        int level = StringUtils.countMatches((CharSequence)from.substring(prefixLen), (CharSequence)"/");
        return StringUtils.repeat((String)"../", (int)level) + to.substring(prefixLen);
    }
}

