/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.blurry;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.view.View;
import jp.wasabeef.blurry.BlurFactor;
import jp.wasabeef.blurry.Helper;

class Blur {
    Blur() {
    }

    public static Bitmap of(View view, BlurFactor factor) {
        view.setDrawingCacheEnabled(true);
        view.destroyDrawingCache();
        view.setDrawingCacheQuality(524288);
        Bitmap cache = view.getDrawingCache();
        Bitmap bitmap = Blur.of(view.getContext(), cache, factor);
        cache.recycle();
        return bitmap;
    }

    public static Bitmap of(Context context, Bitmap source, BlurFactor factor) {
        int width = factor.width / factor.sampling;
        int height = factor.height / factor.sampling;
        if (Helper.hasZero(width, height)) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)factor.sampling, 1.0f / (float)factor.sampling);
        Paint paint = new Paint();
        paint.setFlags(3);
        PorterDuffColorFilter filter = new PorterDuffColorFilter(factor.color, PorterDuff.Mode.SRC_ATOP);
        paint.setColorFilter((ColorFilter)filter);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        try {
            bitmap = Blur.rs(context, bitmap, factor.radius);
        }
        catch (RSRuntimeException e) {
            bitmap = Blur.stack(bitmap, factor.radius, true);
        }
        if (factor.sampling == 1) {
            return bitmap;
        }
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)factor.width, (int)factor.height, (boolean)true);
        bitmap.recycle();
        return scaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap rs(Context context, Bitmap bitmap, int radius) throws RSRuntimeException {
        RenderScript rs = null;
        Allocation input = null;
        Allocation output = null;
        ScriptIntrinsicBlur blur = null;
        try {
            rs = RenderScript.create((Context)context);
            rs.setMessageHandler(new RenderScript.RSMessageHandler());
            input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            blur.setInput(input);
            blur.setRadius((float)radius);
            blur.forEach(output);
            output.copyTo(bitmap);
        }
        finally {
            if (rs != null) {
                if (Build.VERSION.SDK_INT >= 23) {
                    RenderScript.releaseAllContexts();
                } else {
                    rs.destroy();
                }
            }
            if (input != null) {
                input.destroy();
            }
            if (output != null) {
                output.destroy();
            }
            if (blur != null) {
                blur.destroy();
            }
        }
        return bitmap;
    }

    private static Bitmap stack(Bitmap sentBitmap, int radius, boolean canReuseInBitmap) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        Bitmap bitmap = canReuseInBitmap ? sentBitmap : sentBitmap.copy(sentBitmap.getConfig(), true);
        if (radius < 1) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pix = new int[w * h];
        bitmap.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        bitmap.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap;
    }
}

