/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.blurry;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.wasabeef.blurry.Blur;
import jp.wasabeef.blurry.BlurFactor;

class BlurTask {
    private final WeakReference<Context> contextWeakRef;
    private final BlurFactor factor;
    private final Bitmap bitmap;
    private final Callback callback;
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    public BlurTask(View target, BlurFactor factor, Callback callback) {
        this.factor = factor;
        this.callback = callback;
        this.contextWeakRef = new WeakReference<Context>(target.getContext());
        target.setDrawingCacheEnabled(true);
        target.destroyDrawingCache();
        target.setDrawingCacheQuality(524288);
        this.bitmap = target.getDrawingCache();
    }

    public BlurTask(Context context, Bitmap bitmap, BlurFactor factor, Callback callback) {
        this.factor = factor;
        this.callback = callback;
        this.contextWeakRef = new WeakReference<Context>(context);
        this.bitmap = bitmap;
    }

    public void execute() {
        THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                final Context context = (Context)BlurTask.this.contextWeakRef.get();
                if (BlurTask.this.callback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            BlurTask.this.callback.done(Blur.of(context, BlurTask.this.bitmap, BlurTask.this.factor));
                        }
                    });
                }
            }
        });
    }

    public static interface Callback {
        public void done(Bitmap var1);
    }
}

