/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.blurry;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import jp.wasabeef.blurry.Blur;
import jp.wasabeef.blurry.BlurFactor;
import jp.wasabeef.blurry.BlurTask;
import jp.wasabeef.blurry.Helper;

public class Blurry {
    private static final String TAG = Blurry.class.getSimpleName();

    public static Composer with(Context context) {
        return new Composer(context);
    }

    public static void delete(ViewGroup target) {
        View view = target.findViewWithTag((Object)TAG);
        if (view != null) {
            target.removeView(view);
        }
    }

    public static class ImageComposer {
        private final Context context;
        private final View capture;
        private final BlurFactor factor;
        private final boolean async;

        public ImageComposer(Context context, View capture, BlurFactor factor, boolean async) {
            this.context = context;
            this.capture = capture;
            this.factor = factor;
            this.async = async;
        }

        public void into(final ImageView target) {
            this.factor.width = this.capture.getMeasuredWidth();
            this.factor.height = this.capture.getMeasuredHeight();
            if (this.async) {
                BlurTask task = new BlurTask(this.capture, this.factor, new BlurTask.Callback(){

                    @Override
                    public void done(Bitmap bitmap) {
                        BitmapDrawable drawable = new BitmapDrawable(context.getResources(), bitmap);
                        target.setImageDrawable((Drawable)drawable);
                    }
                });
                task.execute();
            } else {
                BitmapDrawable drawable = new BitmapDrawable(this.context.getResources(), Blur.of(this.capture, this.factor));
                target.setImageDrawable((Drawable)drawable);
            }
        }

        public Bitmap get() {
            if (this.async) {
                throw new IllegalArgumentException("Use getAsync() instead of async().");
            }
            this.factor.width = this.capture.getMeasuredWidth();
            this.factor.height = this.capture.getMeasuredHeight();
            return Blur.of(this.capture, this.factor);
        }

        public void getAsync(BlurTask.Callback callback) {
            this.factor.width = this.capture.getMeasuredWidth();
            this.factor.height = this.capture.getMeasuredHeight();
            new BlurTask(this.capture, this.factor, callback).execute();
        }
    }

    public static class BitmapComposer {
        private final Context context;
        private final Bitmap bitmap;
        private final BlurFactor factor;
        private final boolean async;

        public BitmapComposer(Context context, Bitmap bitmap, BlurFactor factor, boolean async) {
            this.context = context;
            this.bitmap = bitmap;
            this.factor = factor;
            this.async = async;
        }

        public void into(final ImageView target) {
            this.factor.width = this.bitmap.getWidth();
            this.factor.height = this.bitmap.getHeight();
            if (this.async) {
                BlurTask task = new BlurTask(target.getContext(), this.bitmap, this.factor, new BlurTask.Callback(){

                    @Override
                    public void done(Bitmap bitmap) {
                        BitmapDrawable drawable = new BitmapDrawable(context.getResources(), bitmap);
                        target.setImageDrawable((Drawable)drawable);
                    }
                });
                task.execute();
            } else {
                BitmapDrawable drawable = new BitmapDrawable(this.context.getResources(), Blur.of(target.getContext(), this.bitmap, this.factor));
                target.setImageDrawable((Drawable)drawable);
            }
        }
    }

    public static class Composer {
        private final View blurredView;
        private final Context context;
        private final BlurFactor factor;
        private boolean async;
        private boolean animate;
        private int duration = 300;

        public Composer(Context context) {
            this.context = context;
            this.blurredView = new View(context);
            this.blurredView.setTag((Object)TAG);
            this.factor = new BlurFactor();
        }

        public Composer radius(int radius) {
            this.factor.radius = radius;
            return this;
        }

        public Composer sampling(int sampling) {
            this.factor.sampling = sampling;
            return this;
        }

        public Composer color(int color) {
            this.factor.color = color;
            return this;
        }

        public Composer async() {
            this.async = true;
            return this;
        }

        public Composer animate() {
            this.animate = true;
            return this;
        }

        public Composer animate(int duration) {
            this.animate = true;
            this.duration = duration;
            return this;
        }

        public ImageComposer capture(View capture) {
            return new ImageComposer(this.context, capture, this.factor, this.async);
        }

        public BitmapComposer from(Bitmap bitmap) {
            return new BitmapComposer(this.context, bitmap, this.factor, this.async);
        }

        public void onto(final ViewGroup target) {
            this.factor.width = target.getMeasuredWidth();
            this.factor.height = target.getMeasuredHeight();
            if (this.async) {
                BlurTask task = new BlurTask((View)target, this.factor, new BlurTask.Callback(){

                    @Override
                    public void done(Bitmap bitmap) {
                        BitmapDrawable drawable = new BitmapDrawable(target.getResources(), Blur.of(context, bitmap, factor));
                        this.addView(target, (Drawable)drawable);
                    }
                });
                task.execute();
            } else {
                BitmapDrawable drawable = new BitmapDrawable(this.context.getResources(), Blur.of((View)target, this.factor));
                this.addView(target, (Drawable)drawable);
            }
        }

        private void addView(ViewGroup target, Drawable drawable) {
            this.blurredView.setBackground(drawable);
            target.addView(this.blurredView);
            if (this.animate) {
                Helper.animate(this.blurredView, this.duration);
            }
        }
    }
}

