/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.fresco.processors;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.renderscript.RSRuntimeException;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.imagepipeline.request.BasePostprocessor;
import jp.wasabeef.fresco.processors.internal.FastBlur;
import jp.wasabeef.fresco.processors.internal.RSBlur;

public class BlurPostprocessor
extends BasePostprocessor {
    private static final int MAX_RADIUS = 25;
    private static final int DEFAULT_DOWN_SAMPLING = 1;
    private final Context context;
    private final int radius;
    private final int sampling;

    public BlurPostprocessor(Context context) {
        this(context, 25, 1);
    }

    public BlurPostprocessor(Context context, int radius) {
        this(context, radius, 1);
    }

    public BlurPostprocessor(Context context, int radius, int sampling) {
        this.context = context.getApplicationContext();
        this.radius = radius;
        this.sampling = sampling;
    }

    public void process(Bitmap dest, Bitmap source) {
        int width = source.getWidth();
        int height = source.getHeight();
        int scaledWidth = width / this.sampling;
        int scaledHeight = height / this.sampling;
        Bitmap blurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(blurredBitmap);
        canvas.scale(1.0f / (float)this.sampling, 1.0f / (float)this.sampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        try {
            blurredBitmap = RSBlur.blur(this.context, blurredBitmap, this.radius);
        }
        catch (RSRuntimeException e) {
            blurredBitmap = FastBlur.blur(blurredBitmap, this.radius, true);
        }
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)blurredBitmap, (int)dest.getWidth(), (int)dest.getHeight(), (boolean)true);
        blurredBitmap.recycle();
        super.process(dest, scaledBitmap);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public CacheKey getPostprocessorCacheKey() {
        return new SimpleCacheKey("radius=" + this.radius + ",sampling=" + this.sampling);
    }
}

