/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.fresco.processors;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.imagepipeline.request.BasePostprocessor;

public class ColorFilterPostprocessor
extends BasePostprocessor {
    private final int color;

    public ColorFilterPostprocessor(int color) {
        this.color = color;
    }

    public void process(Bitmap dest, Bitmap source) {
        super.process(dest, source);
        Canvas canvas = new Canvas(dest);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.color, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public CacheKey getPostprocessorCacheKey() {
        return new SimpleCacheKey("color=" + this.color);
    }
}

