/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.fresco.processors;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.imagepipeline.request.BasePostprocessor;

public class MaskPostprocessor
extends BasePostprocessor {
    private static final Paint paint = new Paint();
    private final Context context;
    private final int maskId;

    public MaskPostprocessor(Context context, int maskId) {
        this.context = context.getApplicationContext();
        this.maskId = maskId;
    }

    public void process(Bitmap dest, Bitmap source) {
        Bitmap result = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Drawable mask = this.context.getDrawable(this.maskId);
        Canvas canvas = new Canvas(result);
        mask.setBounds(0, 0, source.getWidth(), source.getHeight());
        mask.draw(canvas);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        super.process(dest, result);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public CacheKey getPostprocessorCacheKey() {
        return new SimpleCacheKey("mask=" + this.context.getResources().getResourceEntryName(this.maskId));
    }

    static {
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }
}

