/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.fresco.processors.gpu;

import android.content.Context;
import android.graphics.PointF;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import java.util.Arrays;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageVignetteFilter;
import jp.wasabeef.fresco.processors.gpu.GPUFilterPostprocessor;

public class VignetteFilterPostprocessor
extends GPUFilterPostprocessor {
    private final PointF center;
    private final float[] vignetteColor;
    private final float vignetteStart;
    private final float vignetteEnd;

    public VignetteFilterPostprocessor(Context context) {
        this(context, new PointF(0.5f, 0.5f), new float[]{0.0f, 0.0f, 0.0f}, 0.0f, 0.75f);
    }

    public VignetteFilterPostprocessor(Context context, PointF center, float[] color, float start, float end) {
        super(context, (GPUImageFilter)new GPUImageVignetteFilter());
        this.center = center;
        this.vignetteColor = color;
        this.vignetteStart = start;
        this.vignetteEnd = end;
        GPUImageVignetteFilter filter = (GPUImageVignetteFilter)this.getFilter();
        filter.setVignetteCenter(this.center);
        filter.setVignetteColor(this.vignetteColor);
        filter.setVignetteStart(this.vignetteStart);
        filter.setVignetteEnd(this.vignetteEnd);
    }

    public CacheKey getPostprocessorCacheKey() {
        return new SimpleCacheKey("center=" + this.center.toString() + ",color=" + Arrays.toString(this.vignetteColor) + ",start=" + this.vignetteStart + ",end=" + this.vignetteEnd);
    }
}

