/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageContrastFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class ContrastFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.ContrastFilterTransformation.1";
    private final float contrast;

    public ContrastFilterTransformation() {
        this(1.0f);
    }

    public ContrastFilterTransformation(float contrast) {
        super((GPUImageFilter)new GPUImageContrastFilter());
        this.contrast = contrast;
        GPUImageContrastFilter filter = (GPUImageContrastFilter)this.getFilter();
        filter.setContrast(this.contrast);
    }

    @Override
    public String toString() {
        return "ContrastFilterTransformation(contrast=" + this.contrast + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ContrastFilterTransformation;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + (int)(this.contrast * 10.0f);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.contrast).getBytes(CHARSET));
    }
}

