/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.renderscript.RSRuntimeException;
import com.squareup.picasso.Transformation;
import jp.wasabeef.picasso.transformations.internal.FastBlur;
import jp.wasabeef.picasso.transformations.internal.RSBlur;

public class BlurTransformation
implements Transformation {
    private static final int MAX_RADIUS = 25;
    private static final int DEFAULT_DOWN_SAMPLING = 1;
    private final Context mContext;
    private final int mRadius;
    private final int mSampling;

    public BlurTransformation(Context context) {
        this(context, 25, 1);
    }

    public BlurTransformation(Context context, int radius) {
        this(context, radius, 1);
    }

    public BlurTransformation(Context context, int radius, int sampling) {
        this.mContext = context.getApplicationContext();
        this.mRadius = radius;
        this.mSampling = sampling;
    }

    public Bitmap transform(Bitmap source) {
        int scaledWidth = source.getWidth() / this.mSampling;
        int scaledHeight = source.getHeight() / this.mSampling;
        Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mSampling, 1.0f / (float)this.mSampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        try {
            bitmap = RSBlur.blur(this.mContext, bitmap, this.mRadius);
        }
        catch (RSRuntimeException e) {
            bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        }
        source.recycle();
        return bitmap;
    }

    public String key() {
        return "BlurTransformation(radius=" + this.mRadius + ", sampling=" + this.mSampling + ")";
    }
}

