/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import com.squareup.picasso.Transformation;

public class MaskTransformation
implements Transformation {
    private static final Paint mMaskingPaint = new Paint();
    private final Context mContext;
    private final int mMaskId;

    public MaskTransformation(Context context, int maskId) {
        this.mContext = context.getApplicationContext();
        this.mMaskId = maskId;
    }

    public Bitmap transform(Bitmap source) {
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Drawable mask = this.mContext.getDrawable(this.mMaskId);
        Canvas canvas = new Canvas(result);
        mask.setBounds(0, 0, width, height);
        mask.draw(canvas);
        canvas.drawBitmap(source, 0.0f, 0.0f, mMaskingPaint);
        source.recycle();
        return result;
    }

    public String key() {
        return "MaskTransformation(maskId=" + this.mContext.getResources().getResourceEntryName(this.mMaskId) + ")";
    }

    static {
        mMaskingPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }
}

