/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.PointF;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageSwirlFilter;
import jp.wasabeef.picasso.transformations.gpu.GPUFilterTransformation;

public class SwirlFilterTransformation
extends GPUFilterTransformation {
    private final float mRadius;
    private final float mAngle;
    private final PointF mCenter;

    public SwirlFilterTransformation(Context context) {
        this(context, 0.5f, 1.0f, new PointF(0.5f, 0.5f));
    }

    public SwirlFilterTransformation(Context context, float radius, float angle, PointF center) {
        super(context, (GPUImageFilter)new GPUImageSwirlFilter());
        this.mRadius = radius;
        this.mAngle = angle;
        this.mCenter = center;
        GPUImageSwirlFilter filter = (GPUImageSwirlFilter)this.getFilter();
        filter.setRadius(this.mRadius);
        filter.setAngle(this.mAngle);
        filter.setCenter(this.mCenter);
    }

    @Override
    public String key() {
        return "SwirlFilterTransformation(radius=" + this.mRadius + ",angle=" + this.mAngle + ",center=" + this.mCenter.toString() + ")";
    }
}

