/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.picasso.transformations.gpu;

import android.content.Context;
import android.graphics.PointF;
import java.util.Arrays;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageVignetteFilter;
import jp.wasabeef.picasso.transformations.gpu.GPUFilterTransformation;

public class VignetteFilterTransformation
extends GPUFilterTransformation {
    private final PointF mCenter;
    private final float[] mVignetteColor;
    private final float mVignetteStart;
    private final float mVignetteEnd;

    public VignetteFilterTransformation(Context context) {
        this(context, new PointF(0.5f, 0.5f), new float[]{0.0f, 0.0f, 0.0f}, 0.0f, 0.75f);
    }

    public VignetteFilterTransformation(Context context, PointF center, float[] color, float start, float end) {
        super(context, (GPUImageFilter)new GPUImageVignetteFilter());
        this.mCenter = center;
        this.mVignetteColor = color;
        this.mVignetteStart = start;
        this.mVignetteEnd = end;
        GPUImageVignetteFilter filter = (GPUImageVignetteFilter)this.getFilter();
        filter.setVignetteCenter(this.mCenter);
        filter.setVignetteColor(this.mVignetteColor);
        filter.setVignetteStart(this.mVignetteStart);
        filter.setVignetteEnd(this.mVignetteEnd);
    }

    @Override
    public String key() {
        return "VignetteFilterTransformation(center=" + this.mCenter.toString() + ",color=" + Arrays.toString(this.mVignetteColor) + ",start=" + this.mVignetteStart + ",end=" + this.mVignetteEnd + ")";
    }
}

