/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.recyclerview.adapters;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.recyclerview.widget.RecyclerView;
import jp.wasabeef.recyclerview.internal.ViewHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H$\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u000eJ\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u000eH\u0016J\u000e\u00103\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\nJ\u0010\u00106\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u00067"}, d2={"Ljp/wasabeef/recyclerview/adapters/AnimationAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "wrapped", "(Landroidx/recyclerview/widget/RecyclerView$Adapter;)V", "adapter", "getAdapter", "()Landroidx/recyclerview/widget/RecyclerView$Adapter;", "setAdapter", "duration", "", "interpolator", "Landroid/view/animation/Interpolator;", "isFirstOnly", "", "lastPosition", "wrappedAdapter", "getWrappedAdapter", "getAnimators", "", "Landroid/animation/Animator;", "view", "Landroid/view/View;", "(Landroid/view/View;)[Landroid/animation/Animator;", "getItemCount", "getItemId", "", "position", "getItemViewType", "onAttachedToRecyclerView", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "onViewAttachedToWindow", "onViewDetachedFromWindow", "onViewRecycled", "registerAdapterDataObserver", "observer", "Landroidx/recyclerview/widget/RecyclerView$AdapterDataObserver;", "setDuration", "setFirstOnly", "firstOnly", "setHasStableIds", "hasStableIds", "setInterpolator", "setStartPosition", "start", "unregisterAdapterDataObserver", "animators_release"})
public abstract class AnimationAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private int duration;
    private Interpolator interpolator;
    private int lastPosition;
    private boolean isFirstOnly;
    @NotNull
    private RecyclerView.Adapter<RecyclerView.ViewHolder> adapter;

    @NotNull
    protected final RecyclerView.Adapter<RecyclerView.ViewHolder> getAdapter() {
        return this.adapter;
    }

    protected final void setAdapter(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        Intrinsics.checkParameterIsNotNull(adapter, (String)"<set-?>");
        this.adapter = adapter;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        RecyclerView.ViewHolder viewHolder = this.adapter.onCreateViewHolder(parent, viewType);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewHolder, (String)"adapter.onCreateViewHolder(parent, viewType)");
        return viewHolder;
    }

    public void registerAdapterDataObserver(@NotNull RecyclerView.AdapterDataObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        super.registerAdapterDataObserver(observer);
        this.adapter.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(@NotNull RecyclerView.AdapterDataObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        super.unregisterAdapterDataObserver(observer);
        this.adapter.unregisterAdapterDataObserver(observer);
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onAttachedToRecyclerView(recyclerView);
        this.adapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onDetachedFromRecyclerView(recyclerView);
        this.adapter.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        super.onViewAttachedToWindow(holder);
        this.adapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        super.onViewDetachedFromWindow(holder);
        this.adapter.onViewDetachedFromWindow(holder);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.adapter.onBindViewHolder(holder, position);
        int adapterPosition = holder.getAdapterPosition();
        if (!this.isFirstOnly || adapterPosition > this.lastPosition) {
            View view = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
            for (Animator anim : this.getAnimators(view)) {
                anim.setDuration((long)this.duration).start();
                anim.setInterpolator((TimeInterpolator)this.interpolator);
            }
            this.lastPosition = adapterPosition;
        } else {
            View view = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
            ViewHelper.clear(view);
        }
    }

    public void onViewRecycled(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.adapter.onViewRecycled(holder);
        super.onViewRecycled(holder);
    }

    public int getItemCount() {
        return this.adapter.getItemCount();
    }

    public final void setDuration(int duration) {
        this.duration = duration;
    }

    public final void setInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        this.interpolator = interpolator;
    }

    public final void setStartPosition(int start) {
        this.lastPosition = start;
    }

    @NotNull
    protected abstract Animator[] getAnimators(@NotNull View var1);

    public final void setFirstOnly(boolean firstOnly) {
        this.isFirstOnly = firstOnly;
    }

    public int getItemViewType(int position) {
        return this.adapter.getItemViewType(position);
    }

    @NotNull
    public final RecyclerView.Adapter<RecyclerView.ViewHolder> getWrappedAdapter() {
        return this.adapter;
    }

    public void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
        this.adapter.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        return this.adapter.getItemId(position);
    }

    public AnimationAdapter(@NotNull RecyclerView.Adapter<? extends RecyclerView.ViewHolder> wrapped) {
        Intrinsics.checkParameterIsNotNull(wrapped, (String)"wrapped");
        this.duration = 300;
        this.interpolator = (Interpolator)new LinearInterpolator();
        this.lastPosition = -1;
        this.isFirstOnly = true;
        this.adapter = wrapped;
        super.setHasStableIds(this.adapter.hasStableIds());
    }
}

