/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.Map;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.Term;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.term_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom
extends Term {
    protected final String name;
    protected final String type;

    public Atom(String name) {
        if (name == null) {
            throw new JPLException("cannot construct with null name");
        }
        this.name = name;
        this.type = "text";
    }

    public Atom(String name, String type) {
        if (name == null) {
            throw new JPLException("cannot construct with null name");
        }
        if (type == null) {
            throw new JPLException("cannot construct with null type");
        }
        if (type.equals("jref")) {
            throw new JPLException("cannot construct a <jref>() atom (use JPL.newJRef)");
        }
        this.name = name;
        this.type = type;
    }

    @Override
    public Term[] args() {
        return new Term[0];
    }

    @Override
    public final String atomType() {
        return this.type;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Atom && this.name.equals(((Atom)obj).name) && this.type.equals(((Atom)obj).type);
    }

    @Override
    public final boolean hasFunctor(String name, int arity) {
        return name.equals(this.name) && arity == 0;
    }

    @Override
    protected final boolean isAtomOfNameType(String name, String type) {
        return name != null && type != null && name.equals(this.name) && type.equals(this.type);
    }

    @Override
    public final boolean isListNil() {
        return this.equals(JPL.LIST_NIL);
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    protected void put(Map<String, term_t> varnames_to_vars, term_t term) {
        if (this.equals(JPL.LIST_NIL)) {
            Prolog.put_nil(term);
        } else {
            Term[] args = new Term[]{};
            Prolog.cons_functor_v(term, Prolog.new_functor(Prolog.new_atom(this.name), args.length), Term.putTerms(varnames_to_vars, args));
        }
    }

    public String toString() {
        return JPL.isSimpleName(this.name) ? this.name : "'" + this.name + "'";
    }

    @Override
    public final int type() {
        return 2;
    }

    @Override
    public String typeName() {
        return "Atom";
    }
}

