/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.Map;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.Term;
import org.jpl7.Variable;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.term_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compound
extends Term {
    protected final Term[] args;
    protected final String name;

    public Compound(String name) {
        if (name == null) {
            throw new JPLException("cannot construct with null name");
        }
        this.name = name;
        this.args = new Term[0];
    }

    protected Compound(String name, int arity) {
        if (name == null) {
            throw new JPLException("cannot construct with null name");
        }
        if (arity < 0) {
            throw new JPLException("cannot construct with negative arity");
        }
        this.name = name;
        this.args = new Term[arity];
    }

    public Compound(String name, Term[] args) {
        if (name == null) {
            throw new JPLException("cannot construct with null name");
        }
        if (args == null) {
            throw new JPLException("cannot construct with null args");
        }
        this.name = name;
        this.args = args;
    }

    @Override
    public final Term arg(int i) {
        return this.args[i - 1];
    }

    @Override
    public final Term[] args() {
        return this.args;
    }

    @Override
    public final int arity() {
        return this.args.length;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Compound && this.name.equals(((Compound)obj).name) && Term.terms_equals(this.args, ((Compound)obj).args);
    }

    @Override
    protected final void getSubst(Map<String, Term> varnames_to_Terms, Map<term_t, Variable> vars_to_Vars) {
        Term.getSubsts(varnames_to_Terms, vars_to_Vars, this.args);
    }

    @Override
    public final boolean hasFunctor(String name, int arity) {
        return name.equals(this.name) && arity == this.args.length;
    }

    @Override
    public boolean isJFalse() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("false", "text");
    }

    @Override
    public boolean isJNull() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("null", "text");
    }

    @Override
    public boolean isJTrue() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("true", "text");
    }

    @Override
    public boolean isJVoid() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("void", "text");
    }

    @Override
    public final boolean isListPair() {
        return this.hasFunctor(JPL.LIST_PAIR, 2);
    }

    @Override
    public Object jrefToObject() {
        if (this.isJNull()) {
            return null;
        }
        throw new JPLException("term is not a JRef");
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    protected void put(Map<String, term_t> varnames_to_vars, term_t term) {
        Prolog.cons_functor_v(term, Prolog.new_functor(Prolog.new_atom(this.name), this.args.length), Term.putTerms(varnames_to_vars, this.args));
    }

    public void setArg(int i, Term arg) {
        if (i <= 0) {
            throw new JPLException("bad (non-positive) argument index");
        }
        if (i > this.args.length) {
            throw new JPLException("bad (out-of-range) argument index");
        }
        if (arg == null) {
            throw new JPLException("bad (null) argument");
        }
        this.args[i - 1] = arg;
    }

    public String toString() {
        return JPL.quotedName(this.name) + (this.args.length > 0 ? "(" + Term.toString(this.args) + ")" : "");
    }

    @Override
    public int type() {
        return 6;
    }

    @Override
    public String typeName() {
        return "Compound";
    }
}

