/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.math.BigInteger;
import java.util.Map;
import org.jpl7.JPLException;
import org.jpl7.Term;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.term_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Integer
extends Term {
    private static BigInteger BIG_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigInteger BIG_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected final long value;
    protected final BigInteger bigValue;

    public Integer(long value) {
        this.bigValue = null;
        this.value = value;
    }

    public Integer(BigInteger value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.compareTo(BIG_MIN_LONG) >= 0 && value.compareTo(BIG_MAX_LONG) <= 0) {
            this.bigValue = null;
            this.value = value.longValue();
        } else {
            this.bigValue = value;
            this.value = 0L;
        }
    }

    @Override
    public Term[] args() {
        return new Term[0];
    }

    @Override
    public final BigInteger bigValue() {
        if (this.bigValue == null) {
            return new BigInteger(Long.toString(this.value));
        }
        return this.bigValue;
    }

    @Override
    public final double doubleValue() {
        if (this.bigValue == null) {
            return this.value;
        }
        return this.bigValue.doubleValue();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Integer) {
            Integer that = (Integer)obj;
            if (this.bigValue == null && that.bigValue == null) {
                return this.value == that.value;
            }
            if (this.bigValue != null && that.bigValue != null) {
                return this.bigValue.equals(that.bigValue);
            }
            return false;
        }
        return false;
    }

    @Override
    public final float floatValue() {
        if (this.bigValue == null) {
            return this.value;
        }
        return this.bigValue.floatValue();
    }

    @Override
    public final boolean hasFunctor(long val, int arity) {
        return this.value == val && this.bigValue == null && arity == 0;
    }

    @Override
    public final boolean hasFunctor(BigInteger val, int arity) {
        return this.bigValue != null && arity == 0 && this.bigValue.equals(val);
    }

    @Override
    public final int intValue() {
        if (this.bigValue != null || this.value < java.lang.Integer.MIN_VALUE || this.value > java.lang.Integer.MAX_VALUE) {
            throw new JPLException("cannot represent value as an int");
        }
        return (int)this.value;
    }

    @Override
    public final boolean isBig() {
        return this.bigValue != null;
    }

    @Override
    public final long longValue() {
        if (this.bigValue != null) {
            throw new JPLException("cannot represent value as a long");
        }
        return this.value;
    }

    @Override
    protected final void put(Map<String, term_t> varnames_to_vars, term_t term) {
        if (this.isBig()) {
            Prolog.put_integer_big(term, this.bigValue.toString());
        } else {
            Prolog.put_integer(term, this.value);
        }
    }

    public String toString() {
        if (this.bigValue == null) {
            return Long.toString(this.value);
        }
        return this.bigValue.toString(10);
    }

    @Override
    public final int type() {
        return 3;
    }

    @Override
    public String typeName() {
        return "Integer";
    }
}

