/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.io.File;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.JPLException;
import org.jpl7.JRef;
import org.jpl7.Term;
import org.jpl7.Version;
import org.jpl7.fli.Prolog;

public class JPL {
    protected static final boolean DEBUG = false;
    public static final Term JFALSE = new Compound("@", new Term[]{new Atom("false")});
    public static final Term JTRUE = new Compound("@", new Term[]{new Atom("true")});
    public static final Term JNULL = new Compound("@", new Term[]{new Atom("null")});
    public static final Term JVOID = new Compound("@", new Term[]{new Atom("void")});
    protected static boolean modeDontTellMe = true;
    protected static final Atom LIST_NIL_MODERN = new Atom("[]", "reserved_symbol");
    protected static final Atom LIST_NIL_TRADITIONAL = new Atom("[]", "text");
    public static Atom LIST_NIL = LIST_NIL_MODERN;
    protected static final String LIST_PAIR_MODERN = "[|]";
    protected static final String LIST_PAIR_TRADITIONAL = ".";
    public static String LIST_PAIR = "[|]";
    private static String nativeLibraryName = "jpl";
    private static String nativeLibraryDir = null;
    private static String nativeLibraryPath = null;
    private static final Version version_ = new Version();

    public static String setNativeLibraryName(String newName) {
        if (newName == null) {
            throw new NullPointerException("newName cannot be null");
        }
        String oldName = nativeLibraryName;
        nativeLibraryName = newName;
        return oldName;
    }

    public static String setNativeLibraryDir(String newDir) {
        String oldDir = nativeLibraryDir;
        nativeLibraryDir = newDir;
        return oldDir;
    }

    public static String setNativeLibraryPath(String newPath) {
        String oldPath = nativeLibraryPath;
        nativeLibraryPath = newPath;
        return oldPath;
    }

    public static void loadNativeLibrary() {
        if (nativeLibraryPath != null) {
            System.load(new File(nativeLibraryPath).getAbsolutePath());
        } else if (nativeLibraryDir != null) {
            System.load(new File(nativeLibraryDir, System.mapLibraryName(nativeLibraryName)).getAbsolutePath());
        } else {
            System.loadLibrary(nativeLibraryName);
        }
    }

    public static String jarPath() {
        try {
            return Class.forName("org.jpl7.JPL").getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (ClassNotFoundException e) {
            return "";
        }
    }

    public static void setDTMMode(boolean dtm) {
        modeDontTellMe = dtm;
    }

    public static void setTraditional() {
        if (JPL.getSyntax().equals("modern")) {
            if (JPL.getActualInitArgs() == null) {
                LIST_NIL = LIST_NIL_TRADITIONAL;
                LIST_PAIR = LIST_PAIR_TRADITIONAL;
                JPL.setDefaultInitArgs(JPL.argsEnsureSyntax(JPL.getDefaultInitArgs()));
            } else {
                throw new JPLException("cannot switch to traditional syntax after Prolog is initialised");
            }
        }
    }

    public static void setTraditionalAnyway() {
        LIST_NIL = LIST_NIL_TRADITIONAL;
        LIST_PAIR = LIST_PAIR_TRADITIONAL;
    }

    public static String getSyntax() {
        if (LIST_PAIR.equals(LIST_PAIR_MODERN)) {
            return "modern";
        }
        if (LIST_PAIR.equals(LIST_PAIR_TRADITIONAL)) {
            return "traditional";
        }
        throw new JPLException("syntax is neither traditional nor modern");
    }

    public static String[] getDefaultInitArgs() {
        return Prolog.get_default_init_args();
    }

    public static void setDefaultInitArgs(String[] args) {
        Prolog.set_default_init_args(JPL.argsEnsureSyntax(args));
    }

    private static String[] argsEnsureSyntax(String[] argsA) {
        String[] argsC;
        int qtyTrad = 0;
        for (int iA = 0; iA < argsA.length; ++iA) {
            if (!argsA[iA].equals("--traditional")) continue;
            ++qtyTrad;
        }
        String[] argsB = new String[argsA.length - qtyTrad];
        int iB = 0;
        for (int iA = 0; iA < argsA.length; ++iA) {
            if (argsA[iA].equals("--traditional")) continue;
            argsB[iB++] = argsA[iA];
        }
        if (JPL.getSyntax().equals("modern")) {
            argsC = argsB;
        } else {
            argsC = new String[argsB.length + 1];
            argsC[0] = argsB[0];
            argsC[1] = "--traditional";
            int iC = 2;
            for (int iB2 = 1; iB2 < argsB.length; ++iB2) {
                argsC[iC++] = argsB[iB2];
            }
        }
        return argsC;
    }

    public static String[] getActualInitArgs() {
        return Prolog.get_actual_init_args();
    }

    public static boolean init(String[] args) {
        return Prolog.set_default_init_args(args) && JPL.init();
    }

    public static boolean init() {
        return Prolog.initialise();
    }

    protected static boolean isSimpleName(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        int len = s.length();
        if (len == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (c < 'a' || c > 'z') {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = s.charAt(i);
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static Term newJRef(Object object) {
        if (object == null) {
            return JNULL;
        }
        return new JRef(object);
    }

    protected static String quotedName(String name) {
        return JPL.isSimpleName(name) ? name : "'" + name + "'";
    }

    public static void halt() {
        Prolog.halt(0);
    }

    public static Version version() {
        return version_;
    }

    public static String version_string() {
        return JPL.version_.major + LIST_PAIR_TRADITIONAL + JPL.version_.minor + LIST_PAIR_TRADITIONAL + JPL.version_.patch + "-" + JPL.version_.status;
    }

    public static void main(String[] args) {
        System.out.println(JPL.version_string());
    }
}

