/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Float;
import org.jpl7.Integer;
import org.jpl7.JPLException;
import org.jpl7.PrologException;
import org.jpl7.Term;
import org.jpl7.Util;
import org.jpl7.Variable;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.engine_t;
import org.jpl7.fli.fid_t;
import org.jpl7.fli.predicate_t;
import org.jpl7.fli.qid_t;
import org.jpl7.fli.term_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements Iterable<Map<String, Term>>,
Iterator<Map<String, Term>> {
    protected final Term goal_;
    protected final String hostModule = "user";
    protected final String contextModule = "user";
    private boolean open = false;
    private engine_t engine = null;
    private predicate_t predicate = null;
    private fid_t fid = null;
    private term_t term0 = null;
    private qid_t qid = null;

    public final Term goal() {
        return this.goal_;
    }

    public Query(Term t) {
        this.goal_ = this.Query1(t);
    }

    private Term Query1(Term t) {
        if (t instanceof Atom) {
            return t;
        }
        if (t instanceof Compound) {
            return t;
        }
        if (t instanceof Float) {
            throw new JPLException("a Query's goal must be an Atom or Compound (not a Float)");
        }
        if (t instanceof Integer) {
            throw new JPLException("a Query's goal must be an Atom or Compound (not an Integer)");
        }
        if (t instanceof Variable) {
            throw new JPLException("a Query's goal must be an Atom or Compound (not a Variable)");
        }
        throw new JPLException("a Query's goal must be an Atom or Compound");
    }

    public Query(String text, Term[] args) {
        this(Query.Query1(text, args));
    }

    public Query(String text, Term arg) {
        this(Query.Query1(text, new Term[]{arg}));
    }

    private static Term Query1(String text, Term[] args) {
        Term t = Util.textToTerm(text);
        if (t instanceof Atom) {
            return new Compound(text, args);
        }
        return t.putParams(args);
    }

    public Query(String text) {
        this(Util.textToTerm(text));
    }

    @Override
    public Iterator<Map<String, Term>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.open) {
            this.open();
        }
        return this.get1();
    }

    @Override
    public Map<String, Term> next() {
        return this.nextSolution();
    }

    @Override
    public void remove() {
    }

    public final boolean isOpen() {
        return this.open;
    }

    public final boolean hasMoreSolutions() {
        if (!this.open) {
            this.open();
        }
        return this.get1();
    }

    public final void open() {
        Term goal;
        String module;
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        this.engine = Prolog.thread_self() == -1 ? Prolog.attach_pool_engine() : Prolog.current_engine();
        if (this.goal_.hasFunctor(":", 2)) {
            if (!this.goal_.arg(1).isAtom()) {
                if (this.goal_.arg(1).isVariable()) {
                    throw new PrologException(Util.textParamsToTerm("error(instantiation_error,?)", new Term[]{this.goal_}));
                }
                throw new PrologException(Util.textParamsToTerm("error(type_error(atom,?),?)", new Term[]{this.goal_.arg(1), this.goal_}));
            }
            module = this.goal_.arg(1).name();
            goal = this.goal_.arg(2);
        } else {
            module = "user";
            goal = this.goal_;
        }
        this.predicate = Prolog.predicate(goal.name(), goal.arity(), module);
        this.fid = Prolog.open_foreign_frame();
        HashMap<String, term_t> varnames_to_vars = new HashMap<String, term_t>();
        this.term0 = Term.putTerms(varnames_to_vars, goal.args());
        this.qid = Prolog.open_query(Prolog.new_module(Prolog.new_atom("user")), 8, this.predicate, this.term0);
        this.open = true;
    }

    private final boolean get1() {
        if (Prolog.next_solution(this.qid)) {
            return true;
        }
        term_t exception_term_t = Prolog.exception(this.qid);
        if (exception_term_t.value != 0L) {
            Term exception_term = Term.getTerm(new HashMap<term_t, Variable>(), exception_term_t);
            this.close();
            throw new PrologException(exception_term);
        }
        this.close();
        return false;
    }

    public final Map<String, Term> getSolution() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        if (this.get1()) {
            return this.get2();
        }
        return null;
    }

    public final Map<String, Term> getSubstWithNameVars() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        if (this.get1()) {
            return this.get2WithNameVars();
        }
        return null;
    }

    public final Map<String, Term> nextSolution() {
        return this.get2();
    }

    private final Map<String, Term> get2() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        HashMap<String, Term> substitution = new HashMap<String, Term>();
        Term.getSubsts(substitution, new HashMap<term_t, Variable>(), this.goal_.args());
        return substitution;
    }

    private final Map<String, Term> get2WithNameVars() {
        if (!this.open) {
            throw new JPLException("Query is not open");
        }
        Term[] args = this.goal_.args();
        Term argNV = args[args.length - 1];
        String nameNV = ((Variable)argNV).name;
        HashMap<String, Term> varnames_to_Terms1 = new HashMap<String, Term>();
        HashMap<term_t, Variable> vars_to_Vars1 = new HashMap<term_t, Variable>();
        args[args.length - 1].getSubst(varnames_to_Terms1, vars_to_Vars1);
        HashMap<String, Term> varnames_to_Terms2 = new HashMap<String, Term>();
        Term nvs = (Term)varnames_to_Terms1.get(nameNV);
        Map<term_t, Variable> vars_to_Vars2 = Util.namevarsToMap(nvs);
        for (int i = 0; i < args.length - 1; ++i) {
            args[i].getSubst(varnames_to_Terms2, vars_to_Vars2);
        }
        return varnames_to_Terms2;
    }

    public final boolean hasMoreElements() {
        return this.hasMoreSolutions();
    }

    public final Object nextElement() {
        return this.nextSolution();
    }

    public final void close() {
        if (!this.open) {
            return;
        }
        if (Prolog.thread_self() == -1) {
            throw new JPLException("no engine is attached to this thread");
        }
        if (Prolog.current_engine().value != this.engine.value) {
            throw new JPLException("this Query's engine is not that which is attached to this thread");
        }
        qid_t topmost = Prolog.current_query();
        if (topmost.value != this.qid.value) {
            throw new JPLException("this Query (" + this.hashCode() + ":" + this.toString() + ") is not topmost (" + topmost.hashCode() + ":" + topmost.toString() + ") within its engine[" + this.engine.value + "]");
        }
        Prolog.close_query(this.qid);
        this.qid = null;
        Prolog.discard_foreign_frame(this.fid);
        this.fid = null;
        if (Prolog.current_query() == null && Prolog.current_engine_is_pool()) {
            Prolog.release_pool_engine();
        }
        this.open = false;
        this.engine = null;
    }

    public final Map<String, Term>[] allSolutions() {
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        ArrayList<Object> l = new ArrayList<Object>();
        while (this.hasNext()) {
            l.add(this.next());
        }
        Map[] t = new HashMap[0];
        return l.toArray(t);
    }

    public static final Map<String, Term>[] allSolutions(Term goal) {
        return new Query(goal).allSolutions();
    }

    public static final Map<String, Term>[] allSolutions(String text) {
        return new Query(text).allSolutions();
    }

    public static final Map<String, Term>[] allSolutions(String text, Term[] params) {
        return new Query(text, params).allSolutions();
    }

    public final Map<String, Term>[] nSolutions(long n) {
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        ArrayList<Object> l = new ArrayList<Object>();
        long i = 0L;
        while (i++ < n && this.hasMoreSolutions()) {
            l.add(this.next());
        }
        Map[] t = new HashMap[0];
        return l.toArray(t);
    }

    public static final Map<String, Term>[] nSolutions(Term goal, long n) {
        return new Query(goal).nSolutions(n);
    }

    public static final Map<String, Term>[] nSolutions(String text, long n) {
        return new Query(text).nSolutions(n);
    }

    public static final Map<String, Term>[] nSolutions(String text, Term[] params, long n) {
        return new Query(text, params).nSolutions(n);
    }

    public final Map<String, Term> oneSolution() {
        Map<String, Term> solution;
        if (this.open) {
            throw new JPLException("Query is already open");
        }
        if (this.hasMoreSolutions()) {
            solution = this.nextSolution();
            this.close();
        } else {
            solution = null;
        }
        return solution;
    }

    public static final Map<String, Term> oneSolution(Term goal) {
        return new Query(goal).oneSolution();
    }

    public static final Map<String, Term> oneSolution(String text) {
        return new Query(text).oneSolution();
    }

    public static final Map<String, Term> oneSolution(String text, Term[] params) {
        return new Query(text, params).oneSolution();
    }

    public final boolean hasSolution() {
        return this.oneSolution() != null;
    }

    public static final boolean hasSolution(Term goal) {
        return new Query(goal).hasSolution();
    }

    public static final boolean hasSolution(String text) {
        return new Query(text).hasSolution();
    }

    public static final boolean hasSolution(String text, Term[] params) {
        return new Query(text, params).hasSolution();
    }

    public String toString() {
        return this.goal_.name() + "( " + Term.toString(this.goal_.args()) + " )";
    }
}

