/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Float;
import org.jpl7.Integer;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.JRef;
import org.jpl7.Variable;
import org.jpl7.fli.DoubleHolder;
import org.jpl7.fli.Int64Holder;
import org.jpl7.fli.IntHolder;
import org.jpl7.fli.ObjectHolder;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.StringHolder;
import org.jpl7.fli.term_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Term {
    protected Term() {
    }

    public Term arg(int i) {
        throw new JPLException("arg(int) is undefined for " + this.typeName() + " instances");
    }

    public Term[] args() {
        throw new JPLException("args() is undefined for " + this.typeName());
    }

    public int arity() {
        return 0;
    }

    public String atomType() {
        throw new JPLException("atomType() is undefined for " + this.typeName());
    }

    public BigInteger bigValue() {
        throw new JPLException("bigValue() is undefined for " + this.typeName());
    }

    public double doubleValue() {
        throw new JPLException("doubleValue() is undefined for " + this.typeName());
    }

    public float floatValue() {
        throw new JPLException("floatValue() is undefined for " + this.typeName());
    }

    protected void getSubst(Map<String, Term> varnames_to_Terms, Map<term_t, Variable> vars_to_Vars) {
    }

    protected static void getSubsts(Map<String, Term> varnames_to_Terms, Map<term_t, Variable> vars_to_Vars, Term[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i].getSubst(varnames_to_Terms, vars_to_Vars);
        }
    }

    protected static Term getTerm(Map<term_t, Variable> vars_to_Vars, term_t term) {
        switch (Prolog.term_type(term)) {
            case 1: {
                for (term_t varX : vars_to_Vars.keySet()) {
                    if (Prolog.compare(varX, term) != 0) continue;
                    return vars_to_Vars.get(varX);
                }
                Variable Var = new Variable();
                Var.term_ = term;
                vars_to_Vars.put(term, Var);
                return Var;
            }
            case 2: {
                StringHolder hString = new StringHolder();
                Prolog.get_atom_chars(term, hString);
                return new Atom(hString.value, "text");
            }
            case 5: {
                StringHolder hString = new StringHolder();
                Prolog.get_string_chars(term, hString);
                return new Atom(hString.value, "string");
            }
            case 3: {
                Int64Holder hInt64 = new Int64Holder();
                if (Prolog.get_integer(term, hInt64)) {
                    return new Integer(hInt64.value);
                }
                StringHolder hString = new StringHolder();
                if (Prolog.get_integer_big(term, hString)) {
                    return new Integer(new BigInteger(hString.value));
                }
                return new Integer(-3L);
            }
            case 4: {
                DoubleHolder hFloatValue = new DoubleHolder();
                Prolog.get_float(term, hFloatValue);
                return new Float(hFloatValue.value);
            }
            case 6: 
            case 9: {
                StringHolder hString = new StringHolder();
                IntHolder hInt = new IntHolder();
                Prolog.get_name_arity(term, hString, hInt);
                Term[] args = new Term[hInt.value];
                for (int i = 1; i <= hInt.value; ++i) {
                    term_t termi = Prolog.new_term_ref();
                    Prolog.get_arg(i, term, termi);
                    args[i - 1] = Term.getTerm(vars_to_Vars, termi);
                }
                return new Compound(hString.value, args);
            }
            case 7: {
                return JPL.LIST_NIL;
            }
            case 8: {
                ObjectHolder hObject = new ObjectHolder();
                if (Prolog.get_jref_object(term, hObject)) {
                    if (hObject.value == null) {
                        return JPL.JNULL;
                    }
                    return new JRef(hObject.value);
                }
                throw new JPLException("unsupported blob type passed from Prolog");
            }
        }
        throw new JPLException("unknown term type=" + Prolog.term_type(term));
    }

    protected static Term getTerm(term_t term) {
        return Term.getTerm(new HashMap<term_t, Variable>(), term);
    }

    public boolean hasFunctor(String name, int arity) {
        return false;
    }

    public boolean hasFunctor(long name, int arity) {
        return false;
    }

    public boolean hasFunctor(BigInteger name, int arity) {
        return false;
    }

    public boolean hasFunctor(double name, int arity) {
        return false;
    }

    public int intValue() {
        throw new JPLException("intValue() is undefined for " + this.typeName());
    }

    public final boolean isAtom() {
        return this instanceof Atom;
    }

    protected boolean isAtomOfNameType(String name, String type) {
        return false;
    }

    public boolean isBig() {
        throw new JPLException("isBig() is undefined for " + this.typeName());
    }

    public boolean isBigInteger() {
        return this instanceof Integer && ((Integer)this).isBig();
    }

    public final boolean isCompound() {
        return this instanceof Compound;
    }

    public final boolean isFloat() {
        return this instanceof Float;
    }

    public final boolean isInteger() {
        return this instanceof Integer;
    }

    public boolean isJFalse() {
        return false;
    }

    public boolean isJNull() {
        return false;
    }

    public final boolean isJRef() {
        return this instanceof JRef;
    }

    public boolean isJTrue() {
        return false;
    }

    public boolean isJVoid() {
        return false;
    }

    public boolean isListNil() {
        return false;
    }

    public boolean isListPair() {
        return false;
    }

    public final boolean isVariable() {
        return this instanceof Variable;
    }

    public Object jrefToObject() {
        throw new JPLException("term is neither a JRef nor a Compound representing @(null)");
    }

    public final int listLength() {
        if (this.isListPair()) {
            return 1 + this.arg(2).listLength();
        }
        if (this.isListNil()) {
            return 0;
        }
        throw new JPLException("term is not a list");
    }

    public long longValue() {
        throw new JPLException("longValue() is undefined for " + this.typeName());
    }

    public String name() {
        throw new JPLException("name() is undefined for " + this.typeName());
    }

    public Object object() {
        throw new JPLException("this Term is not a JRef");
    }

    public static final Term objectToJRef(Object object) {
        if (object == null) {
            return JPL.JNULL;
        }
        if (object instanceof String) {
            throw new JPLException("a JRef cannot have a String value (Strings are represented by text atoms)");
        }
        return new JRef(object);
    }

    protected void put(term_t term) {
        this.put(new HashMap<String, term_t>(), term);
    }

    protected abstract void put(Map<String, term_t> var1, term_t var2);

    public Term putParams(Term[] ps) {
        IntHolder next = new IntHolder();
        next.value = 0;
        Term t2 = this.putParams1(next, ps);
        if (next.value != ps.length) {
            throw new JPLException("more actual params than formal");
        }
        return t2;
    }

    protected Term putParams(Term plist) {
        Term[] ps = plist.toTermArray();
        return this.putParams(ps);
    }

    protected Term putParams1(IntHolder next, Term[] ps) {
        switch (this.type()) {
            case 6: {
                return new Compound(this.name(), Term.putParams2(this.args(), next, ps));
            }
            case 2: {
                if (!this.name().equals("?")) {
                    return this;
                }
                if (next.value >= ps.length) {
                    throw new JPLException("fewer actual params than formal params");
                }
                return ps[next.value++];
            }
        }
        return this;
    }

    protected static Term[] putParams2(Term[] ts, IntHolder next, Term[] ps) {
        int n = ts.length;
        Term[] ts2 = new Term[n];
        for (int i = 0; i < n; ++i) {
            ts2[i] = ts[i].putParams1(next, ps);
        }
        return ts2;
    }

    public static void putTerm(Object obj, term_t termref) {
        if (!(obj instanceof Term)) {
            throw new JPLException("not a Term");
        }
        ((Term)obj).put(termref);
    }

    protected static term_t putTerms(Map<String, term_t> varnames_to_vars, Term[] args) {
        term_t term0 = Prolog.new_term_refs(args.length);
        long ith_term_t = term0.value;
        for (int i = 0; i < args.length; ++i) {
            term_t term = new term_t();
            term.value = ith_term_t++;
            args[i].put(varnames_to_vars, term);
        }
        return term0;
    }

    public Object ref() {
        throw new JPLException("this Term is not a JRef");
    }

    public final Term[] toTermArray() {
        try {
            int len = this.listLength();
            Term[] ts = new Term[len];
            Term t = this;
            for (int i = 0; i < len; ++i) {
                ts[i] = t.arg(1);
                t = t.arg(2);
            }
            return ts;
        }
        catch (JPLException e) {
            throw new JPLException("term is not a proper list");
        }
    }

    protected static boolean terms_equals(Term[] t1, Term[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i].equals(t2[i])) continue;
            return false;
        }
        return true;
    }

    public static String toString(Term[] args) {
        String s = "";
        for (int i = 0; i < args.length; ++i) {
            s = s + args[i].toString();
            if (i == args.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }

    public abstract int type();

    public abstract String typeName();
}

