/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Integer;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.Query;
import org.jpl7.Term;
import org.jpl7.Variable;
import org.jpl7.fli.term_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static Term termArrayToList(Term[] terms) {
        Term list = JPL.LIST_NIL;
        for (int i = terms.length - 1; i >= 0; --i) {
            list = new Compound(JPL.LIST_PAIR, new Term[]{terms[i], list});
        }
        return list;
    }

    public static String toString(Map<String, Term> varnames_to_Terms) {
        if (varnames_to_Terms == null) {
            return "[no solution]";
        }
        Iterator<String> varnames = varnames_to_Terms.keySet().iterator();
        String s = "Bindings: ";
        while (varnames.hasNext()) {
            String varname = varnames.next();
            s = s + varname + "=" + varnames_to_Terms.get(varname).toString() + "; ";
        }
        return s;
    }

    public static Map<term_t, Variable> namevarsToMap(Term nvs) {
        try {
            HashMap<term_t, Variable> vars_to_Vars = new HashMap<term_t, Variable>();
            while (nvs.arity() == 2 && (nvs.name().equals("[|]") || nvs.name().equals(".")) && nvs.arg(1).hasFunctor("=", 2)) {
                vars_to_Vars.put(((Variable)nvs.arg((int)1).arg((int)2)).term_, new Variable(nvs.arg(1).arg(1).name()));
                nvs = nvs.arg(2);
            }
            return vars_to_Vars;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static Term textToTerm(String text) {
        Query q = new Query(new Compound("atom_to_term", new Term[]{new Atom(text), new Variable("Term"), new Variable("NVdict")}));
        q.open();
        Map<String, Term> s = q.getSubstWithNameVars();
        if (s != null) {
            q.close();
            return s.get("Term");
        }
        return null;
    }

    public static Term textParamsToTerm(String text, Term[] params) {
        return Util.textToTerm(text).putParams(params);
    }

    public static Term stringArrayToList(String[] a) {
        Term list = JPL.LIST_NIL;
        for (int i = a.length - 1; i >= 0; --i) {
            list = new Compound(JPL.LIST_PAIR, new Term[]{new Atom(a[i]), list});
        }
        return list;
    }

    public static Term intArrayToList(int[] a) {
        Term list = JPL.LIST_NIL;
        for (int i = a.length - 1; i >= 0; --i) {
            list = new Compound(JPL.LIST_PAIR, new Term[]{new Integer(a[i]), list});
        }
        return list;
    }

    public static Term intArrayArrayToList(int[][] a) {
        Term list = JPL.LIST_NIL;
        for (int i = a.length - 1; i >= 0; --i) {
            list = new Compound(JPL.LIST_PAIR, new Term[]{Util.intArrayToList(a[i]), list});
        }
        return list;
    }

    public static final boolean isList(Term term) {
        return Util.listToLength(term) >= 0;
    }

    public static int listToLength(Term term) {
        int length = 0;
        Term head = term;
        while (head.isListPair()) {
            ++length;
            head = head.arg(2);
        }
        return head.isListNil() ? length : -1;
    }

    public static Term[] listToTermArray(Term t) {
        try {
            int len = t.listLength();
            Term[] ts = new Term[len];
            for (int i = 0; i < len; ++i) {
                ts[i] = t.arg(1);
                t = t.arg(2);
            }
            return ts;
        }
        catch (JPLException e) {
            throw new JPLException("term is not a proper list");
        }
    }

    public static String[] atomListToStringArray(Term t) {
        int n = Util.listToLength(t);
        if (n < 0) {
            return null;
        }
        String[] a = new String[n];
        int i = 0;
        Term head = t;
        while (head.isListPair()) {
            Term x = head.arg(1);
            if (!x.isAtom()) {
                return null;
            }
            a[i++] = x.name();
            head = head.arg(2);
        }
        return head.isListNil() ? a : null;
    }
}

