/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7.util;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SwingGadget
extends JFrame {
    private static final long serialVersionUID = 1L;
    public int numClicks = 0;
    private static String labelPrefix = "Number of button clicks: ";
    final JLabel label = new JLabel(labelPrefix + "0    ");

    public SwingGadget(String caption) {
        super(caption);
        JButton button = new JButton("I'm a Swing button!");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingGadget.this.inc();
            }
        });
        this.label.setLabelFor(button);
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(30, 30, 10, 30));
        pane.setLayout(new GridLayout(0, 1));
        pane.add(button);
        pane.add(this.label);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getContentPane().add((Component)pane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingGadget.this.setVisible(false);
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public synchronized void inc() {
        ++this.numClicks;
        this.label.setText(labelPrefix + this.numClicks);
        this.notifyAll();
    }

    public synchronized boolean dec() {
        try {
            while (this.numClicks <= 0) {
                this.wait();
            }
            --this.numClicks;
            this.label.setText(labelPrefix + this.numClicks);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

