/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.JDOPermission;
import org.jpox.AbstractPersistenceManager;
import org.jpox.ClassLoaderResolver;
import org.jpox.LifecycleListenerForClass;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.exceptions.JPOXException;
import org.jpox.jdo.JPOXJDOHelper;
import org.jpox.util.ClassUtils;

public abstract class AbstractPersistenceManagerFactory
extends ObjectManagerFactoryImpl {
    private static final String VERSION_NUMBER_PROPERTY = "VersionNumber";
    private static final String VENDOR_NAME_PROPERTY = "VendorName";
    private Set pmCache = new HashSet();
    protected List lifecycleListeners;
    private Map sequenceByFactoryClass;
    private static final String[] OPTION_ARRAY = new String[]{"javax.jdo.option.TransientTransactional", "javax.jdo.option.NontransactionalWrite", "javax.jdo.option.NontransactionalRead", "javax.jdo.option.RetainValues", "javax.jdo.option.Optimistic", "javax.jdo.option.ApplicationIdentity", "javax.jdo.option.DatastoreIdentity", "javax.jdo.option.NonDurableIdentity", "javax.jdo.option.ArrayList", "javax.jdo.option.LinkedList", "javax.jdo.option.TreeSet", "javax.jdo.option.TreeMap", "javax.jdo.option.Vector", "javax.jdo.option.List", "javax.jdo.option.Stack", "javax.jdo.option.Map", "javax.jdo.option.HashMap", "javax.jdo.option.Hashtable", "javax.jdo.option.SortedSet", "javax.jdo.option.SortedMap", "javax.jdo.option.Array", "javax.jdo.option.NullCollection", "javax.jdo.option.BinaryCompatibility", "javax.jdo.option.GetDataStoreConnection", "javax.jdo.option.GetJDBCConnection", "javax.jdo.query.SQL", "javax.jdo.option.UnconstrainedQueryVariables", "javax.jdo.option.version.DateTime", "javax.jdo.option.PreDirtyEvent", "javax.jdo.option.mapping.HeterogeneousObjectType", "javax.jdo.option.mapping.HeterogeneousInterfaceType", "javax.jdo.option.mapping.JoinedTablePerClass", "javax.jdo.option.mapping.JoinedTablePerConcreteClass", "javax.jdo.option.mapping.NonJoinedTablePerConcreteClass", "javax.jdo.query.JDOQL", "javax.jdo.query.JPOXSQL"};

    public AbstractPersistenceManagerFactory() {
        if (!ClassUtils.hasJDO2JarInClasspath()) {
            throw new JDOFatalUserException(LOCALISER.msg("PMF.JDO2Inaccessible"));
        }
    }

    protected void freezeConfiguration() {
        if (this.configurable) {
            try {
                this.logConfiguration();
                ClassLoaderResolver clr = this.getOMFContext().getClassLoaderResolver(null);
                clr.registerUserClassLoader(this.getPrimaryClassLoader());
                this.initialiseStoreManager(clr);
                this.initialiseLevel2Cache();
                this.configurable = false;
            }
            catch (JPOXException jpe) {
                throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
            }
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(VENDOR_NAME_PROPERTY, AbstractPersistenceManagerFactory.getVendorName());
        props.setProperty(VERSION_NUMBER_PROPERTY, AbstractPersistenceManagerFactory.getVersionNumber());
        return props;
    }

    public Collection supportedOptions() {
        return Collections.unmodifiableList(Arrays.asList(OPTION_ARRAY));
    }

    protected Set getPmCache() {
        return this.pmCache;
    }

    public void releasePersistenceManager(AbstractPersistenceManager om) {
        this.getPmCache().remove(om);
    }

    protected void assertIsOpen() {
        try {
            super.assertIsOpen();
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
    }

    public synchronized void close() {
        this.assertIsOpen();
        SecurityManager secmgr = System.getSecurityManager();
        if (secmgr != null) {
            secmgr.checkPermission((Permission)JDOPermission.CLOSE_PERSISTENCE_MANAGER_FACTORY);
        }
        Iterator pms = new HashSet(this.getPmCache()).iterator();
        HashSet<JDOUserException> exceptions = new HashSet<JDOUserException>();
        while (pms.hasNext()) {
            try {
                ((AbstractPersistenceManager)pms.next()).close();
            }
            catch (JDOUserException ex) {
                exceptions.add(ex);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("PMF.CloseError"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        super.close();
    }

    public DataStoreCache getDataStoreCache() {
        this.freezeConfiguration();
        return this.cache;
    }

    public List getLifecycleListenerSpecifications() {
        return this.lifecycleListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        Set set = this.pmCache;
        synchronized (set) {
            Iterator pms = this.getPmCache().iterator();
            while (pms.hasNext()) {
                AbstractPersistenceManager pm = (AbstractPersistenceManager)pms.next();
                pm.addInstanceLifecycleListener(listener, classes);
            }
        }
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new ArrayList(5);
        }
        this.lifecycleListeners.add(new LifecycleListenerForClass(listener, classes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        if (listener == null || this.lifecycleListeners == null) {
            return;
        }
        Set set = this.pmCache;
        synchronized (set) {
            Iterator pms = this.getPmCache().iterator();
            while (pms.hasNext()) {
                AbstractPersistenceManager pm = (AbstractPersistenceManager)pms.next();
                pm.removeInstanceLifecycleListener(listener);
            }
        }
        Iterator iter = this.lifecycleListeners.iterator();
        while (iter.hasNext()) {
            LifecycleListenerForClass classListener = (LifecycleListenerForClass)iter.next();
            if (classListener.getListener() != listener) continue;
            iter.remove();
        }
    }

    void addSequenceForFactoryClass(String factoryClassName, Sequence sequence) {
        if (this.sequenceByFactoryClass == null) {
            this.sequenceByFactoryClass = new HashMap();
        }
        this.sequenceByFactoryClass.put(factoryClassName, sequence);
    }

    Sequence getSequenceForFactoryClass(String factoryClassName) {
        if (this.sequenceByFactoryClass == null) {
            return null;
        }
        return (Sequence)this.sequenceByFactoryClass.get(factoryClassName);
    }
}

