/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.jpox.ConnectionFactory;
import org.jpox.ConnectionManager;
import org.jpox.ManagedConnection;
import org.jpox.OMFContext;
import org.jpox.ObjectManager;
import org.jpox.ResourceType;
import org.jpox.TransactionEventListener;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.transaction.Transaction;
import org.jpox.util.Localiser;

public class ConnectionManagerImpl
implements ConnectionManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    OMFContext omfContext;
    Map connectionsPool = new HashMap();
    Set lockedObjectManagers = new HashSet();

    public ConnectionManagerImpl(OMFContext omfContext) {
        this.omfContext = omfContext;
    }

    public boolean hasLockedConnection(ObjectManager om) {
        if (om == null) {
            return false;
        }
        return this.lockedObjectManagers.contains(om);
    }

    public void lockConnection(ObjectManager om) {
        if (om == null) {
            return;
        }
        this.lockedObjectManagers.add(om);
    }

    public void unlockConnection(ObjectManager om) {
        if (om == null) {
            return;
        }
        this.lockedObjectManagers.remove(om);
    }

    public ManagedConnection allocateConnection(ConnectionFactory factory, final ObjectManager om, Map options) {
        XAResource res;
        if (om != null && om.getTransaction().isActive()) {
            if (this.hasLockedConnection(om)) {
                throw new JPOXUserException(LOCALISER.msg("Connection.DataStoreConnectionLocked"));
            }
            ManagedConnection mconn = (ManagedConnection)this.connectionsPool.get(om);
            if (mconn != null) {
                if (!om.isFlushing()) {
                    om.flush(false);
                }
                return mconn;
            }
        }
        Map connOptions = options;
        if (options == null && om != null) {
            connOptions = om.getTransaction().getOptions();
        }
        final ManagedConnection mconn = factory.createManagedConnection(connOptions);
        Transaction tx = null;
        if (om != null && om.getTransaction().isActive()) {
            tx = this.omfContext.getTransactionSystem().getTransactionManager().getTransaction(om);
            om.getTransaction().addTransactionEventListener(new TransactionEventListener(){

                public void transactionStarted() {
                }

                public void transactionRolledBack() {
                    mconn.close();
                    om.getTransaction().removeTransactionEventListener(this);
                    ConnectionManagerImpl.this.connectionsPool.remove(om);
                }

                public void transactionCommitted() {
                    mconn.close();
                    om.getTransaction().removeTransactionEventListener(this);
                    ConnectionManagerImpl.this.connectionsPool.remove(om);
                }
            });
        }
        if (tx != null && (res = mconn.getXAResource()) != null) {
            boolean enlistInLocalTM = true;
            if (options != null && options.get("resource-type") != null && ResourceType.JTA.toString().equalsIgnoreCase((String)options.get("resource-type"))) {
                enlistInLocalTM = false;
            }
            if (enlistInLocalTM) {
                tx.enlistResource(res);
            }
            mconn.setTransactional();
            this.connectionsPool.put(om, mconn);
        }
        return mconn;
    }
}

