/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jpox.ObjectManager;
import org.jpox.TransactionImpl;
import org.jpox.jta.TransactionManagerFinder;
import org.jpox.transaction.JPOXTransactionException;

public class JTATransactionImpl
extends TransactionImpl
implements Synchronization {
    private TransactionManager tm = this.obtainTransactionManager();
    private Transaction jtaTx;
    private boolean registeredSynchronizationOnJtaTx = false;
    private boolean markedForRollback = false;

    JTATransactionImpl(ObjectManager om) {
        super(om);
        this.joinTransaction();
    }

    public boolean isActive() {
        boolean isActive = super.isActive();
        if (isActive) {
            return true;
        }
        this.joinTransaction();
        return isActive;
    }

    private synchronized void joinTransaction() {
        if (this.registeredSynchronizationOnJtaTx) {
            return;
        }
        try {
            this.jtaTx = this.tm.getTransaction();
            if (this.jtaTx != null) {
                this.jtaTx.registerSynchronization((Synchronization)this);
                this.registeredSynchronizationOnJtaTx = true;
            } else if (this.markedForRollback) {
                this.rollback();
                this.markedForRollback = false;
            }
        }
        catch (SystemException se) {
            throw new JPOXTransactionException(LOCALISER.msg("Transaction.JTA.ErrorSynchronizing"), se);
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        if (this.jtaTx != null && !this.active && this.jtaTxIsActive()) {
            this.begin();
        }
    }

    private boolean jtaTxIsActive() {
        try {
            return this.jtaTx.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new JPOXTransactionException("Error while trying to interrogate JTA Transaction's status!");
        }
    }

    private TransactionManager obtainTransactionManager() {
        TransactionManager tm = new TransactionManagerFinder(this.om.getOMFContext()).getTransactionManager(this.om.getClassLoaderResolver());
        if (tm == null) {
            throw new JPOXTransactionException(LOCALISER.msg("Transaction.JTA.ErrorObtainingTransactionManager"));
        }
        return tm;
    }

    public void beforeCompletion() {
        this.internalPreCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCompletion(int status) {
        block5: {
            try {
                if (status == 4) {
                    this.rollback();
                    break block5;
                }
                if (status == 3) {
                    this.internalPostCommit();
                    break block5;
                }
                throw new JPOXTransactionException("Received unexpected transaction status + " + status);
            }
            finally {
                this.jtaTx = null;
                this.registeredSynchronizationOnJtaTx = false;
            }
        }
    }
}

