/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jpox.ClassLoaderResolver;
import org.jpox.ConnectionFactoryRegistry;
import org.jpox.ConnectionManager;
import org.jpox.ImplementationCreator;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.PersistenceConfiguration;
import org.jpox.TransactionSystem;
import org.jpox.TypeManager;
import org.jpox.api.ApiAdapter;
import org.jpox.api.ApiAdapterFactory;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.management.ManagementManager;
import org.jpox.metadata.MetaDataManager;
import org.jpox.plugin.Extension;
import org.jpox.plugin.PluginManager;
import org.jpox.store.StoreManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class OMFContext {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private ImplementationCreator ic;
    private boolean implementationCreatorInitialised = false;
    private StoreManager storeMgr = null;
    private MetaDataManager metaDataManager = null;
    private TransactionSystem txSystem = null;
    private final PersistenceConfiguration persistenceConfig;
    private ManagementManager mgmtManager = null;
    private final PluginManager pluginManager;
    private final TypeManager typeManager;
    private ApiAdapter apiAdapter;
    private String apiName = "JDO";
    private Map classLoaderResolverMap = new HashMap();
    private String classLoaderResolverClassName = null;
    private Class datastoreIdentityClass = null;
    private String domainName;
    private String instanceName;
    private ConnectionFactoryRegistry connFactoryRegistry;
    private ConnectionManager connmgr;
    static /* synthetic */ Class class$org$jpox$OMFContext;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$jpox$ObjectManagerFactoryImpl;

    public OMFContext(PersistenceConfiguration persistenceConfig) {
        this.persistenceConfig = persistenceConfig;
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver(this.getClass().getClassLoader());
        clr.registerUserClassLoader(persistenceConfig.getPrimaryClassLoader());
        this.pluginManager = new PluginManager(this.persistenceConfig, clr);
        this.pluginManager.registerExtensionPoints();
        this.pluginManager.registerExtensions();
        this.domainName = this.persistenceConfig.getPersistenceUnitName();
        if (this.domainName == null) {
            this.domainName = "jpox";
        }
        this.instanceName = "jpox-" + new Random().nextInt();
        this.typeManager = new TypeManager(this.pluginManager, this.getClassLoaderResolver(null));
        ApiAdapterFactory.getInstance().initializeApiAdapterExtensions(this.getClassLoaderResolver(null), this.pluginManager);
        this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(this.apiName);
        this.getManagement();
        this.txSystem = new TransactionSystem(this);
        this.connFactoryRegistry = new ConnectionFactoryRegistry(this);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public synchronized void close() {
        if (this.storeMgr != null) {
            this.storeMgr.close();
            this.storeMgr = null;
        }
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.mgmtManager != null) {
            this.mgmtManager.close();
            this.mgmtManager = null;
        }
        this.classLoaderResolverMap.clear();
        this.classLoaderResolverMap = null;
        this.classLoaderResolverClassName = null;
        this.datastoreIdentityClass = null;
    }

    public Class getDatastoreIdentityClass() {
        if (this.datastoreIdentityClass == null) {
            String dsidName = this.persistenceConfig.getDatastoreIdentityClassName();
            String datastoreIdentityClassName = this.pluginManager.getAttributeValueForExtension("org.jpox.store_datastoreidentity", "name", dsidName, "class-name");
            if (datastoreIdentityClassName == null) {
                throw new JPOXUserException(LOCALISER.msg("DatastoreIdentity.PluginNotFound", dsidName)).setFatal();
            }
            ClassLoaderResolver clr = this.getClassLoaderResolver(null);
            try {
                this.datastoreIdentityClass = clr.classForName(datastoreIdentityClassName, (class$org$jpox$OMFContext == null ? (class$org$jpox$OMFContext = OMFContext.class$("org.jpox.OMFContext")) : class$org$jpox$OMFContext).getClassLoader());
            }
            catch (ClassNotResolvedException cnre) {
                throw new JPOXUserException(LOCALISER.msg("DatastoreIdentity.PluginClassNotFound", dsidName, datastoreIdentityClassName)).setFatal();
            }
        }
        return this.datastoreIdentityClass;
    }

    public ManagementManager getManagement() {
        if (this.mgmtManager == null) {
            this.mgmtManager = new ManagementManager(this);
        }
        return this.mgmtManager;
    }

    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String clrName = this.persistenceConfig.getClassLoaderResolverName();
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.jpox.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new JPOXUserException(LOCALISER.msg("ClassLoaderResolver.PluginNotFound", clrName)).setFatal();
        }
        String key = this.classLoaderResolverClassName;
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if ((clr = (ClassLoaderResolver)this.classLoaderResolverMap.get(key)) == null) {
            try {
                Class<?> cls = Class.forName(this.classLoaderResolverClassName);
                Class[] ctrArgs = null;
                Object[] ctrParams = null;
                if (primaryLoader != null) {
                    ctrArgs = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = OMFContext.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
                    ctrParams = new Object[]{primaryLoader};
                }
                Constructor<?> ctor = cls.getConstructor(ctrArgs);
                clr = (ClassLoaderResolver)ctor.newInstance(ctrParams);
                clr.registerUserClassLoader(this.persistenceConfig.getPrimaryClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new JPOXUserException(LOCALISER.msg("ClassLoaderResolver.PluginClassNotFound", this.classLoaderResolverClassName), cnfe).setFatal();
            }
            catch (Exception e) {
                throw new JPOXUserException(LOCALISER.msg("ClassLoaderResolver.Error", this.classLoaderResolverClassName), e).setFatal();
            }
            this.classLoaderResolverMap.put(key, clr);
        }
        return clr;
    }

    public ImplementationCreator getImplementationCreator() {
        if (!this.implementationCreatorInitialised) {
            try {
                Class<?> cls = null;
                if (this.persistenceConfig.getImplementationCreatorName() != null) {
                    cls = Class.forName(this.persistenceConfig.getImplementationCreatorName(), true, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = OMFContext.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader());
                    this.ic = (ImplementationCreator)cls.newInstance();
                }
                if (this.ic == null) {
                    Extension[] exts = this.getPluginManager().getExtensionPoint("org.jpox.implementation_creator").getExtensions();
                    for (int i = 0; this.ic == null && i < exts.length; ++i) {
                        for (int j = 0; this.ic == null && j < exts[i].getConfigurationElements().length; ++j) {
                            cls = Class.forName(exts[i].getConfigurationElements()[j].getAttribute("class-name"), true, (class$org$jpox$ObjectManagerFactoryImpl == null ? OMFContext.class$("org.jpox.ObjectManagerFactoryImpl") : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader());
                            this.ic = (ImplementationCreator)cls.newInstance();
                        }
                    }
                }
                if (JPOXLogger.GENERAL.isDebugEnabled()) {
                    if (this.ic == null) {
                        JPOXLogger.GENERAL.debug(LOCALISER.msg("OMF.ImplementationCreatorNotConfigured"));
                    } else {
                        JPOXLogger.GENERAL.debug(LOCALISER.msg("OMF.ImplementationCreatorInUse", cls.getName()));
                    }
                }
            }
            catch (InstantiationException e) {
                throw new JPOXException(e.toString(), e).setFatal();
            }
            catch (IllegalAccessException e) {
                throw new JPOXException(e.toString(), e).setFatal();
            }
            catch (ClassNotFoundException e) {
                throw new JPOXException(LOCALISER.msg("OMF.ImplementationCreatorNotFound", this.persistenceConfig.getImplementationCreatorName()), e).setFatal();
            }
        }
        this.implementationCreatorInitialised = true;
        return this.ic;
    }

    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            try {
                this.metaDataManager = (MetaDataManager)this.getPluginManager().createExecutableExtension("org.jpox.metadata_manager", new String[]{"name"}, new String[]{this.apiName}, "class", new Class[]{class$org$jpox$OMFContext == null ? (class$org$jpox$OMFContext = OMFContext.class$("org.jpox.OMFContext")) : class$org$jpox$OMFContext}, new Object[]{this});
            }
            catch (Exception e) {
                throw new JPOXException(LOCALISER.msg("OMF.MetaDataManager.ConstructionError", this.apiName, e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new JPOXException(LOCALISER.msg("OMF.MetaDataManager.NotFoundError", this.apiName));
            }
        }
        return this.metaDataManager;
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfig;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public TransactionSystem getTransactionSystem() {
        return this.txSystem;
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public void setStoreManager(StoreManager storeMgr) {
        if (this.storeMgr == null) {
            this.storeMgr = storeMgr;
        }
    }

    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    public String getApi() {
        return this.apiName;
    }

    public void setApi(String name) {
        this.apiName = name;
        ApiAdapter adapter = ApiAdapterFactory.getInstance().getApiAdapter(name);
        if (adapter != null) {
            this.apiAdapter = adapter;
        } else {
            JPOXLogger.JDO.warn(LOCALISER.msg("OMF.ApiAdapterNotFound", name));
        }
    }

    public ConnectionFactoryRegistry getConnectionFactoryRegistry() {
        return this.connFactoryRegistry;
    }

    public ConnectionManager getConnectionManager() {
        return this.connmgr;
    }

    public void setConnectionManager(ConnectionManager connmgr) {
        this.connmgr = connmgr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

