/*
 * Decompiled with CFR 0.152.
 */
package org.jpox;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.FetchPlan;
import javax.jdo.JDOHelper;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ImplementationCreator;
import org.jpox.JDOFetchPlanImpl;
import org.jpox.JTATransactionImpl;
import org.jpox.OMFContext;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.TransactionImpl;
import org.jpox.cache.CachedPC;
import org.jpox.cache.Level1Cache;
import org.jpox.cache.Level2Cache;
import org.jpox.exceptions.ClassNotDetachableException;
import org.jpox.exceptions.ClassNotPersistableException;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.exceptions.NoPersistenceInformationException;
import org.jpox.exceptions.ObjectDetachedException;
import org.jpox.exceptions.TransactionActiveException;
import org.jpox.exceptions.TransactionNotActiveException;
import org.jpox.jdo.JPOXJDOHelper;
import org.jpox.jdo.exceptions.CommitStateTransitionException;
import org.jpox.jdo.exceptions.RollbackStateTransitionException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.TransactionType;
import org.jpox.state.CallbackHandler;
import org.jpox.state.DetachState;
import org.jpox.state.FetchPlanState;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.Extent;
import org.jpox.store.FieldValues;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.SCOID;
import org.jpox.store.StoreManager;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.SoftValueMap;
import org.jpox.util.StringUtils;
import org.jpox.util.WeakValueMap;

public class ObjectManagerImpl
implements ObjectManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private final ObjectManagerFactoryImpl omf;
    private Object owner;
    private StoreManager srm;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbacks;
    private Level1Cache cache;
    private boolean ignoreCache;
    private PersistenceCapable lookingForStateManagerFor = null;
    private StateManager foundStateManager = null;
    private Transaction tx;
    private Map enlistedSMCache = new WeakValueMap();
    private Set txEnlistedIds = new HashSet();
    private List dirtySMs = new ArrayList(10);
    private Set txKnownPersistedIds = new HashSet();
    private Set txFlushedNewIds = new HashSet();
    private boolean detachOnClose;
    private boolean detachAllOnCommit;
    private boolean multithreaded;
    private boolean flushing = false;
    private Map queryResults = new SoftValueMap();
    private Map queriesRun = new SoftValueMap();
    private boolean runningPBRAtCommit = false;
    private StateManager[] smsToDetachAtCommit = null;
    private int queryResultNumber = 0;
    static /* synthetic */ Class class$org$jpox$OMFContext;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public ObjectManagerImpl(ObjectManagerFactoryImpl omf, Object owner, String userName, String password) {
        this.owner = owner;
        this.omf = omf;
        this.closed = false;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = omf.getOMFContext().getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = omf.getOMFContext().getImplementationCreator();
            if (ic != null) {
                this.clr.registerClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.srm = omf.getOMFContext().getStoreManager();
        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("OM.Opened", this, this.srm));
        }
        this.setIgnoreCache(omf.getPersistenceConfiguration().getIgnoreCache());
        this.setDetachOnClose(omf.getPersistenceConfiguration().getDetachOnClose());
        this.setDetachAllOnCommit(omf.getPersistenceConfiguration().getDetachAllOnCommit());
        this.setMultithreaded(omf.getPersistenceConfiguration().getMultithreaded());
        this.fetchPlan = new JDOFetchPlanImpl().setMaxFetchDepth(omf.getMaxFetchDepth());
        this.initialiseLevel1Cache();
        this.tx = TransactionType.JTA.toString().equalsIgnoreCase(omf.getOMFContext().getPersistenceConfiguration().getTransactionType()) ? new JTATransactionImpl(this) : new TransactionImpl(this);
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.omf.getPersistenceConfiguration().getCacheLevel1Type();
        String level1ClassName = this.omf.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.cache_level1", "name", level1Type, "class-name");
        if (level1ClassName == null) {
            throw new JPOXUserException(LOCALISER.msg("Cache.Level1.PluginNotFound", level1Type)).setFatal();
        }
        try {
            Class level1CacheClass = this.clr.classForName(level1ClassName, (class$org$jpox$OMFContext == null ? (class$org$jpox$OMFContext = ObjectManagerImpl.class$("org.jpox.OMFContext")) : class$org$jpox$OMFContext).getClassLoader());
            this.cache = (Level1Cache)level1CacheClass.newInstance();
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.Initialised", level1Type));
            }
        }
        catch (Exception e) {
            throw new JPOXUserException(LOCALISER.msg("Cache.Level1.PluginClassNotFound", level1Type, level1ClassName), e).setFatal();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public StoreManager getStoreManager() {
        return this.srm;
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public Object getOwner() {
        return this.owner;
    }

    public OMFContext getOMFContext() {
        return this.omf.getOMFContext();
    }

    public MetaDataManager getMetaDataManager() {
        return this.omf.getOMFContext().getMetaDataManager();
    }

    public void setMultithreaded(boolean flag) {
        this.assertIsOpen();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        this.assertIsOpen();
        return this.multithreaded;
    }

    public void setDetachOnClose(boolean flag) {
        this.assertIsOpen();
        this.detachOnClose = flag;
    }

    public boolean getDetachOnClose() {
        this.assertIsOpen();
        return this.detachOnClose;
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.assertIsOpen();
        this.detachAllOnCommit = flag;
    }

    public boolean getDetachAllOnCommit() {
        this.assertIsOpen();
        return this.detachAllOnCommit;
    }

    public void setIgnoreCache(boolean flag) {
        this.assertIsOpen();
        this.ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.ignoreCache;
    }

    public boolean isDelayDatastoreOperationsEnabled() {
        if (this.flushing || this.tx.isCommitting()) {
            return false;
        }
        if (this.tx.getOptimistic()) {
            return true;
        }
        return this.getOMFContext().getPersistenceConfiguration().getDatastoreDelayOperationsEnabled();
    }

    public boolean isInserting(PersistenceCapable pc) {
        StateManager sm = this.findStateManager(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserting();
    }

    public boolean isInserted(PersistenceCapable pc, int fieldNumber) {
        StateManager sm = this.findStateManager(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserted(fieldNumber);
    }

    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    public synchronized void enlistInTransaction(StateManager sm) {
        this.assertActiveTransaction();
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.ObjectEnlistedInCache", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId().toString()));
        }
        if (this.omf.getPersistenceByReachabilityAtCommit()) {
            if (sm.getObject().jdoIsNew()) {
                this.txFlushedNewIds.add(sm.getInternalObjectId());
            } else if (sm.getObject().jdoIsPersistent() && !sm.getObject().jdoIsDeleted() && !this.txFlushedNewIds.contains(sm.getInternalObjectId())) {
                this.txKnownPersistedIds.add(sm.getInternalObjectId());
            }
        }
        if (this.omf.getPersistenceByReachabilityAtCommit() && !this.runningPBRAtCommit) {
            this.txEnlistedIds.add(sm.getInternalObjectId());
        }
        this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
    }

    public synchronized void evictFromTransaction(StateManager sm) {
        if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.ObjectEvictedFromCache", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId().toString()));
        }
        if (this.enlistedSMCache.remove(sm.getInternalObjectId()) == null && JPOXLogger.TRANSACTION.isDebugEnabled()) {
            JPOXLogger.TRANSACTION.debug(LOCALISER.msg("PM.ObjectNotTransactional", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId()));
        }
    }

    public boolean isEnlistedInTransaction(Object id) {
        if (id == null) {
            return false;
        }
        return this.txEnlistedIds.contains(id);
    }

    public synchronized void addStateManager(StateManager sm) {
        this.putObjectIntoCache(sm, true, true);
    }

    public synchronized void removeStateManager(StateManager sm) {
        PersistenceCapable pc = sm.getObject();
        this.removeObjectFromCache(pc, sm.getInternalObjectId(), true, false);
        this.enlistedSMCache.remove(sm.getInternalObjectId());
    }

    public synchronized StateManager getStateManagerById(Object id) {
        this.assertIsOpen();
        PersistenceCapable pc = this.getObjectFromCache(id);
        return this.findStateManager(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StateManager findStateManager(PersistenceCapable pc) {
        StateManager sm = null;
        PersistenceCapable previousLookingFor = this.lookingForStateManagerFor;
        StateManager previousFound = this.foundStateManager;
        try {
            this.lookingForStateManagerFor = pc;
            this.foundStateManager = null;
            ObjectManager om = ObjectManagerHelper.getObjectManager(pc);
            if (om != null && this != om) {
                throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm = this.foundStateManager;
        }
        finally {
            this.lookingForStateManagerFor = previousLookingFor;
            this.foundStateManager = previousFound;
        }
        return sm;
    }

    public synchronized void hereIsStateManager(StateManager sm, PersistenceCapable pc) {
        if (this.lookingForStateManagerFor == pc) {
            this.foundStateManager = sm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.closed) {
            throw new JPOXUserException(LOCALISER.msg("OM.IsClosed"));
        }
        if (this.tx.isActive()) {
            throw new TransactionActiveException(this);
        }
        if (this.detachOnClose) {
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.DetachOnCloseStart"));
            try {
                this.tx.begin();
                ArrayList toDetach = new ArrayList();
                toDetach.addAll(this.cache.values());
                Iterator iter = toDetach.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    StateManager sm = (StateManager)obj;
                    if (sm == null || sm == null || sm.getObject() == null || sm.isDeleted(sm.getObject())) continue;
                    try {
                        sm.detach(new DetachState());
                    }
                    catch (JPOXObjectNotFoundException onfe) {}
                }
                this.tx.commit();
            }
            finally {
                if (this.tx.isActive()) {
                    this.tx.rollback();
                }
            }
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.DetachOnCloseEnd"));
        }
        this.tx.close();
        this.disconnectSMCache();
        this.disconnectQueryCache();
        this.disconnectLifecycleListener();
        this.getFetchPlan().clearGroups().addGroup("default");
    }

    public void postClose() {
        this.closed = true;
        this.srm = null;
        this.tx = null;
        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("OM.Closed", this));
        }
    }

    public void disconnectSMCache() {
        HashSet cachedSMsClone = new HashSet(this.cache.values());
        Iterator iter = cachedSMsClone.iterator();
        while (iter.hasNext()) {
            StateManager sm = (StateManager)iter.next();
            if (sm == null) continue;
            sm.disconnect();
        }
        this.cache.clear();
        if (JPOXLogger.CACHE.isDebugEnabled()) {
            JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.Cleared"));
        }
    }

    public void disconnectQueryCache() {
        if (this.queryResults.size() > 0) {
            Object[] results = this.queryResults.values().toArray();
            for (int i = 0; i < results.length; ++i) {
                QueryResult qr = (QueryResult)results[i];
                qr.close();
            }
            this.queryResults.clear();
        }
        this.queriesRun.clear();
    }

    public void disconnectLifecycleListener() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.evict();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void evictAllObjects() {
        this.assertIsOpen();
        ArrayList stateManagersToEvict = new ArrayList();
        stateManagersToEvict.addAll(this.cache.values());
        Iterator smIter = stateManagersToEvict.iterator();
        while (smIter.hasNext()) {
            StateManager sm = (StateManager)smIter.next();
            PersistenceCapable pc = sm.getObject();
            sm.evict();
            this.removeObjectFromCache(pc, pc.jdoGetObjectId(), true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.refresh();
            this.putObjectIntoCache(sm, false, true);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void refreshAllObjects() {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        HashSet toRefresh = new HashSet();
        toRefresh.addAll(this.enlistedSMCache.values());
        toRefresh.addAll(this.dirtySMs);
        if (!this.tx.isActive()) {
            toRefresh.addAll(this.cache.values());
        }
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            try {
                StateManager sm;
                Object obj = iter.next();
                if (obj instanceof PersistenceCapable) {
                    PersistenceCapable pc = (PersistenceCapable)obj;
                    sm = this.findStateManager(pc);
                } else {
                    sm = (StateManager)obj;
                }
                sm.refresh();
                this.putObjectIntoCache(sm, false, true);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JPOXUserException(LOCALISER.msg("PM.RefreshError"), failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveObject(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.retrieve(fgOnly);
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public Object persistObject(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        if (obj == null) {
            return null;
        }
        boolean detached = JDOHelper.isDetached((Object)obj);
        Object persistedPc = this.persistObjectInternal(obj, null);
        StateManager sm = this.findStateManager((PersistenceCapable)persistedPc);
        if (this.omf.getPersistenceByReachabilityAtCommit() && sm != null && (detached || sm.isNew((PersistenceCapable)persistedPc))) {
            this.txKnownPersistedIds.add(sm.getInternalObjectId());
        }
        return persistedPc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object persistObjectInternal(Object obj, FieldValues preInsertChanges) {
        if (obj == null) {
            return null;
        }
        this.assertIsOpen();
        this.assertWritable();
        try {
            StateManager sm;
            ObjectManager om;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (!pc.jdoIsDetached() && JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.MakePersistent", StringUtils.toJVMIDString(pc)));
            }
            if ((om = ObjectManagerHelper.getObjectManager(pc)) != null && om != this) {
                throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", obj));
            }
            Object persistedPc = pc;
            if (pc.jdoIsDetached()) {
                this.assertDetachable(obj);
                persistedPc = this.attachObjectCopy(pc, pc.jdoGetObjectId() == null);
            } else if (pc.jdoIsTransactional() && !pc.jdoIsPersistent()) {
                sm = this.findStateManager(pc);
                if (sm == null) {
                    throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
                }
                sm.makePersistentTransactionalTransient();
            } else if (!pc.jdoIsPersistent()) {
                if (this.multithreaded) {
                    sm = pc;
                    synchronized (sm) {
                        StateManager sm2 = this.findStateManager(pc);
                        if (sm2 == null) {
                            sm2 = StateManagerFactory.newStateManagerForPersistentNew(this, pc, preInsertChanges);
                            sm2.makePersistent();
                        } else if (sm2.getAttachedPC() == null) {
                            sm2.makePersistent();
                        } else {
                            persistedPc = sm2.getAttachedPC();
                        }
                    }
                } else {
                    sm = this.findStateManager(pc);
                    if (sm == null) {
                        sm = StateManagerFactory.newStateManagerForPersistentNew(this, pc, preInsertChanges);
                        sm.makePersistent();
                    } else if (sm.getAttachedPC() == null) {
                        sm.makePersistent();
                    } else {
                        persistedPc = sm.getAttachedPC();
                    }
                }
            } else if (pc.jdoIsPersistent() && pc.jdoGetObjectId() == null) {
                if (this.multithreaded) {
                    sm = pc;
                    synchronized (sm) {
                        StateManager sm3 = this.findStateManager(pc);
                        sm3.makePersistent();
                    }
                } else {
                    sm = this.findStateManager(pc);
                    sm.makePersistent();
                }
            }
            PersistenceCapable persistenceCapable = persistedPc;
            return persistenceCapable;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized Object attachObjectCopy(Object pc, boolean sco) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        Object id = ((PersistenceCapable)pc).jdoGetObjectId();
        if (id != null && this.isInserting((PersistenceCapable)pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null);
        }
        if (((PersistenceCapable)pc).jdoIsPersistent()) {
            return pc;
        }
        PersistenceCapable pcTarget = null;
        if (sco) {
            boolean detached = false;
            if (JDOHelper.isDetached((Object)pc)) {
                detached = true;
            }
            StateManager smTarget = StateManagerFactory.newStateManagerForEmbedded(this, (PersistenceCapable)pc, true);
            pcTarget = smTarget.getObject();
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.MakePersistentAttach", StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(pcTarget)));
            }
            if (detached) {
                smTarget.attachCopy((PersistenceCapable)pc, sco);
            }
        } else {
            pcTarget = (PersistenceCapable)this.findObject(id, false, false, pc.getClass().getName());
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.MakePersistentAttach", StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(pcTarget)));
            }
            this.findStateManager(pcTarget).attachCopy((PersistenceCapable)pc, sco);
        }
        return pcTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(Object obj) {
        if (obj == null) {
            return;
        }
        this.assertIsOpen();
        this.assertWritable();
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (pc.jdoIsDetached()) {
                pc = (PersistenceCapable)this.findObject(pc.jdoGetObjectId(), true, true, null);
            }
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.DeletePersistent", StringUtils.toJVMIDString(pc)));
            }
            if (!pc.jdoIsPersistent() && !pc.jdoIsTransactional()) {
                throw new JPOXUserException(LOCALISER.msg("PM.DeletePersistentOnTransientInstances"));
            }
            if (!pc.jdoIsPersistent() && pc.jdoIsTransactional()) {
                throw new JPOXUserException(LOCALISER.msg("PM.DeletePersistentOnTransactionalInstances"));
            }
            StateManager sm = this.findStateManager(pc);
            if (sm == null) {
                throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", pc.jdoGetObjectId()));
            }
            sm.deletePersistent();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public void deleteObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        for (int i = 0; i < objs.length; ++i) {
            try {
                this.deleteObject(objs[i]);
                continue;
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JPOXUserException(LOCALISER.msg("PM.DeletePersistentError"), failures.toArray(new Exception[failures.size()]));
        }
    }

    public void deleteObjects(Collection objs) {
        if (objs == null) {
            return;
        }
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            try {
                this.deleteObject(obj);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JPOXUserException(LOCALISER.msg("PM.DeletePersistentError"), failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("PM.MakeTransient", StringUtils.toJVMIDString(pc)));
            }
            if (pc.jdoIsPersistent()) {
                StateManager sm = this.findStateManager(pc);
                sm.makeTransient(state);
            }
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            StateManager sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (pc.jdoIsPersistent()) {
                this.assertActiveTransaction();
            }
            if ((sm = this.findStateManager(pc)) == null) {
                sm = StateManagerFactory.newStateManagerForTransactionalTransient(this, pc);
            }
            sm.makeTransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            PersistenceCapable pc = (PersistenceCapable)obj;
            if (!pc.jdoIsPersistent() && pc.jdoIsTransactional() && pc.jdoIsDirty()) {
                throw new JPOXUserException(LOCALISER.msg("PM.MakeNonTransactionalOnTransientDirtyInstances"));
            }
            StateManager sm = this.findStateManager(pc);
            sm.makeNontransactional();
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public synchronized void detachObject(Object obj, FetchPlanState state) {
        StateManager sm;
        this.assertIsOpen();
        this.assertClassPersistable(obj.getClass());
        this.assertDetachable(obj);
        if (JDOHelper.isDetached((Object)obj)) {
            return;
        }
        if (!JDOHelper.isPersistent((Object)obj) && this.tx.isActive()) {
            this.persistObjectInternal(obj, null);
        }
        if ((sm = this.findStateManager((PersistenceCapable)obj)) == null) {
            throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", ((PersistenceCapable)obj).jdoGetObjectId()));
        }
        sm.detach(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        Object thePC = pc;
        try {
            PersistenceCapable detached;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!JDOHelper.isPersistent((Object)pc) && !JDOHelper.isDetached((Object)pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null);
                } else {
                    throw new JPOXUserException(LOCALISER.msg("PM.Detach.TransientOutsideTransaction"));
                }
            }
            if (((PersistenceCapable)thePC).jdoIsDetached()) {
                thePC = this.findObject(JDOHelper.getObjectId((Object)thePC), false, true, null);
            }
            if ((detached = ((DetachState)state).getDetachedCopyObject(thePC)) == null) {
                StateManager sm = this.findStateManager((PersistenceCapable)thePC);
                if (sm == null) {
                    throw new JPOXUserException(LOCALISER.msg("PM.DifferentOwner", ((PersistenceCapable)thePC).jdoGetObjectId()));
                }
                detached = (PersistenceCapable)sm.detachCopy(state);
                ((DetachState)state).setDetachedCopyObject(detached, sm.getExternalObjectId(sm.getObject()));
            }
            PersistenceCapable persistenceCapable = detached;
            return persistenceCapable;
        }
        finally {
            this.clr.unsetPrimary();
        }
    }

    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = JDOHelper.getObjectId((Object)obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (JPOXObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    public synchronized Object findObjectUsingAID(Class pcClass, FieldValues fv, boolean ignoreCache, boolean checkInheritance) {
        PersistenceCapable pc;
        Object oid;
        this.assertIsOpen();
        StateManager sm = StateManagerFactory.newStateManagerForHollowPopulatedAppId(this, pcClass, fv);
        if (!ignoreCache) {
            String[] subclasses;
            oid = sm.getInternalObjectId();
            pc = this.getObjectFromCache(oid);
            if (pc != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                return pc;
            }
            if (checkInheritance && (oid instanceof OID || oid instanceof SingleFieldIdentity) && (subclasses = this.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    if (oid instanceof OID) {
                        oid = OIDFactory.getInstance(this, subclasses[i], ((OID)oid).getKeyValue());
                    } else if (oid instanceof SingleFieldIdentity) {
                        oid = AIDUtils.getNewSingleFieldIdentity(oid.getClass(), this.clr.classForName(subclasses[i]), ((SingleFieldIdentity)oid).getKeyAsObject());
                    }
                    pc = this.getObjectFromCache(oid);
                    if (pc == null) continue;
                    sm = this.findStateManager(pc);
                    sm.loadFieldValues(fv);
                    return pc;
                }
            }
        }
        if (checkInheritance) {
            sm.checkInheritance(fv);
            if (!ignoreCache && (pc = this.getObjectFromCache(oid = sm.getInternalObjectId())) != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                return pc;
            }
        }
        this.putObjectIntoCache(sm, true, true);
        return sm.getObject();
    }

    public synchronized Object findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache) {
        this.assertIsOpen();
        PersistenceCapable pc = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            StateManager sm = StateManagerFactory.newStateManagerForHollowPopulated(this, cls, id, fv);
            pc = sm.getObject();
            this.putObjectIntoCache(sm, true, true);
        } else {
            StateManager sm = this.findStateManager(pc);
            if (sm != null) {
                fv.fetchNonLoadedFields(sm);
            }
        }
        return pc;
    }

    public synchronized Object findObject(Object id, FieldValues fv) {
        this.assertIsOpen();
        PersistenceCapable pc = this.getObjectFromCache(id);
        if (pc == null) {
            String className = this.srm.getClassNameForObjectID(id, this.clr, this);
            if (className == null) {
                throw new JPOXObjectNotFoundException(LOCALISER.msg("PM.ObjectDoesntExist"), id);
            }
            if (id instanceof OID) {
                id = OIDFactory.getInstance(this, className, ((OID)id).getKeyValue());
                pc = this.getObjectFromCache(id);
            }
            if (pc == null) {
                try {
                    Class pcClass = this.clr.classForName(className, id.getClass().getClassLoader());
                    StateManager sm = StateManagerFactory.newStateManagerForHollowPopulated(this, pcClass, id, fv);
                    pc = sm.getObject();
                    this.putObjectIntoCache(sm, true, true);
                }
                catch (ClassNotResolvedException e) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id));
                    throw new JPOXUserException(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id), e);
                }
            }
        }
        return pc;
    }

    public synchronized Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        this.assertIsOpen();
        if (id == null) {
            throw new JPOXUserException(LOCALISER.msg("PM.GetObjectByIdNullId"));
        }
        PersistenceCapable pc = this.getObjectFromCache(id);
        boolean fromCache = true;
        if (id instanceof SCOID && pc != null && JDOHelper.isPersistent((Object)pc) && !JDOHelper.isNew((Object)pc) && !JDOHelper.isDeleted((Object)pc) && !JDOHelper.isTransactional((Object)pc)) {
            throw new JPOXUserException(LOCALISER.msg("OM.AccessHollowNondurableObjectError"));
        }
        StateManager sm = null;
        if (pc == null) {
            String className = null;
            String originalClassName = null;
            boolean checkedClassName = false;
            if (id instanceof SCOID) {
                throw new JPOXUserException(LOCALISER.msg("OM.AccessNondurableObjectNotFound"));
            }
            if (id instanceof OID) {
                originalClassName = this.srm.manageClassForIdentity((OID)id, this.getClassLoaderResolver());
            } else if (id instanceof SingleFieldIdentity) {
                originalClassName = this.srm.manageClassForIdentity((SingleFieldIdentity)id, this.getClassLoaderResolver());
            } else if (objectClassName != null) {
                originalClassName = objectClassName;
            } else {
                originalClassName = this.srm.getClassNameForObjectID(id, this.clr, this);
                checkedClassName = true;
            }
            if (checkInheritance) {
                className = !checkedClassName ? this.srm.getClassNameForObjectID(id, this.clr, this) : originalClassName;
                if (className == null) {
                    throw new JPOXObjectNotFoundException(LOCALISER.msg("PM.ObjectDoesntExist"), id);
                }
                if (originalClassName != null && !originalClassName.equals(className)) {
                    if (id instanceof OID) {
                        id = OIDFactory.getInstance(this, className, ((OID)id).getKeyValue());
                        pc = this.getObjectFromCache(id);
                    } else if (id instanceof SingleFieldIdentity) {
                        id = AIDUtils.getNewSingleFieldIdentity(id.getClass(), this.getClassLoaderResolver().classForName(className), ((SingleFieldIdentity)id).getKeyAsObject());
                        pc = this.getObjectFromCache(id);
                    }
                }
            } else {
                className = originalClassName;
            }
            if (pc == null) {
                try {
                    Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                    sm = StateManagerFactory.newStateManagerForHollow(this, pcClass, id);
                    pc = sm.getObject();
                    fromCache = false;
                }
                catch (ClassNotResolvedException e) {
                    JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id));
                    throw new JPOXUserException(LOCALISER.msg("PM.GetObjectByIdClassNotFound", id), e);
                }
            }
        }
        if (validate) {
            if (sm == null) {
                sm = this.findStateManager(pc);
            }
            sm.validate();
            if (!fromCache) {
                pc = sm.getObject();
            }
        }
        if (sm != null) {
            this.putObjectIntoCache(sm, !fromCache, true);
        }
        return pc;
    }

    public Object newObjectId(Class pcClass, Object key) {
        this.assertIsOpen();
        if (pcClass == null) {
            throw new JPOXUserException(LOCALISER.msg("PM.ObjectId.ClassIsNull"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().addClass(cmd.getFullClassName(), this.clr);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Class idType = this.clr.classForName(cmd.getObjectidClass());
            id = AIDUtils.getNewSingleFieldIdentity(idType, pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = ObjectManagerImpl.class$("java.lang.String")) : class$java$lang$String);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = LOCALISER.msg("PM.NewObjectIdInstance.ConstructionError", cmd.getObjectidClass(), cmd.getFullClassName());
                        JPOXLogger.PERSISTENCE.error(msg);
                        JPOXLogger.PERSISTENCE.error(e);
                        throw new JPOXUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = JDOImplHelper.getInstance().newObjectIdInstance(pcClass, key);
                }
            } else {
                id = OIDFactory.getInstance(this, (String)key);
            }
        } else {
            throw new JPOXUserException(LOCALISER.msg("PM.ObjectId.KeyValueNotSupported", pcClass.getName(), key.getClass().getName()));
        }
        return id;
    }

    public synchronized void clearDirty(StateManager sm) {
        this.dirtySMs.remove(sm);
    }

    public synchronized void markDirty(StateManager sm) {
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new JPOXException("Cannot change objects when transaction is no longer active.");
        }
        boolean isInDirty = this.dirtySMs.contains(sm);
        if (!isInDirty && !this.isDelayDatastoreOperationsEnabled() && this.dirtySMs.size() > 0) {
            this.flush(false);
        }
        if (!isInDirty) {
            this.dirtySMs.add(sm);
        }
    }

    public synchronized void clearDirty() {
        this.dirtySMs.clear();
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(boolean flushToDatastore) {
        this.assertIsOpen();
        if (this.tx.isActive()) {
            this.flushing = true;
            try {
                Object[] toFlush;
                ArrayList<JPOXOptimisticException> optimisticFailures = null;
                List list = this.dirtySMs;
                synchronized (list) {
                    toFlush = this.dirtySMs.toArray();
                    this.clearDirty();
                }
                for (int i = 0; i < toFlush.length; ++i) {
                    StateManager sm = (StateManager)toFlush[i];
                    try {
                        sm.flush();
                        continue;
                    }
                    catch (JPOXOptimisticException oe) {
                        if (optimisticFailures == null) {
                            optimisticFailures = new ArrayList<JPOXOptimisticException>();
                        }
                        optimisticFailures.add(oe);
                    }
                }
                if (flushToDatastore) {
                    this.srm.flush(this);
                }
                if (optimisticFailures != null) {
                    throw new JPOXOptimisticException(LOCALISER.msg("PM.OptimisticVerificationError"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
                }
            }
            finally {
                this.flushing = false;
            }
        }
    }

    public void detachAll() {
        Object[] sms = this.enlistedSMCache.values().toArray();
        FetchPlanState fps = new FetchPlanState();
        for (int i = 0; i < sms.length; ++i) {
            ((StateManager)sms[i]).detach(fps);
        }
    }

    public synchronized void postBegin() {
        StateManager[] sms = this.dirtySMs.toArray(new StateManager[this.dirtySMs.size()]);
        for (int i = 0; i < sms.length; ++i) {
            sms[i].preBegin(this.tx);
        }
    }

    public synchronized void preCommit() {
        this.notifyQueriesOfConnectionClose();
        this.flush(true);
        try {
            if (this.omf.getPersistenceByReachabilityAtCommit()) {
                this.runningPBRAtCommit = true;
                if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                    JPOXLogger.REACHABILITY.debug(LOCALISER.msg("PM.PersistenceByReachability.RunningCommitCheck"));
                }
                if (this.txKnownPersistedIds.size() > 0 && this.txFlushedNewIds.size() > 0) {
                    StateManager sm;
                    int i;
                    HashSet currentReachables = new HashSet();
                    Object[] ids = this.txKnownPersistedIds.toArray();
                    HashSet<Object> objectNotFound = new HashSet<Object>();
                    for (int i2 = 0; i2 < ids.length; ++i2) {
                        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                            JPOXLogger.REACHABILITY.debug("Performing reachability algorithm on object with id \"" + ids[i2] + "\"");
                        }
                        try {
                            StateManager sm2 = this.findStateManager((PersistenceCapable)this.findObject(ids[i2], true, true, null));
                            sm2.runReachability(currentReachables);
                            if (i2 % 10000 != 0 && i2 != ids.length - 1) continue;
                            this.flush(true);
                            continue;
                        }
                        catch (JPOXObjectNotFoundException ex) {
                            objectNotFound.add(ids[i2]);
                        }
                    }
                    this.txFlushedNewIds.removeAll(currentReachables);
                    Object[] nonReachableIds = this.txFlushedNewIds.toArray();
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("PM.PersistenceByReachability.ObjectNoLongerReachable", nonReachableIds[i]));
                        }
                        try {
                            if (objectNotFound.contains(nonReachableIds[i])) continue;
                            sm = this.findStateManager((PersistenceCapable)this.findObject(nonReachableIds[i], true, true, null));
                            sm.nullifyFields();
                            if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                            this.flush(true);
                            continue;
                        }
                        catch (JPOXObjectNotFoundException ex) {
                            // empty catch block
                        }
                    }
                    for (i = 0; i < nonReachableIds.length; ++i) {
                        try {
                            if (objectNotFound.contains(nonReachableIds[i])) continue;
                            sm = this.findStateManager((PersistenceCapable)this.findObject(nonReachableIds[i], true, true, null));
                            sm.deletePersistent();
                            if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                            this.flush(true);
                            continue;
                        }
                        catch (JPOXObjectNotFoundException ex) {
                            // empty catch block
                        }
                    }
                }
                if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                    JPOXLogger.REACHABILITY.debug(LOCALISER.msg("PM.PersistenceByReachability.CompletedCommitCheck"));
                }
            }
        }
        catch (Throwable t) {
            JPOXLogger.PERSISTENCE.error(t);
            if (t instanceof JPOXException) {
                throw (JPOXException)t;
            }
            throw new JPOXException("Unexpected error during precommit", t);
        }
        finally {
            this.runningPBRAtCommit = false;
        }
        this.flush(true);
        if (this.detachAllOnCommit) {
            this.smsToDetachAtCommit = this.getRootStateManagersForDetachAllOnCommit();
            for (int i = 0; i < this.smsToDetachAtCommit.length; ++i) {
                PersistenceCapable pc = this.smsToDetachAtCommit[i].getObject();
                if (pc == null || pc.jdoIsDetached() || pc.jdoIsDeleted()) continue;
                FetchPlanState state = new FetchPlanState();
                this.smsToDetachAtCommit[i].loadFieldsInFetchPlan(state);
            }
        }
    }

    private StateManager[] getRootStateManagersForDetachAllOnCommit() {
        StateManager[] sms = null;
        Collection roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && roots.size() > 0) {
            sms = new StateManager[roots.size()];
            Iterator rootsIter = roots.iterator();
            int i = 0;
            while (rootsIter.hasNext()) {
                Object obj = rootsIter.next();
                sms[i++] = this.findStateManager((PersistenceCapable)obj);
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            ArrayList<StateManager> smList = new ArrayList<StateManager>();
            StateManager[] txSMs = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            block1: for (int i = 0; i < txSMs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txSMs[i].getObject().getClass() != rootClasses[j]) continue;
                    smList.add(txSMs[i]);
                    continue block1;
                }
            }
            sms = smList.toArray(new StateManager[smList.size()]);
        } else {
            sms = this.cache.values().toArray(new StateManager[this.cache.values().size()]);
        }
        return sms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postCommit() {
        int i;
        if (this.detachAllOnCommit) {
            StateManager[] smsToDetach = this.smsToDetachAtCommit;
            DetachState state = new DetachState();
            for (i = 0; i < smsToDetach.length; ++i) {
                PersistenceCapable pc = smsToDetach[i].getObject();
                if (pc == null) continue;
                smsToDetach[i].detach(state);
            }
            this.smsToDetachAtCommit = null;
        }
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        try {
            StateManager[] sms = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            for (i = 0; i < sms.length; ++i) {
                try {
                    if (sms[i] == null || sms[i].getObject() == null || !sms[i].getObject().jdoIsPersistent() && !sms[i].getObject().jdoIsTransactional()) continue;
                    sms[i].postCommit(this.getTransaction());
                    if (!this.detachAllOnCommit || !(sms[i].getObject() instanceof Detachable)) continue;
                    this.removeStateManager(sms[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    failures.add(e);
                }
            }
        }
        finally {
            this.enlistedSMCache.clear();
            this.txEnlistedIds.clear();
            this.txKnownPersistedIds.clear();
            this.txFlushedNewIds.clear();
            ((JDOFetchPlanImpl)this.fetchPlan).resetDetachmentRoots();
        }
        if (!failures.isEmpty()) {
            throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    private void notifyQueriesOfConnectionClose() {
        Object[] results = this.queryResults.values().toArray();
        for (int i = 0; i < results.length; ++i) {
            QueryResult queryResult = (QueryResult)results[i];
            queryResult.closingConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preRollback() {
        this.notifyQueriesOfConnectionClose();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        try {
            Collection sms = this.enlistedSMCache.values();
            Iterator smsIter = sms.iterator();
            while (smsIter.hasNext()) {
                StateManager sm = (StateManager)smsIter.next();
                try {
                    sm.preRollback(this.getTransaction());
                }
                catch (RuntimeException e) {
                    failures.add(e);
                }
            }
            this.clearDirty();
        }
        finally {
            this.enlistedSMCache.clear();
            this.txEnlistedIds.clear();
            this.txKnownPersistedIds.clear();
            this.txFlushedNewIds.clear();
        }
        if (!failures.isEmpty()) {
            throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    public synchronized void replaceObjectId(PersistenceCapable pc, Object oldID, Object newID) {
        StateManager sm;
        if (pc == null || pc.jdoGetObjectId() == null) {
            JPOXLogger.CACHE.warn(LOCALISER.msg("Cache.Level1.AddingNullObjectError"));
            return;
        }
        Object o = this.cache.get(oldID);
        if (o != null) {
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.SwappingId", StringUtils.toJVMIDString(pc), oldID, newID));
            }
            this.cache.remove(oldID);
            this.cache.put(newID, o);
        }
        if (this.omf.getCacheLevel2()) {
            sm = this.findStateManager(pc);
            this.putObjectIntoCache(sm, false, true);
        }
        if (this.enlistedSMCache.get(oldID) != null && (sm = this.findStateManager(pc)) != null) {
            this.enlistedSMCache.remove(oldID);
            this.enlistedSMCache.put(newID, sm);
            if (JPOXLogger.TRANSACTION.isDebugEnabled()) {
                JPOXLogger.TRANSACTION.debug(LOCALISER.msg("Transaction.ObjectEnlistedInCacheChanged", StringUtils.toJVMIDString(pc), oldID, newID));
            }
        }
        if (this.omf.getPersistenceByReachabilityAtCommit()) {
            if (this.txEnlistedIds.remove(oldID)) {
                this.txEnlistedIds.add(newID);
            }
            if (this.txFlushedNewIds.remove(oldID)) {
                this.txFlushedNewIds.add(newID);
            }
            if (this.txKnownPersistedIds.remove(oldID)) {
                this.txKnownPersistedIds.add(newID);
            }
        }
    }

    public synchronized void putObjectIntoCache(StateManager sm, boolean level1, boolean level2) {
        Object id = sm.getInternalObjectId();
        if (id == null || sm.getObject() == null) {
            JPOXLogger.CACHE.warn(LOCALISER.msg("Cache.Level1.AddingNullObjectError"));
            return;
        }
        if (level1) {
            StateManager oldSM = this.cache.put(sm.getInternalObjectId(), sm);
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                if (oldSM == null) {
                    JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.AddingObject", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId()));
                } else {
                    JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.UpdatingObject", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId()));
                }
            }
        }
        if (level2 && this.omf.getCacheLevel2()) {
            boolean storeInL2Cache = true;
            AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(sm.getObject().getClass(), this.clr);
            if (acmd != null && acmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNumbers = acmd.getPrimaryKeyFieldNumbers();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractPropertyMetaData fmd;
                    if (!(class$javax$jdo$spi$PersistenceCapable == null ? ObjectManagerImpl.class$("javax.jdo.spi.PersistenceCapable") : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom((fmd = acmd.getManagedFieldAbsolute(pkFieldNumbers[i])).getType())) continue;
                    storeInL2Cache = false;
                }
            }
            if (storeInL2Cache) {
                if (JPOXLogger.CACHE.isDebugEnabled()) {
                    JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.AddingObject", StringUtils.toJVMIDString(sm.getObject()), id));
                }
                CachedPC pcCopy = sm.getL2CacheableObject();
                this.omf.getLevel2Cache().put(id, pcCopy);
            }
        }
    }

    public synchronized void removeObjectFromCache(PersistenceCapable pc, Object id, boolean level1, boolean level2) {
        if (level1 && id != null) {
            Object pcRemoved;
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RemovingObject", StringUtils.toJVMIDString(pc), id, String.valueOf(this.cache.size())));
            }
            if ((pcRemoved = this.cache.remove(id)) == null && JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RemovalOfObjectFailed", StringUtils.toJVMIDString(pc), id));
            }
        }
        if (level2 && this.omf.getCacheLevel2() && pc.jdoGetObjectId() != null) {
            Level2Cache l2Cache = this.omf.getLevel2Cache();
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.RemovingObject", StringUtils.toJVMIDString(pc), pc.jdoGetObjectId(), String.valueOf(l2Cache.getSize())));
            }
            l2Cache.evict(pc.jdoGetObjectId());
        }
    }

    public synchronized PersistenceCapable getObjectFromCache(Object id) {
        PersistenceCapable pc = null;
        StateManager sm = (StateManager)this.cache.get(id);
        if (sm != null) {
            pc = sm.getObject();
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RetrievalOfObject", StringUtils.toJVMIDString(pc), id, "" + this.cache.size()));
            }
            sm.resetDetachState();
            return pc;
        }
        if (JPOXLogger.CACHE.isDebugEnabled()) {
            JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level1.RetrievalFailed", id, "" + this.cache.size()));
        }
        if (this.omf.getCacheLevel2()) {
            Level2Cache l2Cache = this.omf.getLevel2Cache();
            CachedPC cachedPC = l2Cache.get(id);
            if (cachedPC != null) {
                sm = StateManagerFactory.newStateManagerForCachedPC(this, cachedPC.getPersistenceCapable(), id, cachedPC.getLoadedFields());
                pc = sm.getObject();
                if (JPOXLogger.CACHE.isDebugEnabled()) {
                    JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.RetrievalOfObject", StringUtils.toJVMIDString(pc), id, "" + l2Cache.getSize()));
                }
                return pc;
            }
            if (JPOXLogger.CACHE.isDebugEnabled()) {
                JPOXLogger.CACHE.debug(LOCALISER.msg("Cache.Level2.RetrievalFailed", id, "" + l2Cache.getSize()));
            }
        }
        return null;
    }

    public void removeAllInstanceLifecycleListeners() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    public CallbackHandler getCallbackHandler() {
        if (this.callbacks != null) {
            return this.callbacks;
        }
        String callbackHandlerClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.callbackhandler", "name", this.getOMFContext().getApi(), "class-name");
        if (callbackHandlerClassName != null) {
            try {
                this.callbacks = (CallbackHandler)this.clr.classForName(callbackHandlerClassName, (class$org$jpox$OMFContext == null ? (class$org$jpox$OMFContext = ObjectManagerImpl.class$("org.jpox.OMFContext")) : class$org$jpox$OMFContext).getClassLoader()).newInstance();
                return this.callbacks;
            }
            catch (InstantiationException e) {
                JPOXLogger.PERSISTENCE.error(LOCALISER.msg("CallbackHandler.InstantiationError", callbackHandlerClassName, e));
            }
            catch (IllegalAccessException e) {
                JPOXLogger.PERSISTENCE.error(LOCALISER.msg("CallbackHandler.InstantiationError", callbackHandlerClassName, e));
            }
        }
        return null;
    }

    public int addQueryResult(QueryResult queryResult) {
        int resultsNumber = this.queryResultNumber++;
        this.queryResults.put(new Integer(resultsNumber), queryResult);
        return resultsNumber;
    }

    public void removeQueryResult(int resultsNumber) {
        this.queryResults.remove(new Integer(resultsNumber));
    }

    public void addQueryRun(String singleStringQuery) {
        this.queriesRun.put(singleStringQuery, singleStringQuery);
    }

    public boolean hasQueryRun(String singleStringQuery) {
        return this.queriesRun.get(singleStringQuery) != null;
    }

    public void removeQueryRun(String singleStringQuery) {
        this.queriesRun.remove(singleStringQuery);
    }

    public void addListener(Object listener, Class[] classes) {
        this.assertIsOpen();
        if (listener == null) {
            return;
        }
        this.getCallbackHandler().addListener(listener, classes);
    }

    public void removeListener(Object listener) {
        this.assertIsOpen();
        if (listener != null) {
            this.getCallbackHandler().removeListener(listener);
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JPOXUserException(LOCALISER.msg("OM.IsClosed")).setFatal();
        }
    }

    public void assertClassPersistable(Class cls) {
        if (cls != null && !this.getOMFContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !ClassUtils.isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && JDOHelper.isDetached((Object)object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertWritable() {
        if (!this.getTransaction().isActive() && !this.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertHasImplementationCreator() {
        if (this.getOMFContext().getImplementationCreator() == null) {
            throw new JPOXUserException(LOCALISER.msg("PM.ImplementationCreatorDoesNotExist"));
        }
    }

    protected void assertActiveTransactionOrNontransactionRead(String operation) {
        if (!this.tx.isActive() && !this.tx.getNontransactionalRead()) {
            throw new JPOXUserException(LOCALISER.msg("PM.NonTransactionalOperationInvalid", operation));
        }
    }

    public void unloadField(PersistenceCapable pc, String fieldName) {
        this.findStateManager(pc).unloadField(fieldName);
    }

    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver()) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                JPOXLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver()) != null;
        }
        return false;
    }

    public synchronized Extent getExtent(Class pcClass, boolean subclasses) {
        this.assertIsOpen();
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        try {
            clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            Extent extent = this.getStoreManager().getExtent(this, pcClass, subclasses);
            return extent;
        }
        catch (JPOXException jpe) {
            throw JPOXJDOHelper.getJDOExceptionForJPOXException(jpe);
        }
        finally {
            clr.unsetPrimary();
        }
    }

    public synchronized Query newQuery() {
        return this.getStoreManager().newQuery("javax.jdo.query.JDOQL", this, null);
    }

    public Object newInstance(Class persistenceCapable) {
        this.assertIsOpen();
        this.assertHasImplementationCreator();
        return this.getOMFContext().getImplementationCreator().newInstance(persistenceCapable, this.getMetaDataManager(), this.getClassLoaderResolver());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

