/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.api;

import java.util.HashMap;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.api.ApiAdapter;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.PluginManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class ApiAdapterFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    HashMap adapters = new HashMap();
    static ApiAdapterFactory adapterMgr = new ApiAdapterFactory();
    static /* synthetic */ Class class$org$jpox$ObjectManagerFactoryImpl;

    public static ApiAdapterFactory getInstance() {
        return adapterMgr;
    }

    protected ApiAdapterFactory() {
    }

    private void addAdapter(String name, ApiAdapter apiAdapter) {
        if (name == null || apiAdapter == null) {
            return;
        }
        this.adapters.put(name, apiAdapter);
    }

    public Map getRegisteredApiAdapters() {
        return this.adapters;
    }

    public ApiAdapter getApiAdapter(String name) {
        return (ApiAdapter)this.adapters.get(name);
    }

    private ApiAdapter newApiAdapter(ClassLoaderResolver clr, String className) {
        Object adapter_obj;
        if (className == null) {
            return null;
        }
        try {
            Class adapterClass = clr.classForName(className, (class$org$jpox$ObjectManagerFactoryImpl == null ? (class$org$jpox$ObjectManagerFactoryImpl = ApiAdapterFactory.class$("org.jpox.ObjectManagerFactoryImpl")) : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader());
            adapter_obj = adapterClass.newInstance();
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("Api.Adapter.InstantiationError", className, e));
            return null;
        }
        return (ApiAdapter)adapter_obj;
    }

    public void initializeApiAdapterExtensions(ClassLoaderResolver clr, PluginManager pluginMgr) {
        if (this.adapters.size() > 0) {
            return;
        }
        Extension[] ex = pluginMgr.getExtensionPoint("org.jpox.api_adapter").getExtensions();
        for (int i = 0; i < ex.length; ++i) {
            ConfigurationElement[] confElm = ex[i].getConfigurationElements();
            for (int c = 0; c < confElm.length; ++c) {
                adapterMgr.addAdapter(confElm[c].getAttribute("name"), this.newApiAdapter(clr, confElm[c].getAttribute("class-name")));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

