/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.api.ApiAdapter;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InvalidPrimaryKeyException;
import org.jpox.state.LifeCycleState;
import org.jpox.state.jdo.LifeCycleStateFactory;
import org.jpox.util.AIDUtils;
import org.jpox.util.ClassUtils;
import org.jpox.util.Localiser;

public class JDOAdapter
implements ApiAdapter {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields) {
        if (ClassUtils.isInnerClass(pkClass.getName()) && !Modifier.isStatic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.InnerNotStaticError", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (!Modifier.isPublic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.NotPublicError", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = JDOAdapter.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(pkClass)) {
            throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.NotSerializableError", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (AIDUtils.isSingleFieldIdentityClass(pkClass.getName())) {
            if (noOfPkFields != 1) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.SingleFieldIdMultipleFieldsError", (Object)cmd.getFullClassName());
            }
        } else {
            Constructor constructor;
            try {
                constructor = pkClass.getConstructor(new Class[0]);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.DefaultConstructorError", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException ex) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.DefaultConstructorError", (Object)cmd.getFullClassName(), pkClass.getName());
            }
            try {
                constructor = pkClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = JDOAdapter.class$("java.lang.String")) : class$java$lang$String);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.StringConstructorError", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                Method method = pkClass.getMethod("toString", new Class[0]);
                if (method == null || !Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = JDOAdapter.class$("java.lang.Object")) : class$java$lang$Object)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.ToStringError", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            int noPkFields = this.processPrimaryKeyClass(pkClass, cmd, clr);
            Collection superclasses = ClassUtils.getSuperclasses(pkClass);
            if (superclasses != null && superclasses.size() > 0) {
                Iterator superclassIter = superclasses.iterator();
                while (superclassIter.hasNext()) {
                    Class supercls = (Class)superclassIter.next();
                    noPkFields += this.processPrimaryKeyClass(supercls, cmd, clr);
                }
            }
            if (noOfPkFields != noPkFields && cmd.getIdentityType() == IdentityType.APPLICATION) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.IncorrectNumberOfPKFieldsError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)("" + noOfPkFields), "" + noPkFields);
            }
        }
        return true;
    }

    private int processPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        int noOfPkFields = 0;
        Field[] fieldsInPkClass = pkClass.getDeclaredFields();
        for (int i = 0; i < fieldsInPkClass.length; ++i) {
            if (Modifier.isStatic(fieldsInPkClass[i].getModifiers())) continue;
            if (!fieldsInPkClass[i].getType().isPrimitive() && !(class$java$io$Serializable == null ? JDOAdapter.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(fieldsInPkClass[i].getType())) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldNotSerializableError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            if (!Modifier.isPublic(fieldsInPkClass[i].getModifiers())) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldNotPublicError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            AbstractPropertyMetaData fieldInPcClass = cmd.getField(fieldsInPkClass[i].getName());
            boolean found_field = false;
            if (fieldInPcClass == null) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldNotFound", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            if (fieldInPcClass.getTypeName().equals(fieldsInPkClass[i].getType().getName())) {
                found_field = true;
            }
            if (!found_field) {
                String fieldTypePkClass = fieldsInPkClass[i].getType().getName();
                AbstractClassMetaData ref_cmd = cmd.getMetaDataManager().getMetaDataForClassInternal(fieldInPcClass.getType(), clr);
                if (ref_cmd == null) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldPersistenceCapableError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName());
                }
                if (!fieldTypePkClass.equals(ref_cmd.getObjectidClass())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldShouldReferObjectIdClass", cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, ref_cmd.getObjectidClass());
                }
                found_field = true;
            }
            if (!found_field) {
                throw new InvalidPrimaryKeyException(LOCALISER, "PrimaryKey.FieldPersistenceCapableError", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName());
            }
            ++noOfPkFields;
        }
        return noOfPkFields;
    }

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public boolean getDefaultCascadePersistForField() {
        return true;
    }

    public boolean getDefaultCascadeUpdateForField() {
        return true;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public boolean isPersistable(Class cls) {
        if (cls == null) {
            return false;
        }
        return (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = JDOAdapter.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(cls);
    }

    public Map getDefaultFactoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.jpox.identifierFactory", "jpox");
        props.put("org.jpox.query.allowAllSQLStatements", "false");
        props.put("javax.jdo.option.NontransactionalRead", "false");
        props.put("javax.jdo.option.DetachAllOnCommit", "false");
        props.put("org.jpox.persistenceByReachabilityAtCommit", "true");
        props.put("org.jpox.rdbms.stringDefaultLength", "256");
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

