/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.jta;

import javax.transaction.TransactionManager;
import org.jpox.ClassLoaderResolver;
import org.jpox.OMFContext;
import org.jpox.jta.TransactionManagerLocator;

public class TransactionManagerFinder {
    static String[] locators = null;
    String locator = null;

    public TransactionManagerFinder(OMFContext ctx) {
        if (locators == null) {
            locators = ctx.getPluginManager().getAttributeValuesForExtension("org.jpox.jta_locator", null, null, "class-name");
        }
        if (ctx.getPersistenceConfiguration().getJtaLocator() != null) {
            this.locator = ctx.getPluginManager().getAttributeValueForExtension("org.jpox.jta_locator", "name", ctx.getPersistenceConfiguration().getJtaLocator(), "class-name");
        }
    }

    public TransactionManager getTransactionManager(ClassLoaderResolver clr) {
        if (this.locator != null) {
            TransactionManager tm = this.getTransactionManagerForLocator(clr, this.locator);
            if (tm != null) {
                return tm;
            }
        } else {
            for (int i = 0; i < locators.length; ++i) {
                TransactionManager tm = this.getTransactionManagerForLocator(clr, locators[i]);
                if (tm == null) continue;
                return tm;
            }
        }
        return null;
    }

    protected TransactionManager getTransactionManagerForLocator(ClassLoaderResolver clr, String locatorClassName) {
        try {
            TransactionManager tm;
            TransactionManagerLocator loc;
            Class cls = clr.classForName(locatorClassName);
            if (cls != null && (loc = (TransactionManagerLocator)cls.newInstance()) != null && (tm = loc.getTransactionManager(clr)) != null) {
                return tm;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

