/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.management;

import org.jpox.OMFContext;
import org.jpox.exceptions.JPOXException;
import org.jpox.management.ManagementServer;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class ManagementManager {
    private final OMFContext omfContext;
    private boolean closed = false;
    private ManagementServer mgmtServer;

    public ManagementManager(OMFContext ctxt) {
        this.omfContext = ctxt;
        this.startManagementServer();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    private void startManagementServer() {
        if (this.mgmtServer == null) {
            try {
                this.mgmtServer = (ManagementServer)this.omfContext.getPluginManager().createExecutableExtension("org.jpox.management_server", "name", "default", "class", null, null);
            }
            catch (Exception e) {
                JPOXLogger.MANAGEMENT.warn("Error instantiating or connecting to Management Server : " + StringUtils.getStringFromStackTrace(e));
            }
            if (this.mgmtServer != null) {
                this.mgmtServer.start();
            }
        }
    }

    private void stopManagementServer() {
        if (this.mgmtServer != null) {
            this.mgmtServer.stop();
        }
    }

    public ManagementServer getManagementServer() {
        return this.mgmtServer;
    }

    public synchronized void close() {
        this.assertNotClosed();
        this.stopManagementServer();
        this.closed = true;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new JPOXException("Management instance is closed and cannot be used. You must adquire a new PMFContext").setFatal();
        }
    }
}

