/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.EventListenerMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.QueryResultMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.MacroString;
import org.jpox.util.StringUtils;
import org.jpox.util.ViewUtils;

public abstract class AbstractClassMetaData
extends ExtendableMetaData {
    protected static Localiser LOCALISER_API = Localiser.getInstance("org.jpox.Localisation");
    protected final String name;
    protected String entityName;
    protected IdentityType identityType = IdentityType.DATASTORE;
    protected ClassPersistenceModifier persistenceModifier = null;
    protected String persistenceCapableSuperclass;
    protected String objectidClass;
    protected boolean requiresExtent = true;
    protected boolean detachable = false;
    protected boolean embeddedOnly = false;
    protected String catalog;
    protected String schema;
    protected String table;
    protected final String fullName;
    protected VersionMetaData versionMetaData;
    protected IdentityMetaData identityMetaData;
    protected boolean identitySpecified = false;
    protected InheritanceMetaData inheritanceMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    protected List listeners = null;
    protected boolean excludeSuperClassListeners = false;
    protected boolean excludeDefaultListeners = false;
    protected FetchGroupMetaData[] fetchGroupMetaData;
    protected Map fetchGroupMetaDataByName;
    protected AbstractClassMetaData pcSuperclassMetaData = null;
    protected boolean metaDataComplete = false;
    protected Collection queries = null;
    protected Collection queryResultMetaData = null;
    protected JoinMetaData[] joinMetaData;
    protected IndexMetaData[] indexMetaData;
    protected ForeignKeyMetaData[] foreignKeyMetaData;
    protected UniqueMetaData[] uniqueMetaData;
    protected List properties = new ArrayList();
    protected List unmappedColumns = null;
    protected List joins = new ArrayList();
    protected List foreignKeys = new ArrayList();
    protected List indexes = new ArrayList();
    protected List uniqueConstraints = new ArrayList();
    protected List fetchGroups = new ArrayList();
    protected AbstractPropertyMetaData[] managedFields;
    protected AbstractPropertyMetaData[] overriddenFields;
    protected Map fieldNumbersByName;
    protected int[] allFieldNumbers;
    protected int[] primaryKeyFieldNumbers;
    protected int[] nonPrimaryKeyFieldNumbers;
    protected boolean[] nonPrimaryKeyFieldFlags;
    protected int[] defaultFetchGroupFieldNumbers;
    protected boolean[] defaultFetchGroupFieldFlags;
    protected int[] secondClassMutableFieldNumbers;
    protected boolean[] secondClassMutableFieldFlags;
    protected int[] persistenceCapableFieldNumbers;
    protected int noOfInheritedManagedFields = 0;
    protected boolean usesSingleFieldIdentityClass;
    protected transient boolean persistentInterfaceImplNeedingTableFromSuperclass = false;
    protected transient boolean persistentInterfaceImplNeedingTableFromSubclass = false;
    protected Boolean hasRelations = null;
    protected int[] secondClassNonContainerFieldNumbers = null;
    protected int[] secondClassContainerFieldNumbers = null;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    protected AbstractClassMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, String entityName) {
        super(parent);
        if (name == null) {
            throw new JPOXUserException(LOCALISER.msg("MetaData.Parser.ExpectedValueInAttribute", "name", this.getPackageName(), "class"));
        }
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.NameNotSpecified.Error", (Object)parent.name);
        }
        this.name = name;
        this.fullName = ClassUtils.createFullClassName(parent.name, name);
        this.objectidClass = StringUtils.isWhitespace(objectidClass) ? null : ClassUtils.createFullClassName(parent.name, objectidClass);
        this.identityType = IdentityType.getIdentityType(identityType);
        this.requiresExtent = requiresExtent == null || !requiresExtent.equalsIgnoreCase("false");
        this.detachable = detachable == null || !detachable.equalsIgnoreCase("false");
        this.embeddedOnly = embeddedOnly != null && embeddedOnly.equalsIgnoreCase("true");
        this.catalog = StringUtils.isWhitespace(catalog) ? null : catalog;
        this.schema = StringUtils.isWhitespace(schema) ? null : schema;
        this.table = StringUtils.isWhitespace(table) ? null : table;
        this.persistenceModifier = ClassPersistenceModifier.getClassPersistenceModifier(modifier);
        this.entityName = entityName != null ? entityName : null;
        this.persistenceCapableSuperclass = StringUtils.isWhitespace(persistenceCapableSuperclass) ? null : ClassUtils.createFullClassName(parent.name, persistenceCapableSuperclass);
    }

    public AbstractClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyFields) {
        this((PackageMetaData)imd.parent, implClassName, imd.identityType.toString(), imd.objectidClass, imd.requiresExtent ? "true" : "false", imd.detachable ? "true" : "false", imd.embeddedOnly ? "true" : "false", ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString(), null, imd.catalog, imd.schema, imd.table, imd.entityName);
        if (copyFields) {
            this.copyFieldsFromInterface(imd);
        }
        this.setVersionMetaData(imd.versionMetaData);
        this.setIdentityMetaData(imd.identityMetaData);
        this.setPrimaryKeyMetaData(imd.primaryKeyMetaData);
        if (imd.inheritanceMetaData != null) {
            if (imd.inheritanceMetaData.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
                this.persistentInterfaceImplNeedingTableFromSuperclass = true;
            } else if (imd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                this.persistentInterfaceImplNeedingTableFromSubclass = true;
            }
            InheritanceMetaData inhmd = new InheritanceMetaData(this, InheritanceStrategy.NEW_TABLE.toString());
            if (imd.inheritanceMetaData.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
                for (AbstractClassMetaData acmd = imd.getSuperAbstractClassMetaData(); acmd != null; acmd = acmd.getSuperAbstractClassMetaData()) {
                    if (acmd.getInheritanceMetaData() == null || acmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.NEW_TABLE) continue;
                    if (acmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                        inhmd.setDiscriminatorMetaData(new DiscriminatorMetaData(inhmd, acmd.getInheritanceMetaData().getDiscriminatorMetaData()));
                    }
                    inhmd.setJoinMetaData(acmd.getInheritanceMetaData().getJoinMetaData());
                    break;
                }
            } else if (imd.inheritanceMetaData.getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                if (imd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                    inhmd.setDiscriminatorMetaData(new DiscriminatorMetaData(inhmd, imd.getInheritanceMetaData().getDiscriminatorMetaData()));
                }
                inhmd.setJoinMetaData(imd.getInheritanceMetaData().getJoinMetaData());
            }
            this.setInheritanceMetaData(inhmd);
        }
        if (imd.joinMetaData != null) {
            for (int i = 0; i < imd.joinMetaData.length; ++i) {
                this.addJoin(imd.joinMetaData[i]);
            }
        }
        if (imd.foreignKeyMetaData != null) {
            for (int i = 0; i < imd.foreignKeyMetaData.length; ++i) {
                this.addForeignKey(imd.foreignKeyMetaData[i]);
            }
        }
        if (imd.indexMetaData != null) {
            for (int i = 0; i < imd.indexMetaData.length; ++i) {
                this.addIndex(imd.indexMetaData[i]);
            }
        }
        if (imd.uniqueMetaData != null) {
            for (int i = 0; i < imd.uniqueMetaData.length; ++i) {
                this.addUniqueConstraint(imd.uniqueMetaData[i]);
            }
        }
        if (imd.fetchGroupMetaData != null) {
            for (int i = 0; i < imd.fetchGroupMetaData.length; ++i) {
                this.addFetchGroup(imd.fetchGroupMetaData[i]);
            }
        }
        if (this.queries != null) {
            Iterator iter = this.queries.iterator();
            this.addQuery((QueryMetaData)iter.next());
        }
        if (imd.listeners != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.addAll(imd.listeners);
        }
    }

    protected void copyFieldsFromInterface(InterfaceMetaData imd) {
        for (int i = 0; i < imd.getNoOfInheritedManagedFields() + imd.getNoOfManagedFields(); ++i) {
            FieldMetaData fmd = new FieldMetaData((MetaData)this, imd.getManagedFieldAbsolute(i));
            this.addProperty(fmd);
        }
    }

    protected void checkInitialised() {
        if (!this.isInitialised()) {
            throw new JPOXException(LOCALISER.msg("MetaData.Class.NotInitialisedError", this.fullName)).setFatal();
        }
    }

    protected void checkPopulated() {
        if (!this.isPopulated() && !this.isInitialised()) {
            throw new JPOXException(LOCALISER.msg("MetaData.Class.NotPopulatedError", this.fullName)).setFatal();
        }
    }

    protected Class loadClass(ClassLoaderResolver clr, ClassLoader primary) {
        Class cls;
        if (clr == null) {
            JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.Class.UsingDefaultClassLoaderResolver", this.fullName));
            clr = this.getMetaDataManager().getOMFContext().getClassLoaderResolver(null);
        }
        try {
            cls = clr.classForName(this.fullName, primary, false);
        }
        catch (ClassNotResolvedException cnre) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.ClassNotFoundError", this.fullName));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.ClassNotFoundError", (Object)this.fullName);
        }
        if (cls == null) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.ClassNotFoundError", this.fullName));
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.ClassNotFoundError", (Object)this.fullName);
        }
        return cls;
    }

    protected void determineIdentity() {
        if (this.identityType == null) {
            if (this.objectidClass != null) {
                this.identityType = IdentityType.APPLICATION;
            } else {
                int noOfPkKeys = 0;
                Iterator fieldsIter = this.properties.iterator();
                while (fieldsIter.hasNext()) {
                    AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fieldsIter.next();
                    if (!fmd.isPrimaryKey()) continue;
                    ++noOfPkKeys;
                }
                this.identityType = noOfPkKeys == 1 ? IdentityType.APPLICATION : IdentityType.DATASTORE;
            }
        }
    }

    protected void addPropertiesNotInMetaData(Class cls) {
        Collections.sort(this.properties);
        try {
            Method[] clsMethods = cls.getDeclaredMethods();
            for (int i = 0; i < clsMethods.length; ++i) {
                String fieldName;
                if (!clsMethods[i].getDeclaringClass().getName().equals(this.fullName) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Collections.binarySearch(this.properties, fieldName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.AddingUnspecifiedField", fieldName, this.name));
                AbstractPropertyMetaData fmd = this.newDefaultedProperty(fieldName);
                this.properties.add(fmd);
                Collections.sort(this.properties);
            }
        }
        catch (Exception e) {
            JPOXLogger.METADATA.error(e.getMessage(), e);
            throw new JPOXUserException(e.getMessage());
        }
    }

    protected void determineSuperClassName(ClassLoaderResolver clr, Class cls) {
        String realPcSuperclassName = null;
        Collection superclasses = null;
        superclasses = cls.isInterface() ? ClassUtils.getSuperinterfaces(cls) : ClassUtils.getSuperclasses(cls);
        if (!superclasses.isEmpty()) {
            Iterator superclassesIter = superclasses.iterator();
            while (superclassesIter.hasNext()) {
                Class superclass = (Class)superclassesIter.next();
                AbstractClassMetaData superCmd = this.getMetaDataManager().getMetaDataForClassInternal(superclass, clr);
                if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
                realPcSuperclassName = superclass.getName();
                break;
            }
        }
        if (this.persistenceCapableSuperclass != null && !this.persistenceCapableSuperclass.equals(realPcSuperclassName)) {
            try {
                AbstractClassMetaData superCmd = this.getMetaDataManager().getMetaDataForClassInternal(clr.classForName(this.persistenceCapableSuperclass), clr);
                if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.IsNotPCError", (Object)this.name, this.persistenceCapableSuperclass);
                }
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.ClassNotFoundError", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (realPcSuperclassName != null) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.InvalidDefinition", (Object)this.name, (Object)realPcSuperclassName, this.persistenceCapableSuperclass);
            }
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.IsNotSuperclassError", (Object)this.name, this.persistenceCapableSuperclass);
        }
        if (this.persistenceCapableSuperclass == null && realPcSuperclassName != null) {
            this.persistenceCapableSuperclass = realPcSuperclassName;
            if (JPOXLogger.METADATA.isDebugEnabled()) {
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.PersistenceCapableSuperclass.Set", this.name, this.persistenceCapableSuperclass));
            }
        }
        this.validateSuperClass(clr, cls, superclasses);
    }

    private void validateSuperClass(ClassLoaderResolver clr, Class cls, Collection superclasses) {
        if (this.persistenceCapableSuperclass != null) {
            Class pcsc = null;
            try {
                pcsc = clr.classForName(this.persistenceCapableSuperclass);
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.NotFoundError", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (this.persistenceCapableSuperclass.equals(this.fullName) || !pcsc.isAssignableFrom(cls)) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.IsNotSuperclassError", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (this.getMetaDataManager() != null) {
                this.pcSuperclassMetaData = this.getMetaDataManager().getMetaDataForClassInternal(pcsc, clr);
                if (this.pcSuperclassMetaData == null) {
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.IsNotPCError", (Object)this.name, this.persistenceCapableSuperclass);
                }
            } else {
                String superclass_pkg_name = this.persistenceCapableSuperclass.substring(0, this.persistenceCapableSuperclass.lastIndexOf(46));
                PackageMetaData pmd = this.getPackageMetaData().getFileMetaData().getPackage(superclass_pkg_name);
                if (pmd != null) {
                    String superclass_class_name = this.persistenceCapableSuperclass.substring(this.persistenceCapableSuperclass.lastIndexOf(46) + 1);
                    this.pcSuperclassMetaData = pmd.getClass(superclass_class_name);
                }
            }
            if (this.pcSuperclassMetaData == null) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.NoSuperclassMetaDataError", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (!this.pcSuperclassMetaData.isPopulated() && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.populate(clr, cls.getClassLoader());
            }
        } else if (!superclasses.isEmpty()) {
            Iterator superclassesIter = superclasses.iterator();
            while (superclassesIter.hasNext()) {
                Class superclass = (Class)superclassesIter.next();
                AbstractClassMetaData superCmd = this.getMetaDataManager().getMetaDataForClassInternal(superclass, clr);
                if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.NoSuperclassYetSuperclassIsPC", (Object)this.fullName, superclass.getName());
            }
        }
    }

    protected void validateUserInputForIdentity() {
        if (this.pcSuperclassMetaData != null) {
            AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
            IdentityMetaData imd = baseCmd.getIdentityMetaData();
            if (baseCmd.identitySpecified && this.identitySpecified && imd != null && imd.getStrategyValue() != null && this.identityMetaData != null && this.identityMetaData.getStrategyValue() != null && this.identityMetaData.getStrategyValue() != imd.getStrategyValue()) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.IdentityStrategyNotEqualsSuperClassIdentityStrategy", (Object)this.fullName, (Object)this.identityMetaData.getStrategyValue(), imd.getStrategyValue());
            }
        }
    }

    public AbstractClassMetaData getBaseAbstractClassMetaData() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseAbstractClassMetaData();
        }
        return this;
    }

    protected void inheritDetachableSettings() {
        if (this.persistenceCapableSuperclass != null && !this.isDetachable() && this.pcSuperclassMetaData.isDetachable()) {
            this.detachable = true;
        }
    }

    protected void inheritIdentity() {
        if (this.persistenceCapableSuperclass != null) {
            if (this.objectidClass != null) {
                String superObjectIdClass = this.pcSuperclassMetaData.getObjectidClass();
                if (superObjectIdClass == null || !this.objectidClass.equals(superObjectIdClass)) {
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PersistenceCapableSuperclass.ObjectIdClassDiffersFromSuperclassError", (Object)this.name, this.persistenceCapableSuperclass);
                }
                JPOXLogger.METADATA.warn(LOCALISER.msg("MetaData.Class.PersistenceCapableSuperclass.ObjectIdClassSpecifiedWarning", this.name, this.persistenceCapableSuperclass));
            } else {
                this.objectidClass = this.pcSuperclassMetaData.getObjectidClass();
            }
            if (this.identityType == null) {
                this.identityType = this.pcSuperclassMetaData.getIdentityType();
            }
            if (!this.identityType.equals(this.pcSuperclassMetaData.getIdentityType())) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.IdentityTypeNotEqualsSuperClassIdentityType", (Object)this.fullName);
            }
        }
    }

    protected AbstractPropertyMetaData newDefaultedProperty(String name) {
        return new PropertyMetaData((MetaData)this, name);
    }

    protected void validateUserInputForInheritanceMetaData() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
            AbstractClassMetaData superCmd = AbstractClassMetaData.getClassManagingTableForClass(this);
            if (superCmd == null) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.Inheritance.NoSuperclassError", (Object)this.fullName);
            }
            DiscriminatorMetaData superDismd = superCmd.getInheritanceMetaData().getDiscriminatorMetaData();
            if (superDismd == null) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.Inheritance.NoSuperclassDiscriminator", (Object)this.fullName, superCmd.fullName);
            }
            DiscriminatorMetaData dismd = this.inheritanceMetaData.getDiscriminatorMetaData();
            if (superDismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP && (dismd == null || dismd.getValue() == null)) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.Inheritance.NoDiscriminatorValue", (Object)this.fullName, (Object)superCmd.fullName, superDismd.getColumnName());
            }
        }
    }

    private static AbstractClassMetaData getClassManagingTableForClass(AbstractClassMetaData cmd) {
        if (cmd == null) {
            return null;
        }
        InheritanceMetaData imd = cmd.getInheritanceMetaData();
        if (imd == null) {
            return cmd;
        }
        if (imd.getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
            return cmd;
        }
        if (imd.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return AbstractClassMetaData.getClassManagingTableForClass(cmd.getSuperAbstractClassMetaData());
        }
        return null;
    }

    public AbstractClassMetaData getSuperAbstractClassMetaData() {
        return this.pcSuperclassMetaData;
    }

    public final DiscriminatorStrategy getDiscriminatorStrategy() {
        if (this.inheritanceMetaData == null) {
            return null;
        }
        if (this.inheritanceMetaData.getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
            if (this.inheritanceMetaData.getDiscriminatorMetaData() != null) {
                return this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy();
            }
            return null;
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().getDiscriminatorStrategy();
        }
        return null;
    }

    protected void determineObjectIdClass(ClassLoaderResolver clr) {
        int no_of_pk_fields;
        if (this.objectidClass == null && this.persistenceCapableSuperclass == null && this.identityType == IdentityType.APPLICATION) {
            Class pk_type;
            no_of_pk_fields = 0;
            AbstractPropertyMetaData fmd_pk = null;
            Iterator fields_pk_iter = this.properties.iterator();
            while (fields_pk_iter.hasNext()) {
                AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_pk_iter.next();
                if (!fmd.isPrimaryKey()) continue;
                fmd_pk = fmd;
                ++no_of_pk_fields;
            }
            if (no_of_pk_fields > 1 || no_of_pk_fields == 0) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.SingleFieldIdentityInvalid", this.fullName, "" + no_of_pk_fields));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.SingleFieldIdentityInvalid", (Object)this.fullName, "" + no_of_pk_fields);
            }
            if ((class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractClassMetaData.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(pk_type = fmd_pk.getType()) || Byte.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_BYTE_IDENTITY;
            } else if ((class$java$lang$Character == null ? (class$java$lang$Character = AbstractClassMetaData.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(pk_type) || Character.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_CHAR_IDENTITY;
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractClassMetaData.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(pk_type) || Integer.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_INT_IDENTITY;
            } else if ((class$java$lang$Long == null ? (class$java$lang$Long = AbstractClassMetaData.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(pk_type) || Long.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_LONG_IDENTITY;
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = AbstractClassMetaData.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(pk_type) || Short.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_SHORT_IDENTITY;
            } else if ((class$java$lang$String == null ? (class$java$lang$String = AbstractClassMetaData.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_STRING_IDENTITY;
            } else if ((class$java$lang$Object == null ? (class$java$lang$Object = AbstractClassMetaData.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(pk_type)) {
                this.objectidClass = ClassNameConstants.JAVAX_JDO_IDENTITY_OBJECT_IDENTITY;
            } else {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Class.SingleFieldIdentityInvalidType", this.fullName, pk_type.getName()));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.SingleFieldIdentityInvalidType", (Object)this.fullName, pk_type.getName());
            }
            JPOXLogger.METADATA.info(LOCALISER.msg("MetaData.Class.SingleFieldIdentityUsed", this.fullName, this.objectidClass));
        }
        if ((no_of_pk_fields = this.getNoOfPopulatedPKFields()) == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.PrimaryKeyNotSpecifiedError", (Object)this.fullName, this.objectidClass);
        }
        if (this.objectidClass != null && this.getPersistenceCapableSuperclass() == null) {
            Class obj_cls = null;
            try {
                obj_cls = clr.classForName(this.objectidClass);
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.ObjectIdClass.ClassNotFoundError", (Object)this.fullName, this.objectidClass);
            }
            boolean validated = false;
            HashSet<JPOXException> errors = new HashSet<JPOXException>();
            ApiAdapter apiAdapter = this.getMetaDataManager().getOMFContext().getApiAdapter();
            try {
                if (apiAdapter.isValidPrimaryKeyClass(obj_cls, this, clr, no_of_pk_fields)) {
                    validated = true;
                }
            }
            catch (JPOXException ex) {
                errors.add(ex);
            }
            if (!validated) {
                throw new JPOXUserException(LOCALISER_API.msg("PrimaryKey.InvalidPrimaryKey", obj_cls.getName()), errors.toArray(new Throwable[errors.size()]));
            }
        }
    }

    public abstract void populate(ClassLoaderResolver var1, ClassLoader var2);

    public abstract void initialise();

    protected void determineInheritanceMetaData() {
        if (this.inheritanceMetaData == null) {
            this.inheritanceMetaData = this.pcSuperclassMetaData != null ? (this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? new InheritanceMetaData(this, InheritanceStrategy.NEW_TABLE.toString()) : (this.getMetaDataManager().getOMFContext().getPersistenceConfiguration().getDefaultInheritanceStrategy().equalsIgnoreCase("JPOX") ? new InheritanceMetaData(this, InheritanceStrategy.NEW_TABLE.toString()) : new InheritanceMetaData(this, InheritanceStrategy.SUPERCLASS_TABLE.toString()))) : new InheritanceMetaData(this, InheritanceStrategy.NEW_TABLE.toString());
            return;
        }
        if (this.inheritanceMetaData.getStrategyValue() == null) {
            if (this.pcSuperclassMetaData != null) {
                if (this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                    this.inheritanceMetaData = new InheritanceMetaData(this, InheritanceStrategy.NEW_TABLE.toString());
                } else {
                    this.inheritanceMetaData.strategy = this.getMetaDataManager().getOMFContext().getPersistenceConfiguration().getDefaultInheritanceStrategy().equalsIgnoreCase("JPOX") ? InheritanceStrategy.NEW_TABLE : InheritanceStrategy.SUPERCLASS_TABLE;
                }
            } else {
                this.inheritanceMetaData.strategy = InheritanceStrategy.NEW_TABLE;
            }
        }
    }

    protected void validateDeprecatedMetaData() {
        if (this.hasExtension("use-poid-generator")) {
            throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.UsePoidGeneratorDeprecated", (Object)this.fullName);
        }
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, String dba_vendor_id, ClassLoaderResolver clr) {
        HashMap viewReferences = new HashMap();
        this.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, viewReferences, clr);
    }

    private void getReferencedClassMetaData(final List orderedCMDs, final Set referencedCMDs, final String dba_vendor_id, final Map viewReferences, final ClassLoaderResolver clr) {
        if (!referencedCMDs.contains(this)) {
            String viewDefStr;
            AbstractClassMetaData id_cmd;
            referencedCMDs.add(this);
            for (int i = 0; i < this.managedFields.length; ++i) {
                AbstractPropertyMetaData fmd = this.managedFields[i];
                fmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
            }
            if (this.persistenceCapableSuperclass != null) {
                AbstractClassMetaData super_cmd = this.getSuperAbstractClassMetaData();
                super_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
            }
            if (this.objectidClass != null && (id_cmd = this.getMetaDataManager().getMetaDataForClass(this.objectidClass, clr)) != null) {
                id_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, clr);
            }
            if ((viewDefStr = this.getValueForExtension("view-definition-" + dba_vendor_id)) == null) {
                viewDefStr = this.getValueForExtension("view-definition");
            }
            if (viewDefStr != null) {
                MacroString viewDef = new MacroString(this.fullName, this.getValueForExtension("view-imports"), viewDefStr);
                viewDef.substituteMacros(new MacroString.MacroHandler(){

                    public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                        if (!AbstractClassMetaData.this.getFullClassName().equals(im.className)) {
                            AbstractClassMetaData.this.addViewReference(viewReferences, im.className);
                            AbstractClassMetaData view_cmd = AbstractClassMetaData.this.getMetaDataManager().getMetaDataForClass(im.className, clr);
                            view_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, dba_vendor_id, viewReferences, clr);
                        }
                    }

                    public void onParameterMacro(MacroString.ParameterMacro pm) {
                        throw new JPOXUserException("Parameter macros not allowed in view definitions: " + pm);
                    }
                }, clr);
            }
            orderedCMDs.add(this);
        }
    }

    private void addViewReference(Map viewReferences, String referenced_name) {
        if (this.fullName.equals(referenced_name)) {
            HashSet<String> referencedSet = (HashSet<String>)viewReferences.get(referenced_name);
            if (referencedSet == null) {
                referencedSet = new HashSet<String>();
                viewReferences.put(this.fullName, referencedSet);
            }
            referencedSet.add(referenced_name);
            ViewUtils.checkForCircularViewReferences(viewReferences, this.fullName, referenced_name, null);
        }
    }

    public boolean hasRelations(ClassLoaderResolver clr) {
        if (this.hasRelations == null) {
            this.hasRelations = Boolean.FALSE;
            for (int i = 0; i < this.managedFields.length; ++i) {
                AbstractPropertyMetaData fmd = this.managedFields[i];
                if (fmd.getRelationType(clr) == 0) continue;
                this.hasRelations = Boolean.TRUE;
                break;
            }
        }
        return this.hasRelations;
    }

    public int getNoOfQueries() {
        return this.queries.size();
    }

    public QueryMetaData[] getQueries() {
        return this.queries == null ? null : this.queries.toArray(new QueryMetaData[this.queries.size()]);
    }

    public QueryResultMetaData[] getQueryResultMetaData() {
        if (this.queryResultMetaData == null) {
            return null;
        }
        return this.queryResultMetaData.toArray(new QueryResultMetaData[this.queryResultMetaData.size()]);
    }

    public final VersionMetaData getVersionMetaData() {
        return this.versionMetaData;
    }

    public final JoinMetaData[] getJoinMetaData() {
        return this.joinMetaData;
    }

    public final FetchGroupMetaData[] getFetchGroupMetaData() {
        return this.fetchGroupMetaData;
    }

    public String getFullClassName() {
        return this.fullName;
    }

    public FetchGroupMetaData[] getFetchGroupMetaData(Collection groupNames) {
        HashSet<FetchGroupMetaData> results = new HashSet<FetchGroupMetaData>();
        Iterator iter = groupNames.iterator();
        while (iter.hasNext()) {
            String groupname = (String)iter.next();
            FetchGroupMetaData fgmd = this.getFetchGroupMetaData(groupname);
            if (fgmd == null) continue;
            results.add(fgmd);
        }
        FetchGroupMetaData[] result = new FetchGroupMetaData[results.size()];
        results.toArray(result);
        return result;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public final IndexMetaData[] getIndexMetaData() {
        return this.indexMetaData;
    }

    public final ForeignKeyMetaData[] getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final UniqueMetaData[] getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final List getUnmappedColumns() {
        return this.unmappedColumns;
    }

    public int getNoOfProperties() {
        return this.properties.size();
    }

    public String getName() {
        return this.name;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getObjectidClass() {
        return this.objectidClass;
    }

    public String getCatalog() {
        if (this.catalog == null) {
            return ((PackageMetaData)this.parent).getCatalog();
        }
        return this.catalog;
    }

    public String getSchema() {
        if (this.schema == null) {
            return ((PackageMetaData)this.parent).getSchema();
        }
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isRequiresExtent() {
        return this.requiresExtent;
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public boolean isEmbeddedOnly() {
        return this.embeddedOnly;
    }

    public void setEmbeddedOnly() {
        this.embeddedOnly = true;
    }

    public final IdentityMetaData getIdentityMetaData() {
        return this.identityMetaData;
    }

    public final InheritanceMetaData getInheritanceMetaData() {
        return this.inheritanceMetaData;
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public MetaDataManager getMetaDataManager() {
        if (this.parent != null && this.parent.getParent() != null) {
            return this.getPackageMetaData().getFileMetaData().getMetaDataManager();
        }
        return null;
    }

    public PackageMetaData getPackageMetaData() {
        if (this.parent != null) {
            return (PackageMetaData)this.parent;
        }
        return null;
    }

    public String getPackageName() {
        return this.getPackageMetaData().getName();
    }

    public int getNoOfFields() {
        return this.properties.size();
    }

    public AbstractPropertyMetaData getField(int index) {
        if (index < 0 || index >= this.properties.size()) {
            return null;
        }
        return (AbstractPropertyMetaData)this.properties.get(index);
    }

    public ClassPersistenceModifier getPersistenceModifier() {
        return this.persistenceModifier;
    }

    public String getPersistenceCapableSuperclass() {
        return this.persistenceCapableSuperclass;
    }

    public boolean isSameOrAncestorOf(AbstractClassMetaData cmd) {
        this.checkInitialised();
        if (cmd == null) {
            return false;
        }
        if (this.fullName.equals(cmd.fullName)) {
            return true;
        }
        for (AbstractClassMetaData parent = cmd.getSuperAbstractClassMetaData(); parent != null; parent = parent.getSuperAbstractClassMetaData()) {
            if (!this.fullName.equals(parent.fullName)) continue;
            return true;
        }
        return false;
    }

    public FetchGroupMetaData getFetchGroupMetaData(String groupname) {
        FetchGroupMetaData fgmd = (FetchGroupMetaData)this.fetchGroupMetaDataByName.get(groupname);
        if (fgmd == null && this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getFetchGroupMetaData(groupname);
        }
        return fgmd;
    }

    public String[] getPrimaryKeyFieldNames() {
        if (this.identityType != IdentityType.APPLICATION) {
            return null;
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData field = (AbstractPropertyMetaData)iter.next();
            if (field.primaryKey != Boolean.TRUE) continue;
            fieldNames.add(field.name);
        }
        if (fieldNames.size() > 0) {
            return fieldNames.toArray(new String[fieldNames.size()]);
        }
        fieldNames = null;
        return this.pcSuperclassMetaData.getPrimaryKeyFieldNames();
    }

    public boolean hasField(String fieldName) {
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData field = (AbstractPropertyMetaData)iter.next();
            if (!field.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public AbstractPropertyMetaData getField(String name) {
        if (name == null) {
            return null;
        }
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)iter.next();
            if (!fmd.getName().equals(name)) continue;
            return fmd;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getField(name);
        }
        return null;
    }

    public int getNoOfManagedFields() {
        if (this.managedFields == null) {
            return 0;
        }
        return this.managedFields.length;
    }

    public AbstractPropertyMetaData[] getManagedFields() {
        this.checkInitialised();
        return this.managedFields;
    }

    public AbstractPropertyMetaData getManagedField(int position) {
        this.checkInitialised();
        if (this.managedFields == null) {
            return null;
        }
        if (position < 0 || position >= this.managedFields.length) {
            return null;
        }
        return this.managedFields[position];
    }

    public int getNoOfOverriddenFields() {
        if (this.overriddenFields == null) {
            return 0;
        }
        return this.overriddenFields.length;
    }

    public AbstractPropertyMetaData[] getOverriddenFields() {
        this.checkInitialised();
        return this.overriddenFields;
    }

    public AbstractPropertyMetaData getOverriddenField(int position) {
        this.checkInitialised();
        if (this.overriddenFields == null) {
            return null;
        }
        if (position < 0 || position >= this.overriddenFields.length) {
            return null;
        }
        return this.overriddenFields[position];
    }

    public AbstractPropertyMetaData getOverriddenField(String name) {
        this.checkInitialised();
        if (this.overriddenFields == null) {
            return null;
        }
        for (int i = 0; i < this.overriddenFields.length; ++i) {
            if (!this.overriddenFields[i].getName().equals(name)) continue;
            return this.overriddenFields[i];
        }
        return null;
    }

    protected AbstractPropertyMetaData getFieldBeingOverridden(String name) {
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData apmd = (AbstractPropertyMetaData)iter.next();
            if (!apmd.name.equals(name) || !apmd.fieldBelongsToClass()) continue;
            return apmd;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.getFieldBeingOverridden(name);
        }
        return null;
    }

    public int getNoOfInheritedManagedFields() {
        this.checkInitialised();
        return this.noOfInheritedManagedFields;
    }

    public AbstractPropertyMetaData getManagedFieldAbsolute(int abs_position) {
        this.checkInitialised();
        return this.getManagedFieldAbsoluteInternal(abs_position);
    }

    protected AbstractPropertyMetaData getManagedFieldAbsoluteInternal(int abs_position) {
        if (abs_position < this.noOfInheritedManagedFields) {
            if (this.pcSuperclassMetaData == null) {
                return null;
            }
            AbstractPropertyMetaData fmd = this.pcSuperclassMetaData.getManagedFieldAbsoluteInternal(abs_position);
            if (fmd != null) {
                for (int i = 0; i < this.overriddenFields.length; ++i) {
                    if (!this.overriddenFields[i].getName().equals(fmd.getName()) || !this.overriddenFields[i].getClassName().equals(fmd.getClassName())) continue;
                    return this.overriddenFields[i];
                }
                return fmd;
            }
            return null;
        }
        if (abs_position - this.noOfInheritedManagedFields >= this.managedFields.length) {
            return null;
        }
        return this.managedFields[abs_position - this.noOfInheritedManagedFields];
    }

    public int getAbsoluteFieldNumberForRelativeFieldNumber(int relativeFieldNo) {
        return this.noOfInheritedManagedFields + relativeFieldNo;
    }

    public int getFieldNumber(String field_name) {
        this.checkInitialised();
        if (field_name == null) {
            return -1;
        }
        Integer i = (Integer)this.fieldNumbersByName.get(field_name);
        return i == null ? -1 : i;
    }

    public int getFieldNumberAbsolute(String field_name) {
        this.checkInitialised();
        if (field_name == null) {
            return -1;
        }
        int i = this.getFieldNumber(field_name);
        if (i < 0) {
            if (this.pcSuperclassMetaData != null) {
                i = this.pcSuperclassMetaData.getFieldNumberAbsolute(field_name);
            }
        } else {
            i += this.noOfInheritedManagedFields;
        }
        return i;
    }

    public int getFieldNumberAbsolute(String class_name, String field_name) {
        this.checkInitialised();
        if (field_name == null) {
            return -1;
        }
        int i = -1;
        if (class_name.equals(this.getFullClassName())) {
            i = this.getFieldNumber(field_name);
        }
        if (i < 0) {
            if (this.pcSuperclassMetaData != null) {
                i = this.pcSuperclassMetaData.getFieldNumberAbsolute(class_name, field_name);
            }
        } else {
            i += this.noOfInheritedManagedFields;
        }
        return i;
    }

    private int getNoOfPopulatedPKFields() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getNoOfPopulatedPKFields();
        }
        Iterator fields_iter = this.properties.iterator();
        int noOfPks = 0;
        while (fields_iter.hasNext()) {
            AbstractPropertyMetaData fmd = (AbstractPropertyMetaData)fields_iter.next();
            if (!fmd.isPrimaryKey()) continue;
            ++noOfPks;
        }
        return noOfPks;
    }

    public int getNoOfPrimaryKeyFields() {
        if (this.primaryKeyFieldNumbers == null) {
            return 0;
        }
        return this.primaryKeyFieldNumbers.length;
    }

    public int[] getAllFieldNumbers() {
        this.checkInitialised();
        return this.allFieldNumbers;
    }

    public int[] getPrimaryKeyFieldNumbers() {
        this.checkInitialised();
        return this.primaryKeyFieldNumbers;
    }

    public int[] getNonPrimaryKeyFieldNumbers() {
        this.checkInitialised();
        return this.nonPrimaryKeyFieldNumbers;
    }

    public boolean[] getNonPrimaryKeyFieldFlags() {
        this.checkInitialised();
        return this.nonPrimaryKeyFieldFlags;
    }

    public int[] getDefaultFetchGroupFieldNumbers() {
        this.checkInitialised();
        return this.defaultFetchGroupFieldNumbers;
    }

    public boolean[] getDefaultFetchGroupFieldFlags() {
        this.checkInitialised();
        return this.defaultFetchGroupFieldFlags;
    }

    public int[] getSecondClassMutableFieldNumbers() {
        this.checkInitialised();
        return this.secondClassMutableFieldNumbers;
    }

    public int[] getSecondClassNonContainerFieldNumbers() {
        this.checkInitialised();
        if (this.secondClassNonContainerFieldNumbers == null) {
            int numberNonContainerSCOFields = 0;
            for (int i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                AbstractPropertyMetaData fmd;
                if ((class$java$util$Collection == null ? AbstractClassMetaData.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((fmd = this.getManagedFieldAbsolute(this.secondClassMutableFieldNumbers[i])).getType()) || (class$java$util$Map == null ? AbstractClassMetaData.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(fmd.getType())) continue;
                ++numberNonContainerSCOFields;
            }
            int[] noncontainerFieldNumbers = new int[numberNonContainerSCOFields];
            int nonContNum = 0;
            for (int i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                AbstractPropertyMetaData fmd;
                if ((class$java$util$Collection == null ? AbstractClassMetaData.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((fmd = this.getManagedFieldAbsolute(this.secondClassMutableFieldNumbers[i])).getType()) || (class$java$util$Map == null ? AbstractClassMetaData.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(fmd.getType())) continue;
                noncontainerFieldNumbers[nonContNum++] = this.secondClassMutableFieldNumbers[i];
            }
            this.secondClassNonContainerFieldNumbers = noncontainerFieldNumbers;
        }
        return this.secondClassNonContainerFieldNumbers;
    }

    public int[] getSecondClassContainerFieldNumbers() {
        this.checkInitialised();
        if (this.secondClassContainerFieldNumbers == null) {
            int numberContainerSCOFields = 0;
            for (int i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                AbstractPropertyMetaData fmd;
                if (!(class$java$util$Collection == null ? AbstractClassMetaData.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((fmd = this.getManagedFieldAbsolute(this.secondClassMutableFieldNumbers[i])).getType()) && !(class$java$util$Map == null ? AbstractClassMetaData.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(fmd.getType())) continue;
                ++numberContainerSCOFields;
            }
            int[] containerFieldNumbers = new int[numberContainerSCOFields];
            int contNum = 0;
            for (int i = 0; i < this.secondClassMutableFieldNumbers.length; ++i) {
                AbstractPropertyMetaData fmd;
                if (!(class$java$util$Collection == null ? AbstractClassMetaData.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((fmd = this.getManagedFieldAbsolute(this.secondClassMutableFieldNumbers[i])).getType()) && !(class$java$util$Map == null ? AbstractClassMetaData.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(fmd.getType())) continue;
                containerFieldNumbers[contNum++] = this.secondClassMutableFieldNumbers[i];
            }
            this.secondClassContainerFieldNumbers = containerFieldNumbers;
        }
        return this.secondClassContainerFieldNumbers;
    }

    public int[] getPersistenceCapableFieldNumbers() {
        this.checkInitialised();
        return this.persistenceCapableFieldNumbers;
    }

    public boolean[] getSecondClassMutableFieldFlags() {
        this.checkInitialised();
        return this.secondClassMutableFieldFlags;
    }

    public boolean usesSingleFieldIdentityClass() {
        return this.usesSingleFieldIdentityClass;
    }

    public boolean isMetaDataComplete() {
        return this.metaDataComplete;
    }

    public void setMetaDataComplete() {
        this.metaDataComplete = true;
    }

    public void addQuery(QueryMetaData qmd) {
        if (qmd == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new HashSet();
        }
        this.queries.add(qmd);
        qmd.parent = this;
    }

    public void addQueryResultMetaData(QueryResultMetaData resultMetaData) {
        if (this.queryResultMetaData == null) {
            this.queryResultMetaData = new HashSet();
        }
        if (!this.queryResultMetaData.contains(resultMetaData)) {
            this.queryResultMetaData.add(resultMetaData);
        }
    }

    public void addIndex(IndexMetaData idxmd) {
        if (idxmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new JPOXUserException("Already initialised");
        }
        this.indexes.add(idxmd);
    }

    public void addForeignKey(ForeignKeyMetaData fkmd) {
        if (fkmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new JPOXUserException("Already initialised");
        }
        this.foreignKeys.add(fkmd);
    }

    public void addUniqueConstraint(UniqueMetaData unimd) {
        if (unimd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new JPOXUserException("Already initialised");
        }
        this.uniqueConstraints.add(unimd);
    }

    public final void addUnmappedColumn(ColumnMetaData colmd) {
        if (this.unmappedColumns == null) {
            this.unmappedColumns = new ArrayList();
        }
        this.unmappedColumns.add(colmd);
    }

    public void addProperty(AbstractPropertyMetaData pmd) {
        if (pmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new JPOXUserException("adding property (field) " + pmd.getName() + " when already initialised!");
        }
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData md = (AbstractPropertyMetaData)iter.next();
            if (!pmd.getName().equals(md.getName())) continue;
            throw new JPOXUserException(LOCALISER.msg("MetaData.Class.DuplicateFieldError", this.fullName, pmd.getName()));
        }
        pmd.parent = this;
        this.properties.add(pmd);
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        if (fgmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new JPOXUserException("Already initialised");
        }
        this.fetchGroups.add(fgmd);
        fgmd.parent = this;
    }

    public void addJoin(JoinMetaData jnmd) {
        if (jnmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new JPOXUserException("Already initialised");
        }
        this.joins.add(jnmd);
    }

    public void addListener(EventListenerMetaData listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public EventListenerMetaData getListenerForClass(String className) {
        if (this.listeners == null) {
            return null;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListenerMetaData elmd = (EventListenerMetaData)this.listeners.get(i);
            if (!elmd.getClassName().equals(className)) continue;
            return elmd;
        }
        return null;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void excludeSuperClassListeners() {
        this.excludeSuperClassListeners = true;
    }

    public boolean isExcludeSuperClassListeners() {
        return this.excludeSuperClassListeners;
    }

    public void excludeDefaultListeners() {
        this.excludeDefaultListeners = true;
    }

    public boolean isExcludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    public final void setVersionMetaData(VersionMetaData versionMetaData) {
        this.versionMetaData = versionMetaData;
        if (this.versionMetaData != null) {
            this.versionMetaData.parent = this;
        }
    }

    public final void setIdentityMetaData(IdentityMetaData identityMetaData) {
        this.identityMetaData = identityMetaData;
        if (this.identityMetaData != null) {
            this.identityMetaData.parent = this;
        }
        this.identitySpecified = true;
    }

    public final void setInheritanceMetaData(InheritanceMetaData inheritanceMetaData) {
        this.inheritanceMetaData = inheritanceMetaData;
        if (this.inheritanceMetaData != null) {
            this.inheritanceMetaData.parent = this;
        }
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.parent = this;
        }
    }

    public final void setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? this.table : table;
    }

    public final void setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? this.catalog : catalog;
    }

    public final void setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? this.schema : schema;
    }

    public final void setObjectIdClass(String objectidClass) {
        this.objectidClass = StringUtils.isWhitespace(objectidClass) ? this.objectidClass : objectidClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

