/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.EmbeddedMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.IndexedValue;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.util.StringUtils;

public abstract class AbstractElementMetaData
extends ExtendableMetaData
implements ColumnMetaDataContainer {
    protected final List columns = new ArrayList();
    protected IndexMetaData indexMetaData;
    protected IndexedValue indexed = null;
    protected UniqueMetaData uniqueMetaData;
    protected final boolean uniqueConstraint;
    protected ForeignKeyMetaData foreignKeyMetaData;
    protected EmbeddedMetaData embeddedMetaData;
    protected String column;
    protected String mappedBy;
    protected ColumnMetaData[] columnMetaData;

    public AbstractElementMetaData(MetaData parent, AbstractElementMetaData aemd) {
        super(parent);
        this.column = aemd.column;
        this.uniqueConstraint = aemd.uniqueConstraint;
        this.indexed = aemd.indexed;
        this.mappedBy = aemd.mappedBy;
        this.indexMetaData = aemd.indexMetaData;
        this.uniqueMetaData = aemd.uniqueMetaData;
        this.foreignKeyMetaData = aemd.foreignKeyMetaData;
        this.embeddedMetaData = aemd.embeddedMetaData;
        for (int i = 0; i < this.columns.size(); ++i) {
            this.addColumn(new ColumnMetaData((ExtendableMetaData)this, (ColumnMetaData)aemd.columns.get(i)));
        }
    }

    public AbstractElementMetaData(MetaData parent, String column, String deleteAction, String updateAction, String indexed, String unique, String mappedBy) {
        super(parent);
        String string = this.column = StringUtils.isWhitespace(column) ? null : column;
        if (deleteAction != null || updateAction != null) {
            this.foreignKeyMetaData = new ForeignKeyMetaData(null, null, null, null, deleteAction, updateAction);
        }
        this.indexed = IndexedValue.getIndexedValue(indexed);
        this.uniqueConstraint = unique != null && unique.equalsIgnoreCase("true");
        this.mappedBy = StringUtils.isWhitespace(mappedBy) ? null : mappedBy;
    }

    public void populate(ClassLoaderResolver clr) {
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.populate(clr);
        }
    }

    public void initialise() {
        int i;
        if (this.columns.size() == 0 && this.column != null) {
            this.columnMetaData = new ColumnMetaData[1];
            this.columnMetaData[0] = new ColumnMetaData((ExtendableMetaData)this, this.column);
            this.columnMetaData[0].initialise();
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        if (this.indexMetaData == null && this.columnMetaData != null && this.indexed != null && this.indexed != IndexedValue.FALSE) {
            this.indexMetaData = new IndexMetaData(null, null, this.indexed == IndexedValue.UNIQUE ? "true" : "false");
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.indexMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.indexMetaData != null) {
            this.indexMetaData.initialise();
        }
        if (this.uniqueMetaData == null && this.uniqueConstraint) {
            this.uniqueMetaData = new UniqueMetaData(null, this.column, null);
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.uniqueMetaData.addColumn(this.columnMetaData[i]);
            }
        }
        if (this.uniqueMetaData != null) {
            this.uniqueMetaData.initialise();
        }
        if (this.foreignKeyMetaData != null) {
            this.foreignKeyMetaData.initialise();
        }
        if (this.embeddedMetaData != null) {
            this.embeddedMetaData.initialise();
        }
        this.setInitialised();
    }

    public final String getColumn() {
        return this.column;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public final EmbeddedMetaData getEmbeddedMetaData() {
        return this.embeddedMetaData;
    }

    public final ForeignKeyMetaData getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public final UniqueMetaData getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public final void setEmbeddedMetaData(EmbeddedMetaData embeddedMetaData) {
        this.embeddedMetaData = embeddedMetaData;
    }

    public final void setForeignKeyMetaData(ForeignKeyMetaData foreignKeyMetaData) {
        this.foreignKeyMetaData = foreignKeyMetaData;
    }

    public final void setIndexMetaData(IndexMetaData indexMetaData) {
        this.indexMetaData = indexMetaData;
    }

    public final void setUniqueMetaData(UniqueMetaData uniqueMetaData) {
        this.uniqueMetaData = uniqueMetaData;
    }
}

