/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ElementMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.KeyMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.ValueMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;

public class EmbeddedMetaData
extends ExtendableMetaData {
    protected final List fields = new ArrayList();
    protected final String ownerField;
    protected final String nullIndicatorColumn;
    protected final String nullIndicatorValue;
    protected AbstractPropertyMetaData[] fieldMetaData;

    public EmbeddedMetaData(MetaData parent, EmbeddedMetaData embmd) {
        super(parent);
        this.ownerField = embmd.ownerField;
        this.nullIndicatorColumn = embmd.nullIndicatorColumn;
        this.nullIndicatorValue = embmd.nullIndicatorValue;
        for (int i = 0; i < embmd.fields.size(); ++i) {
            if (embmd.fields.get(i) instanceof FieldMetaData) {
                this.addField(new FieldMetaData((MetaData)this, (AbstractPropertyMetaData)embmd.fields.get(i)));
                continue;
            }
            this.addField(new PropertyMetaData((MetaData)this, (PropertyMetaData)embmd.fields.get(i)));
        }
    }

    public EmbeddedMetaData(ExtendableMetaData parent, String ownerField, String nullColumn, String nullValue) {
        super(parent);
        this.ownerField = ownerField;
        this.nullIndicatorColumn = nullColumn;
        this.nullIndicatorValue = nullValue;
    }

    public void populate(ClassLoaderResolver clr) {
        int i;
        Class cls;
        MetaData md = this.getParent();
        AbstractPropertyMetaData apmd = null;
        AbstractClassMetaData embCmd = null;
        String embeddedType = null;
        if (md instanceof AbstractPropertyMetaData) {
            apmd = (AbstractPropertyMetaData)md;
            embeddedType = apmd.getTypeName();
            embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(apmd.getType(), clr);
            if (embCmd == null) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Embedded.PC.UnsupportedType", apmd.getFullFieldName(), apmd.getTypeName()));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Embedded.PC.UnsupportedType", (Object)apmd.getFullFieldName(), apmd.getTypeName());
            }
        } else if (md instanceof ElementMetaData) {
            ElementMetaData elemmd = (ElementMetaData)md;
            apmd = (AbstractPropertyMetaData)elemmd.getParent();
            embeddedType = apmd.getCollection().getElementType();
            try {
                cls = clr.classForName(embeddedType);
                embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Embedded.Collection.UnsupportedType", apmd.getFullFieldName(), apmd.getCollection().getElementType()));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Embedded.Collection.UnsupportedType", (Object)apmd.getFullFieldName(), apmd.getTypeName());
            }
        } else if (md instanceof KeyMetaData) {
            KeyMetaData keymd = (KeyMetaData)md;
            apmd = (AbstractPropertyMetaData)keymd.getParent();
            embeddedType = apmd.getMap().getKeyType();
            try {
                cls = clr.classForName(embeddedType);
                embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Embedded.MapKey.UnsupportedType", apmd.getFullFieldName(), apmd.getMap().getKeyType()));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Embedded.MapKey.UnsupportedType", (Object)apmd.getFullFieldName(), embeddedType);
            }
        } else if (md instanceof ValueMetaData) {
            ValueMetaData valuemd = (ValueMetaData)md;
            apmd = (AbstractPropertyMetaData)valuemd.getParent();
            embeddedType = apmd.getMap().getValueType();
            try {
                cls = clr.classForName(embeddedType);
                embCmd = apmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClassInternal(cls, clr);
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (embCmd == null) {
                JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Embedded.MapValue.UnsupportedType", apmd.getFullFieldName(), apmd.getMap().getValueType()));
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Embedded.MapValue.UnsupportedType", (Object)apmd.getFullFieldName(), embeddedType);
            }
        }
        Class embeddedClass = null;
        Collections.sort(this.fields);
        try {
            embeddedClass = clr.classForName(embeddedType);
            Field[] cls_fields = embeddedClass.getDeclaredFields();
            for (i = 0; i < cls_fields.length; ++i) {
                if (!cls_fields[i].getDeclaringClass().getName().equals(embeddedType) || cls_fields[i].getName().startsWith("jdo") || ClassUtils.isInnerClass(cls_fields[i].getName()) || Modifier.isStatic(cls_fields[i].getModifiers()) || Collections.binarySearch(this.fields, cls_fields[i].getName()) >= 0) continue;
                JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Embedded.AddingUnspecifiedField", cls_fields[i].getName(), embeddedType, apmd.getClassName(true)));
                FieldMetaData omittedFmd = new FieldMetaData((MetaData)this, cls_fields[i].getName());
                this.fields.add(omittedFmd);
                Collections.sort(this.fields);
            }
        }
        catch (Exception e) {
            JPOXLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        if (embCmd instanceof InterfaceMetaData) {
            try {
                Method[] clsMethods = embeddedClass.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String fieldName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(embeddedType) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Collections.binarySearch(this.fields, fieldName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                    JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.AddingUnspecifiedField", fieldName, apmd.getClassName(true)));
                    PropertyMetaData fmd = new PropertyMetaData((MetaData)this, fieldName);
                    this.fields.add(fmd);
                    Collections.sort(this.fields);
                }
            }
            catch (Exception e) {
                JPOXLogger.METADATA.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
        Collections.sort(this.fields);
        Iterator fieldsIter = this.fields.iterator();
        while (fieldsIter.hasNext()) {
            AbstractPropertyMetaData fieldFmd = (AbstractPropertyMetaData)fieldsIter.next();
            if (fieldFmd instanceof FieldMetaData) {
                Field cls_field = null;
                try {
                    cls_field = embeddedClass.getDeclaredField(fieldFmd.getName());
                }
                catch (Exception e) {
                    throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredFieldNotFoundError", (Object)embeddedClass.getName(), fieldFmd.getFullFieldName());
                }
                fieldFmd.populate(clr, cls_field, null);
                continue;
            }
            Method cls_method = null;
            try {
                try {
                    cls_method = embeddedClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fieldFmd.getName(), true), null);
                }
                catch (Exception e) {
                    cls_method = embeddedClass.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fieldFmd.getName(), false), null);
                }
            }
            catch (Exception e) {
                throw new InvalidMetaDataException(LOCALISER, "MetaData.Class.DeclaredFieldNotFoundError", (Object)embeddedClass.getName(), fieldFmd.getFullFieldName());
            }
            fieldFmd.populate(clr, null, cls_method);
        }
    }

    public void initialise() {
        this.fieldMetaData = new AbstractPropertyMetaData[this.fields.size()];
        for (int i = 0; i < this.fieldMetaData.length; ++i) {
            this.fieldMetaData[i] = (AbstractPropertyMetaData)this.fields.get(i);
            this.fieldMetaData[i].initialise();
        }
        this.setInitialised();
    }

    public final AbstractPropertyMetaData[] getFieldMetaData() {
        return this.fieldMetaData;
    }

    public final String getOwnerField() {
        return this.ownerField;
    }

    public final String getNullIndicatorColumn() {
        return this.nullIndicatorColumn;
    }

    public final String getNullIndicatorValue() {
        return this.nullIndicatorValue;
    }

    public void addField(AbstractPropertyMetaData fmd) {
        if (fmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new RuntimeException(LOCALISER.msg("MetaData.Field.AlreadyInitialisedError", fmd.getName(), fmd.getAbstractClassMetaData().getFullClassName()));
        }
        Iterator iter = this.fields.iterator();
        while (iter.hasNext()) {
            AbstractPropertyMetaData md = (AbstractPropertyMetaData)iter.next();
            if (!fmd.getName().equals(md.getName())) continue;
            throw new RuntimeException(LOCALISER.msg("MetaData.Field.DuplicateField", fmd.getName(), fmd.getAbstractClassMetaData().getFullClassName()));
        }
        this.fields.add(fmd);
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<embedded");
        if (this.ownerField != null) {
            sb.append(" owner-field=\"" + this.ownerField + "\"");
        }
        if (this.nullIndicatorColumn != null) {
            sb.append(" null-indicator-column=\"" + this.nullIndicatorColumn + "\"");
        }
        if (this.nullIndicatorValue != null) {
            sb.append(" null-indicator-value=\"" + this.nullIndicatorValue + "\"");
        }
        sb.append(">\n");
        for (int i = 0; i < this.fields.size(); ++i) {
            AbstractPropertyMetaData f = (AbstractPropertyMetaData)this.fields.get(i);
            sb.append(f.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</embedded>\n");
        return sb.toString();
    }
}

