/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.AbstractConstraintMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PropertyMetaData;

public class IndexMetaData
extends AbstractConstraintMetaData
implements ColumnMetaDataContainer {
    Boolean unique;

    public IndexMetaData(IndexMetaData imd) {
        super(null, imd.name, imd.table);
        this.unique = imd.unique;
        AbstractPropertyMetaData[] apmd = null;
        apmd = imd.fields != null ? imd.fields.toArray(new AbstractPropertyMetaData[imd.fields.size()]) : imd.fieldMetaData;
        if (apmd != null) {
            for (int i = 0; i < apmd.length; ++i) {
                if (apmd[i] instanceof FieldMetaData) {
                    this.addField(new FieldMetaData((MetaData)this, apmd[i]));
                    continue;
                }
                this.addField(new PropertyMetaData((MetaData)this, (PropertyMetaData)apmd[i]));
            }
        }
        ColumnMetaData[] colmd = null;
        colmd = imd.columns != null ? imd.columns.toArray(new ColumnMetaData[imd.columns.size()]) : imd.columnMetaData;
        if (colmd != null) {
            for (int i = 0; i < colmd.length; ++i) {
                this.addColumn(new ColumnMetaData((ExtendableMetaData)this, colmd[i]));
            }
        }
    }

    public IndexMetaData(String name, String table, String unique) {
        super(null, name, table);
        if (unique != null) {
            if (unique.equalsIgnoreCase("true")) {
                this.unique = Boolean.TRUE;
            } else if (unique.equalsIgnoreCase("false")) {
                this.unique = Boolean.FALSE;
            }
        }
    }

    public void initialise() {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.fields.size() == 0) {
            this.fieldMetaData = null;
        } else {
            this.fieldMetaData = new AbstractPropertyMetaData[this.fields.size()];
            for (i = 0; i < this.fieldMetaData.length; ++i) {
                this.fieldMetaData[i] = (AbstractPropertyMetaData)this.fields.get(i);
                this.fieldMetaData[i].initialise();
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.fields.clear();
        this.fields = null;
        this.columns.clear();
        this.columns = null;
        this.setInitialised();
    }

    public final Boolean isUnique() {
        return this.unique;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<index unique=\"" + this.unique + "\"");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        sb.append(this.name != null ? " name=\"" + this.name + "\">\n" : ">\n");
        if (this.fieldMetaData != null) {
            for (i = 0; i < this.fieldMetaData.length; ++i) {
                sb.append(this.fieldMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.columnMetaData != null) {
            for (i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</index>\n");
        return sb.toString();
    }
}

