/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.JoinMetaData;

public class InheritanceMetaData
extends ExtendableMetaData {
    protected InheritanceStrategy strategy = null;
    protected JoinMetaData joinMetaData;
    protected DiscriminatorMetaData discriminatorMetaData;

    public InheritanceMetaData(AbstractClassMetaData parent, String strategy) {
        super(parent);
        this.strategy = InheritanceStrategy.getInheritanceStrategy(strategy);
    }

    public void initialise() {
        if (this.joinMetaData != null) {
            this.joinMetaData.initialise();
        }
        if (this.discriminatorMetaData != null) {
            this.discriminatorMetaData.initialise();
        }
        this.setInitialised();
    }

    public InheritanceStrategy getStrategyValue() {
        return this.strategy;
    }

    public JoinMetaData getJoinMetaData() {
        return this.joinMetaData;
    }

    public void setJoinMetaData(JoinMetaData joinMetaData) {
        this.joinMetaData = joinMetaData;
        if (this.joinMetaData != null) {
            this.joinMetaData.parent = this;
        }
    }

    public DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.discriminatorMetaData;
    }

    public void setDiscriminatorMetaData(DiscriminatorMetaData discriminatorMetaData) {
        this.discriminatorMetaData = discriminatorMetaData;
        this.discriminatorMetaData.parent = this;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<inheritance strategy=\"" + this.strategy + "\">\n");
        if (this.joinMetaData != null) {
            sb.append(this.joinMetaData.toString(prefix + indent, indent));
        }
        if (this.discriminatorMetaData != null) {
            sb.append(this.discriminatorMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</inheritance>\n");
        return sb.toString();
    }
}

