/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.EventListenerMetaData;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.FetchGroupMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.QueryMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class MetaDataMerger {
    protected static Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");

    public static void mergeFileORMData(FileMetaData primaryFmd, FileMetaData ormFmd) {
        if (ormFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new JPOXException(LOCALISER.msg("MetaData.File.AlreadyPopulatedError", primaryFmd.getFilename())).setFatal();
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.File.MergingORM", primaryFmd.getFilename()));
        }
        if (ormFmd.getCatalog() != null) {
            primaryFmd.setCatalog(ormFmd.getCatalog());
        }
        if (ormFmd.getSchema() != null) {
            primaryFmd.setSchema(ormFmd.getSchema());
        }
    }

    public static void mergeClassORMData(AbstractClassMetaData primaryCmd, AbstractClassMetaData ormCmd) {
        Iterator iter;
        if (ormCmd == null || primaryCmd == null) {
            return;
        }
        if (primaryCmd.isInitialised() || primaryCmd.isPopulated()) {
            throw new JPOXException(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", primaryCmd.name)).setFatal();
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.MergingORM", primaryCmd.getFullClassName()));
        }
        if (ormCmd.getCatalog() != null) {
            primaryCmd.catalog = ormCmd.getCatalog();
        }
        if (ormCmd.getSchema() != null) {
            primaryCmd.schema = ormCmd.getSchema();
        }
        if (ormCmd.getTable() != null) {
            primaryCmd.table = ormCmd.getTable();
        }
        if (ormCmd.getPrimaryKeyMetaData() != null) {
            primaryCmd.setPrimaryKeyMetaData(ormCmd.getPrimaryKeyMetaData());
        }
        if (ormCmd.getInheritanceMetaData() != null) {
            primaryCmd.setInheritanceMetaData(ormCmd.getInheritanceMetaData());
        }
        if (ormCmd.getIdentityMetaData() != null) {
            primaryCmd.setIdentityMetaData(ormCmd.getIdentityMetaData());
        }
        if (ormCmd.getVersionMetaData() != null) {
            primaryCmd.setVersionMetaData(ormCmd.getVersionMetaData());
        }
        if (ormCmd.listeners != null) {
            if (primaryCmd.listeners == null) {
                primaryCmd.listeners = new ArrayList();
            }
            primaryCmd.listeners.addAll(ormCmd.listeners);
        }
        if (ormCmd.queries != null) {
            if (primaryCmd.queries == null) {
                primaryCmd.queries = new ArrayList();
            } else {
                primaryCmd.queries.clear();
            }
            primaryCmd.queries.addAll(ormCmd.queries);
        }
        if (ormCmd.joins.size() > 0) {
            primaryCmd.joins.clear();
            iter = ormCmd.joins.iterator();
            while (iter.hasNext()) {
                primaryCmd.addJoin((JoinMetaData)iter.next());
            }
        }
        if (ormCmd.indexes.size() > 0) {
            primaryCmd.indexes.clear();
            iter = ormCmd.indexes.iterator();
            while (iter.hasNext()) {
                primaryCmd.addIndex((IndexMetaData)iter.next());
            }
        }
        if (ormCmd.foreignKeys.size() > 0) {
            primaryCmd.foreignKeys.clear();
            iter = ormCmd.foreignKeys.iterator();
            while (iter.hasNext()) {
                primaryCmd.addForeignKey((ForeignKeyMetaData)iter.next());
            }
        }
        if (ormCmd.uniqueConstraints.size() > 0) {
            primaryCmd.uniqueConstraints.clear();
            iter = ormCmd.uniqueConstraints.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUniqueConstraint((UniqueMetaData)iter.next());
            }
        }
        if (ormCmd.fetchGroups.size() > 0) {
            primaryCmd.fetchGroups.clear();
            iter = ormCmd.fetchGroups.iterator();
            while (iter.hasNext()) {
                primaryCmd.addFetchGroup((FetchGroupMetaData)iter.next());
            }
        }
        for (int i = 0; i < ormCmd.getNoOfFields(); ++i) {
            AbstractPropertyMetaData ormFmd = ormCmd.getField(i);
            AbstractPropertyMetaData primaryFmd = primaryCmd.getField(ormFmd.getName());
            if (primaryFmd == null) {
                AbstractPropertyMetaData fmd = null;
                if (ormFmd.className != null) {
                    AbstractPropertyMetaData jdoFmd = primaryCmd.getMetaDataManager().readMetaDataForField(ormFmd.className, ormFmd.name);
                    if (jdoFmd == null) {
                        jdoFmd = primaryCmd.getMetaDataManager().readMetaDataForField(ormCmd.getPackageName() + "." + ormFmd.className, ormFmd.name);
                    }
                    if (jdoFmd != null) {
                        fmd = jdoFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, jdoFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)jdoFmd);
                        fmd.className = ormFmd.className;
                        MetaDataMerger.mergeFieldORMData(fmd, ormFmd);
                    } else {
                        fmd = ormFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, ormFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)ormFmd);
                        fmd.className = ormFmd.className;
                    }
                } else {
                    fmd = ormFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, ormFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)ormFmd);
                }
                primaryCmd.addProperty(fmd);
                continue;
            }
            MetaDataMerger.mergeFieldORMData(primaryFmd, ormFmd);
        }
        ExtensionMetaData[] ormExtensions = ormCmd.getExtensions();
        if (ormExtensions != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryCmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeFieldORMData(AbstractPropertyMetaData primaryFmd, AbstractPropertyMetaData ormFmd) {
        ExtensionMetaData[] ormExtensions;
        if (ormFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new JPOXException(LOCALISER.msg("MetaData.Field.AlreadyPopulatedError", primaryFmd.name, ormFmd.getAbstractClassMetaData().getFullClassName())).setFatal();
        }
        if (ormFmd.className != null) {
            primaryFmd.className = ormFmd.className;
        }
        if (ormFmd.container != null) {
            primaryFmd.container = ormFmd.container;
            primaryFmd.container.parent = primaryFmd;
        }
        if (primaryFmd.primaryKey == Boolean.FALSE && ormFmd.primaryKey == Boolean.TRUE) {
            primaryFmd.primaryKey = ClassUtils.booleanValueOf(ormFmd.isPrimaryKey());
        }
        if (ormFmd.getTable() != null) {
            primaryFmd.table = ormFmd.getTable();
        }
        if (ormFmd.getCatalog() != null) {
            primaryFmd.catalog = ormFmd.getCatalog();
        }
        if (ormFmd.getSchema() != null) {
            primaryFmd.schema = ormFmd.getSchema();
        }
        if (ormFmd.getColumn() != null) {
            primaryFmd.column = ormFmd.getColumn();
        }
        if (ormFmd.dependent != null) {
            primaryFmd.dependent = ormFmd.dependent;
        }
        if (ormFmd.getMappedBy() != null) {
            primaryFmd.mappedBy = ormFmd.getMappedBy();
        }
        if (ormFmd.getValueStrategy() != null) {
            primaryFmd.valueStrategy = ormFmd.getValueStrategy();
        }
        if (ormFmd.getSequence() != null) {
            primaryFmd.sequence = ormFmd.getSequence();
        }
        if (ormFmd.indexed != null) {
            primaryFmd.indexed = ormFmd.indexed;
        }
        if (ormFmd.getJoinMetaData() != null) {
            primaryFmd.setJoinMetaData(ormFmd.joinMetaData);
        }
        if (ormFmd.getEmbeddedMetaData() != null) {
            primaryFmd.setEmbeddedMetaData(ormFmd.embeddedMetaData);
        }
        if (ormFmd.getElementMetaData() != null) {
            primaryFmd.setElementMetaData(ormFmd.elementMetaData);
        }
        if (ormFmd.getKeyMetaData() != null) {
            primaryFmd.setKeyMetaData(ormFmd.keyMetaData);
        }
        if (ormFmd.getValueMetaData() != null) {
            primaryFmd.setValueMetaData(ormFmd.valueMetaData);
        }
        if (ormFmd.getOrderMetaData() != null) {
            primaryFmd.setOrderMetaData(ormFmd.orderMetaData);
        }
        if (ormFmd.getForeignKeyMetaData() != null) {
            primaryFmd.foreignKeyMetaData = ormFmd.getForeignKeyMetaData();
            if (primaryFmd.foreignKeyMetaData != null) {
                primaryFmd.foreignKeyMetaData.parent = primaryFmd;
            }
        }
        if (ormFmd.getIndexMetaData() != null) {
            primaryFmd.indexMetaData = ormFmd.getIndexMetaData();
            if (primaryFmd.indexMetaData != null) {
                primaryFmd.indexMetaData.parent = primaryFmd;
            }
        }
        if (ormFmd.getUniqueMetaData() != null) {
            primaryFmd.uniqueMetaData = ormFmd.getUniqueMetaData();
            if (primaryFmd.uniqueMetaData != null) {
                primaryFmd.uniqueMetaData.parent = primaryFmd;
            }
        }
        primaryFmd.columns.clear();
        ColumnMetaData[] ormColumns = ormFmd.getColumnMetaData();
        if (ormColumns != null) {
            for (int i = 0; i < ormColumns.length; ++i) {
                primaryFmd.columns.add(ormColumns[i]);
            }
        }
        if ((ormExtensions = ormFmd.getExtensions()) != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryFmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeClassAnnotationsData(AbstractClassMetaData primaryCmd, AbstractClassMetaData annotCmd) {
        Iterator iter;
        if (annotCmd == null || primaryCmd == null) {
            return;
        }
        if (primaryCmd.isInitialised() || primaryCmd.isPopulated()) {
            throw new JPOXException(LOCALISER.msg("MetaData.Class.AlreadyPopulatedError", primaryCmd.name)).setFatal();
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Class.MergingAnnotations", primaryCmd.getFullClassName()));
        }
        if (primaryCmd.entityName == null && annotCmd.entityName != null) {
            primaryCmd.entityName = annotCmd.entityName;
        }
        if (primaryCmd.identityType == null && annotCmd.identityType != null) {
            primaryCmd.identityType = annotCmd.identityType;
        }
        if (primaryCmd.objectidClass == null && annotCmd.objectidClass != null) {
            primaryCmd.objectidClass = annotCmd.objectidClass;
        }
        if (primaryCmd.catalog == null && annotCmd.catalog != null) {
            primaryCmd.catalog = annotCmd.catalog;
        }
        if (primaryCmd.schema == null && annotCmd.schema != null) {
            primaryCmd.schema = annotCmd.schema;
        }
        if (primaryCmd.table == null && annotCmd.table != null) {
            primaryCmd.table = annotCmd.table;
        }
        if (primaryCmd.versionMetaData == null && annotCmd.versionMetaData != null) {
            primaryCmd.setVersionMetaData(annotCmd.versionMetaData);
        }
        if (primaryCmd.identityMetaData == null && annotCmd.identityMetaData != null) {
            primaryCmd.setIdentityMetaData(annotCmd.identityMetaData);
        }
        if (primaryCmd.inheritanceMetaData == null && annotCmd.inheritanceMetaData != null) {
            primaryCmd.setInheritanceMetaData(annotCmd.inheritanceMetaData);
        }
        if (primaryCmd.primaryKeyMetaData == null && annotCmd.primaryKeyMetaData != null) {
            primaryCmd.setPrimaryKeyMetaData(annotCmd.primaryKeyMetaData);
        }
        if (primaryCmd.listeners == null && annotCmd.listeners != null) {
            iter = annotCmd.listeners.iterator();
            while (iter.hasNext()) {
                primaryCmd.addListener((EventListenerMetaData)iter.next());
            }
        } else if (primaryCmd.listeners != null && annotCmd.listeners != null) {
            if (primaryCmd.getListenerForClass(primaryCmd.getFullClassName()) == null) {
                if (annotCmd.getListenerForClass(primaryCmd.getFullClassName()) != null) {
                    primaryCmd.addListener(annotCmd.getListenerForClass(primaryCmd.getFullClassName()));
                }
            } else if (primaryCmd.getListenerForClass(primaryCmd.getFullClassName()) != null && primaryCmd.getListeners().size() == 1) {
                List annotListeners = annotCmd.getListeners();
                Iterator annotIter = annotListeners.iterator();
                while (annotIter.hasNext()) {
                    EventListenerMetaData elmd = (EventListenerMetaData)annotIter.next();
                    if (elmd.getClassName().equals(primaryCmd.getFullClassName())) continue;
                    primaryCmd.addListener(elmd);
                }
            }
        }
        if (primaryCmd.queries == null && annotCmd.queries != null) {
            iter = annotCmd.queries.iterator();
            while (iter.hasNext()) {
                primaryCmd.addQuery((QueryMetaData)iter.next());
            }
        }
        if (primaryCmd.joins.size() == 0 && annotCmd.joins.size() > 0) {
            iter = annotCmd.joins.iterator();
            while (iter.hasNext()) {
                primaryCmd.addJoin((JoinMetaData)iter.next());
            }
        }
        if (primaryCmd.indexes.size() == 0 && annotCmd.indexes.size() > 0) {
            iter = annotCmd.indexes.iterator();
            while (iter.hasNext()) {
                primaryCmd.addIndex((IndexMetaData)iter.next());
            }
        }
        if (primaryCmd.foreignKeys.size() == 0 && annotCmd.foreignKeys.size() > 0) {
            iter = annotCmd.foreignKeys.iterator();
            while (iter.hasNext()) {
                primaryCmd.addForeignKey((ForeignKeyMetaData)iter.next());
            }
        }
        if (primaryCmd.uniqueConstraints.size() == 0 && annotCmd.uniqueConstraints.size() > 0) {
            iter = annotCmd.uniqueConstraints.iterator();
            while (iter.hasNext()) {
                primaryCmd.addUniqueConstraint((UniqueMetaData)iter.next());
            }
        }
        if (primaryCmd.fetchGroups.size() == 0 && annotCmd.fetchGroups.size() > 0) {
            iter = annotCmd.fetchGroups.iterator();
            while (iter.hasNext()) {
                primaryCmd.addFetchGroup((FetchGroupMetaData)iter.next());
            }
        }
        for (int i = 0; i < annotCmd.getNoOfFields(); ++i) {
            AbstractPropertyMetaData annotFmd = annotCmd.getField(i);
            AbstractPropertyMetaData primaryFmd = primaryCmd.getField(annotFmd.getName());
            if (primaryFmd == null) {
                AbstractPropertyMetaData fmd = null;
                if (annotFmd.className != null) {
                    AbstractPropertyMetaData baseFmd = primaryCmd.getMetaDataManager().readMetaDataForField(annotFmd.className, annotFmd.name);
                    if (baseFmd == null) {
                        baseFmd = primaryCmd.getMetaDataManager().readMetaDataForField(annotCmd.getPackageName() + "." + annotFmd.className, annotFmd.name);
                    }
                    if (baseFmd != null) {
                        fmd = baseFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, baseFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)baseFmd);
                        fmd.className = annotFmd.className;
                        MetaDataMerger.mergeFieldAnnotationsData(fmd, annotFmd);
                    } else {
                        fmd = annotFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, annotFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)annotFmd);
                        fmd.className = annotFmd.className;
                    }
                } else {
                    fmd = annotFmd instanceof FieldMetaData ? primaryCmd.getMetaDataManager().getMetaDataFactory().newFieldObject(primaryCmd, annotFmd) : primaryCmd.getMetaDataManager().getMetaDataFactory().newPropertyObject(primaryCmd, (PropertyMetaData)annotFmd);
                }
                primaryCmd.addProperty(fmd);
                continue;
            }
            MetaDataMerger.mergeFieldAnnotationsData(primaryFmd, annotFmd);
        }
        ExtensionMetaData[] ormExtensions = annotCmd.getExtensions();
        if (ormExtensions != null) {
            for (int i = 0; i < ormExtensions.length; ++i) {
                primaryCmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }

    public static void mergeFieldAnnotationsData(AbstractPropertyMetaData primaryFmd, AbstractPropertyMetaData annotFmd) {
        ExtensionMetaData[] ormExtensions;
        int i;
        ColumnMetaData[] annotColumns;
        if (annotFmd == null || primaryFmd == null) {
            return;
        }
        if (primaryFmd.isInitialised() || primaryFmd.isPopulated()) {
            throw new JPOXException(LOCALISER.msg("MetaData.Field.AlreadyPopulatedError", primaryFmd.name, annotFmd.getAbstractClassMetaData().getFullClassName())).setFatal();
        }
        if (primaryFmd.className == null && annotFmd.className != null) {
            primaryFmd.className = annotFmd.className;
        }
        if (primaryFmd.container == null && annotFmd.container != null) {
            primaryFmd.container = annotFmd.container;
            primaryFmd.container.parent = primaryFmd;
        }
        if (primaryFmd.primaryKey == null && annotFmd.primaryKey != null) {
            primaryFmd.primaryKey = annotFmd.primaryKey;
        }
        if (primaryFmd.table == null && annotFmd.table != null) {
            primaryFmd.table = annotFmd.table;
        }
        if (primaryFmd.catalog == null && annotFmd.catalog != null) {
            primaryFmd.catalog = annotFmd.catalog;
        }
        if (primaryFmd.schema == null && annotFmd.schema != null) {
            primaryFmd.schema = annotFmd.schema;
        }
        if (primaryFmd.column == null && annotFmd.column != null) {
            primaryFmd.column = annotFmd.column;
        }
        if (primaryFmd.dependent == null && annotFmd.dependent != null) {
            primaryFmd.dependent = annotFmd.dependent;
        }
        if (primaryFmd.mappedBy == null && annotFmd.mappedBy != null) {
            primaryFmd.mappedBy = annotFmd.mappedBy;
        }
        if (primaryFmd.valueStrategy == null && annotFmd.valueStrategy != null) {
            primaryFmd.valueStrategy = annotFmd.valueStrategy;
        }
        if (primaryFmd.sequence == null && annotFmd.sequence != null) {
            primaryFmd.sequence = annotFmd.sequence;
        }
        if (primaryFmd.indexed == null && annotFmd.indexed != null) {
            primaryFmd.indexed = annotFmd.indexed;
        }
        if (primaryFmd.joinMetaData == null && annotFmd.joinMetaData != null) {
            primaryFmd.setJoinMetaData(annotFmd.joinMetaData);
        }
        if (primaryFmd.embeddedMetaData == null && annotFmd.embeddedMetaData != null) {
            primaryFmd.setEmbeddedMetaData(annotFmd.embeddedMetaData);
        }
        if (primaryFmd.elementMetaData == null && annotFmd.elementMetaData != null) {
            primaryFmd.setElementMetaData(annotFmd.elementMetaData);
        }
        if (primaryFmd.keyMetaData == null && annotFmd.keyMetaData != null) {
            primaryFmd.setKeyMetaData(annotFmd.keyMetaData);
        }
        if (primaryFmd.valueMetaData == null && annotFmd.valueMetaData != null) {
            primaryFmd.setValueMetaData(annotFmd.valueMetaData);
        }
        if (primaryFmd.orderMetaData == null && annotFmd.orderMetaData != null) {
            primaryFmd.setOrderMetaData(annotFmd.orderMetaData);
        }
        if (primaryFmd.foreignKeyMetaData == null && annotFmd.foreignKeyMetaData != null) {
            primaryFmd.foreignKeyMetaData = annotFmd.foreignKeyMetaData;
            if (primaryFmd.foreignKeyMetaData != null) {
                primaryFmd.foreignKeyMetaData.parent = primaryFmd;
            }
        }
        if (primaryFmd.indexMetaData == null && annotFmd.indexMetaData != null) {
            primaryFmd.indexMetaData = annotFmd.indexMetaData;
            if (primaryFmd.indexMetaData != null) {
                primaryFmd.indexMetaData.parent = primaryFmd;
            }
        }
        if (primaryFmd.uniqueMetaData == null && annotFmd.uniqueMetaData != null) {
            primaryFmd.uniqueMetaData = annotFmd.uniqueMetaData;
            if (primaryFmd.uniqueMetaData != null) {
                primaryFmd.uniqueMetaData.parent = primaryFmd;
            }
        }
        if (primaryFmd.columns.size() == 0 && annotFmd.columns.size() > 0 && (annotColumns = annotFmd.getColumnMetaData()) != null) {
            for (i = 0; i < annotColumns.length; ++i) {
                primaryFmd.columns.add(annotColumns[i]);
            }
        }
        if ((ormExtensions = annotFmd.getExtensions()) != null) {
            for (i = 0; i < ormExtensions.length; ++i) {
                primaryFmd.addExtension(ormExtensions[i].vendorName, ormExtensions[i].key, ormExtensions[i].value);
            }
        }
    }
}

