/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractMetaDataHandler;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.EntityResolverFactory;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParser
extends DefaultHandler {
    protected static Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    protected final MetaDataManager mgr;
    protected final boolean validate;
    SAXParser parser = null;
    static /* synthetic */ Class class$org$jpox$metadata$MetaDataManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$EntityResolver;

    public MetaDataParser(MetaDataManager mgr, boolean validate) {
        this.mgr = mgr;
        this.validate = validate;
    }

    public MetaData parseMetaDataURL(URL url, String handlerName) {
        if (url == null) {
            String msg = LOCALISER.msg("MetaData.Parser.NullFile");
            JPOXLogger.METADATA.error(msg);
            throw new JPOXException(msg);
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(url.getFile()));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Parser.CannotOpenFileError", url.toString()));
            throw new JPOXException(LOCALISER.msg("MetaData.Parser.CannotOpenFileError", url.toString()));
        }
        return this.parseMetaDataStream(in, url.toString(), handlerName);
    }

    public MetaData parseMetaDataFile(String fileName, String handlerName) {
        InputStream in = null;
        try {
            in = new URL(fileName).openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(fileName));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            JPOXLogger.ENHANCER.error(LOCALISER.msg("MetaData.Parser.CannotOpenFileError", fileName));
            throw new JPOXException(LOCALISER.msg("MetaData.Parser.CannotOpenFileError", fileName));
        }
        return this.parseMetaDataStream(in, fileName, handlerName);
    }

    public MetaData parseMetaDataStream(InputStream in, String filename, String handlerName) {
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("MetaData.Parser.ParseUsingHandler", filename, handlerName, this.validate ? "true" : "false"));
        }
        try {
            if (this.parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(this.validate);
                factory.setNamespaceAware(this.validate);
                if (this.validate) {
                    try {
                        factory.setFeature("http://apache.org/xml/features/validation/schema", true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.parser = factory.newSAXParser();
            }
            DefaultHandler handler = null;
            EntityResolver entityResolver = null;
            try {
                entityResolver = EntityResolverFactory.getInstance(this.mgr.getOMFContext().getPluginManager(), handlerName);
                if (entityResolver != null) {
                    this.parser.getXMLReader().setEntityResolver(entityResolver);
                }
                Class[] argTypes = new Class[]{class$org$jpox$metadata$MetaDataManager == null ? (class$org$jpox$metadata$MetaDataManager = MetaDataParser.class$("org.jpox.metadata.MetaDataManager")) : class$org$jpox$metadata$MetaDataManager, class$java$lang$String == null ? (class$java$lang$String = MetaDataParser.class$("java.lang.String")) : class$java$lang$String, class$org$xml$sax$EntityResolver == null ? (class$org$xml$sax$EntityResolver = MetaDataParser.class$("org.xml.sax.EntityResolver")) : class$org$xml$sax$EntityResolver};
                Object[] argValues = new Object[]{this.mgr, filename, entityResolver};
                handler = (DefaultHandler)this.mgr.getOMFContext().getPluginManager().createExecutableExtension("org.jpox.metadata_handler", "name", handlerName, "class-name", argTypes, argValues);
                if (handler == null) {
                    throw new JPOXUserException(LOCALISER.msg("MetaData.Parser.HandlerPluginNotFound", handlerName)).setFatal();
                }
            }
            catch (Exception e) {
                String msg = LOCALISER.msg("MetaData.Parser.HandlerCreateError", handlerName, e.getMessage());
                throw new JPOXException(msg, e);
            }
            this.parser.parse(in, handler);
            MetaData e = ((AbstractMetaDataHandler)handler).getMetaData();
            return e;
        }
        catch (JPOXException e) {
            throw e;
        }
        catch (Exception e) {
            Exception cause = e;
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                cause = se.getException();
            }
            if (JavaUtils.isJRE1_4OrAbove()) {
                cause = e.getCause() == null ? cause : e.getCause();
            }
            JPOXLogger.METADATA.error(LOCALISER.msg("MetaData.Parser.ErrorCause", filename, cause));
            if (cause instanceof InvalidMetaDataException) {
                throw (InvalidMetaDataException)cause;
            }
            String message = LOCALISER.msg("MetaData.Parser.CannotReadInput", e);
            throw new JPOXException(message, cause);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

