/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class MetaDataUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.metadata.Localisation");
    private static MetaDataUtils instance;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;

    public static synchronized MetaDataUtils getInstance() {
        if (instance == null) {
            instance = new MetaDataUtils();
        }
        return instance;
    }

    protected MetaDataUtils() {
    }

    public boolean arrayStorableAsByteArrayInSingleColumn(AbstractPropertyMetaData fmd) {
        if (fmd == null || !fmd.hasArray()) {
            return false;
        }
        String arrayComponentType = fmd.getType().getComponentType().getName();
        return arrayComponentType.equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER);
    }

    public boolean storesFCO(AbstractPropertyMetaData fmd, ClassLoaderResolver clr) {
        if (fmd == null) {
            return false;
        }
        MetaDataManager mgr = fmd.getAbstractClassMetaData().getMetaDataManager();
        if (fmd.isSerialized() || fmd.isEmbedded()) {
            return false;
        }
        if (fmd.hasCollection() && !fmd.getCollection().isSerializedElement() && !fmd.getCollection().isEmbeddedElement()) {
            if (fmd.getCollection().getElementClassMetaData() != null) {
                return true;
            }
            String elementType = fmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (elementCls != null && mgr.getOMFContext().getTypeManager().isReferenceType(elementCls) && mgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasMap()) {
            if (fmd.getMap().getKeyClassMetaData() != null && !fmd.getMap().isEmbeddedKey() && !fmd.getMap().isSerializedKey()) {
                return true;
            }
            String keyType = fmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (keyCls != null && mgr.getOMFContext().getTypeManager().isReferenceType(keyCls) && mgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (fmd.getMap().getValueClassMetaData() != null && !fmd.getMap().isEmbeddedValue() && !fmd.getMap().isSerializedValue()) {
                return true;
            }
            String valueType = fmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (valueCls != null && mgr.getOMFContext().getTypeManager().isReferenceType(valueCls) && mgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasArray() && !fmd.getArray().isSerializedElement() && !fmd.getArray().isEmbeddedElement()) {
            if ((class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = MetaDataUtils.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(fmd.getType().getComponentType())) {
                return true;
            }
        } else {
            if (mgr.getOMFContext().getTypeManager().isReferenceType(fmd.getType()) && mgr.getMetaDataForImplementationOfReference(fmd.getType(), null, clr) != null) {
                return true;
            }
            if (mgr.getMetaDataForClass(fmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public String[] getValuesForCommaSeparatedAttribute(String attr) {
        if (attr == null || attr.length() == 0) {
            return null;
        }
        String[] values = StringUtils.split(attr, ",");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }

    public String[] getImplementationNamesForReferenceField(AbstractPropertyMetaData fmd, int fieldRole, ClassLoaderResolver clr) {
        String[] implTypes = null;
        String implTypeStr = null;
        implTypeStr = 4 == fieldRole ? fmd.getArray().getElementType() : fmd.getFieldType();
        if (implTypeStr != null) {
            implTypes = this.getValuesForCommaSeparatedAttribute(implTypeStr);
        }
        if (implTypes == null) {
            implTypes = 3 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : (5 == fieldRole ? fmd.getValuesForExtension("key-implementation-classes") : (6 == fieldRole ? fmd.getValuesForExtension("value-implementation-classes") : (4 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : fmd.getValuesForExtension("implementation-classes"))));
        }
        if (implTypes == null) {
            String type = null;
            type = fmd.hasCollection() && fieldRole == 3 ? fmd.getCollection().getElementType() : (fmd.hasMap() && fieldRole == 5 ? fmd.getMap().getKeyType() : (fmd.hasMap() && fieldRole == 6 ? fmd.getMap().getValueType() : (fmd.hasArray() && fieldRole == 4 ? fmd.getType().getComponentType().getName() : fmd.getTypeName())));
            if (!type.equals(ClassNameConstants.OBJECT)) {
                implTypes = fmd.getAbstractClassMetaData().getMetaDataManager().getClassesImplementingInterface(type, clr);
            }
            if (implTypes == null) {
                throw new JPOXUserException(LOCALISER.msg("MetaData.Reference.NoImplementationClassesFound", fmd.getFullFieldName(), type));
            }
        }
        int noOfDups = 0;
        block0: for (int i = 0; i < implTypes.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                ++noOfDups;
                continue block0;
            }
        }
        String[] impls = new String[implTypes.length - noOfDups];
        int n = 0;
        for (int i = 0; i < implTypes.length; ++i) {
            boolean dup = false;
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            impls[n++] = implTypes[i];
        }
        return impls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

