/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.util.StringUtils;

public class QueryResultMetaData
extends MetaData {
    protected final String name;
    protected List persistentTypeMappings;
    protected List scalarColumns;

    public QueryResultMetaData(ExtendableMetaData parent, String name) {
        super(parent);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addPersistentTypeMapping(String className, Map fieldColumnMap, String discrimColumn) {
        if (this.persistentTypeMappings == null) {
            this.persistentTypeMappings = new ArrayList();
        }
        PersistentTypeMapping m = new PersistentTypeMapping();
        m.className = className;
        m.discriminatorColumn = StringUtils.isWhitespace(discrimColumn) ? null : discrimColumn;
        m.fieldColumnMap = fieldColumnMap;
        this.persistentTypeMappings.add(m);
    }

    public void addMappingForPersistentTypeMapping(String className, String fieldName, String columnName) {
        PersistentTypeMapping m = null;
        if (this.persistentTypeMappings == null) {
            this.persistentTypeMappings = new ArrayList();
        } else {
            Iterator iter = this.persistentTypeMappings.iterator();
            while (iter.hasNext()) {
                PersistentTypeMapping mapping = (PersistentTypeMapping)iter.next();
                if (!mapping.className.equals(className)) continue;
                m = mapping;
                break;
            }
        }
        if (m == null) {
            m = new PersistentTypeMapping();
            m.className = className;
        }
        if (m.fieldColumnMap == null) {
            m.fieldColumnMap = new HashMap();
        }
        m.fieldColumnMap.put(fieldName, columnName);
    }

    public void addScalarColumn(String columnName) {
        if (this.scalarColumns == null) {
            this.scalarColumns = new ArrayList();
        }
        this.scalarColumns.add(columnName);
    }

    public PersistentTypeMapping[] getPersistentTypeMappings() {
        if (this.persistentTypeMappings == null) {
            return null;
        }
        return this.persistentTypeMappings.toArray(new PersistentTypeMapping[this.persistentTypeMappings.size()]);
    }

    public String[] getScalarColumns() {
        if (this.scalarColumns == null) {
            return null;
        }
        return this.scalarColumns.toArray(new String[this.scalarColumns.size()]);
    }

    public class PersistentTypeMapping {
        String className;
        Map fieldColumnMap;
        String discriminatorColumn;

        public String getClassName() {
            return this.className;
        }

        public String getDiscriminatorColumn() {
            return this.discriminatorColumn;
        }

        public String getColumnForField(String fieldName) {
            if (this.fieldColumnMap == null) {
                return null;
            }
            return (String)this.fieldColumnMap.get(fieldName);
        }
    }
}

