/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.metadata;

import org.jpox.metadata.AbstractConstraintMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;

public class UniqueMetaData
extends AbstractConstraintMetaData
implements ColumnMetaDataContainer {
    final boolean deferred;

    public UniqueMetaData(UniqueMetaData umd) {
        super(null, umd.name, umd.table);
        int i;
        this.deferred = umd.deferred;
        for (i = 0; i < umd.fields.size(); ++i) {
            this.addField((AbstractPropertyMetaData)umd.fields.get(i));
        }
        for (i = 0; i < umd.columns.size(); ++i) {
            this.addColumn((ColumnMetaData)umd.columns.get(i));
        }
    }

    public UniqueMetaData(String name, String table, String deferredValue) {
        super(null, name, table);
        this.deferred = deferredValue != null && deferredValue.equalsIgnoreCase("true");
    }

    public void initialise() {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.fields.size() == 0) {
            this.fieldMetaData = null;
        } else {
            this.fieldMetaData = new AbstractPropertyMetaData[this.fields.size()];
            for (i = 0; i < this.fieldMetaData.length; ++i) {
                this.fieldMetaData[i] = (AbstractPropertyMetaData)this.fields.get(i);
                this.fieldMetaData[i].initialise();
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = (ColumnMetaData)this.columns.get(i);
                this.columnMetaData[i].initialise();
            }
        }
        this.fields.clear();
        this.fields = null;
        this.columns.clear();
        this.columns = null;
        this.setInitialised();
    }

    public final boolean isDeferred() {
        return this.deferred;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<unique");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.deferred) {
            sb.append(" deferred=\"true\"");
        }
        sb.append(this.name != null ? " name=\"" + this.name + "\">\n" : ">\n");
        if (this.fieldMetaData != null) {
            for (i = 0; i < this.fieldMetaData.length; ++i) {
                sb.append(this.fieldMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.columnMetaData != null) {
            for (i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</unique>\n");
        return sb.toString();
    }
}

